﻿var BlazorUniversity = BlazorUniversity || {};
BlazorUniversity.getBoundingRect = function (element) {
    return element.getBoundingClientRect();
};
BlazorUniversity.SaveFile = function (filename, contentType, content) {
    var link = document.createElement('a');
    document.body.appendChild(link); // Needed for Firefox
    link.download = filename;
    link.href = "data:" + contentType + ";base64, " + ToBase64(content);
    link.target = "_self";
    link.click();
    document.body.removeChild(link);
};
BlazorUniversity.PrintPDF = function () { window.print(); };
BlazorUniversity.getLocalDate = function () { return new Date(); };

BlazorUniversity.Alarm = function () {
    const ctx = new AudioContext();
    const osc = ctx.createOscillator();
    const gain = ctx.createGain();

    osc.type = 'sawtooth';         // موج تیزتر از sine
    osc.frequency.value = 2000;    // فرکانس بالا برای تیزی بیشتر
    gain.gain.value = 0.5;         // حجم صدا

    osc.connect(gain);
    gain.connect(ctx.destination);

    osc.start();
    osc.stop(ctx.currentTime + 0.35); // مدت زمان کوتاه
};
BlazorUniversity.Beep = function () {
    const ctx = new AudioContext();
    const osc = ctx.createOscillator();
    const gain = ctx.createGain();

    osc.type = 'square';             // موج مربعی برای صدای خشن‌تر
    osc.frequency.setValueAtTime(1600, ctx.currentTime); // شروع با فرکانس بالا
    osc.frequency.exponentialRampToValueAtTime(800, ctx.currentTime + 0.6); // افکت مشکوک: فرکانس افت می‌کنه

    gain.gain.setValueAtTime(0.6, ctx.currentTime); // صدای بلند
    gain.gain.exponentialRampToValueAtTime(0.01, ctx.currentTime + 0.6); // محو شدن سریع

    osc.connect(gain);
    gain.connect(ctx.destination);

    osc.start();
    osc.stop(ctx.currentTime + 0.6); // مدت زمان کوتاه و هشداردهنده
};
BlazorUniversity.WellcomeAlarm = function () {
    const ctx = new AudioContext();
    const osc = ctx.createOscillator();
    const gain = ctx.createGain();

    osc.type = 'sine'; // موج نرم و طبیعی
    osc.frequency.value = 440; // فرکانس ملایم (نت لا)
    gain.gain.setValueAtTime(0.001, ctx.currentTime); // شروع با حجم خیلی کم
    gain.gain.exponentialRampToValueAtTime(0.2, ctx.currentTime + 0.3);

    osc.connect(gain);
    gain.connect(ctx.destination);

    osc.start();
    osc.stop(ctx.currentTime + 0.6); // مدت زمان کوتاه و هشداردهنده
};

BlazorUniversity.AnimateNetworkStart = function () {
    var canvasDiv = document.getElementById('particle-canvas');
    var options = {
        velocity: 1,
        particleColor: '#00b0bd',
        background: '#000',
        interactive: true,
        density: 'high',
        netLineDistance: 200,
        speed: 'fase'
    };
    var particleCanvas = new ParticleNetwork(canvasDiv, options);
};
/* جهت ناپدید کردن کنترل های پاپ آپ */
BlazorUniversity.HidePopupElement = function (dotNetRef, element) {
    function handler(e) {
        if (!element.contains(e.target)) {
            dotNetRef.invokeMethodAsync("HideElement");
        }
    }
    /// حتما نگهدار بشه تا در زمان نابودی بشه صداش زد
    /// تابع پایینش
    element._outsideClickHandler = handler;
    document.addEventListener("pointerdown", handler);

};
BlazorUniversity.DisposePopupElement = function (element) {
    if (element._outsideClickHandler) {
        document.removeEventListener("pointerdown", element._outsideClickHandler);
        delete element._outsideClickHandler;
    }
};
/* جهت ناپدید کردن کنترل های پاپ آپ */

BlazorUniversity.SaveImageWithFeature = function (Buffer, xPlate, yPlate, wPlate, hPlate, Features) {
    var minH = 70;
    var img = document.createElement('img');
    img.onload = function () {
        var cnv = document.createElement("CANVAS");
        cnv.width = img.width;
        cnv.height = img.height + (hPlate < minH ? minH : hPlate);

        var ctx = cnv.getContext("2d");
        ctx.beginPath();
        ctx.fillStyle = "#fff"; /// Features BGColor
        ctx.rect(0, img.height, img.width, cnv.height);
        ctx.fill();

        ctx.drawImage(img, 0, 0, img.width, img.height);
        ctx.drawImage(img, xPlate, yPlate, wPlate, hPlate, 0, img.height, wPlate, hPlate);

        ctx.fillStyle = "#000";
        ctx.font = "30px BYekan";

        /// نمایش تاریخ - نام و شماره راننده
        ctx.fillText(Features[3], img.width - (ctx.measureText(Features[3]).width), img.height + 25);
        if (Features[1] == null) Features[1] = ""; if (Features[2] == null) Features[2] = "";
        ctx.fillText(Features[1] + "   " + Features[2], img.width - (ctx.measureText(Features[1] + "   " + Features[2]).width), img.height + 55);

        /// نمایش نام دستگاه - نام و محل دوربین
        ctx.fillText(Features[10], wPlate + 15 + 230, img.height + 25);
        ctx.fillText(Features[11], wPlate + 15 + 230, img.height + 55);

        /// نمایش پلاک مجازی
        ctx.beginPath();
        ctx.strokeStyle = "#000";
        ctx.fillStyle = Features[8]; /// اصل پلاک
        ctx.roundRect(wPlate + 5, img.height + 3, 230, minH - 20, [new DOMPoint(3, 3), new DOMPoint(3, 3)]);
        ctx.stroke();
        ctx.fill();
        ctx.beginPath();
        ctx.fillStyle = "#02339A";/// رنگ آبی پلاک
        ctx.roundRect(wPlate + 5, img.height + 3, 22, minH - 20, [new DOMPoint(3, 3), new DOMPoint(3, 3)]);
        ctx.fill();
        ctx.beginPath();
        ctx.fillStyle = "#000";/// رنگ سیاه جداکننده
        ctx.rect(wPlate + 185, img.height + 5, 3, minH - 23);
        ctx.fill();

        ctx.font = "30px Traffic";
        ctx.fillStyle = Features[7];
        ctx.fillText(Features[4], wPlate + 30, img.height + 35);
        ctx.fillText(Features[5], wPlate + 30 + ctx.measureText(Features[4]).width + 20, img.height + 35);
        ctx.fillText(Features[6], wPlate + 60 + ctx.measureText(Features[5]).width + 46, img.height + 35);

        var link = document.createElement('a');
        link.download = Features[0] + '.jpg';
        link.href = cnv.toDataURL();
        link.click();
    }
    img.src = "data:image/jpg;base64, " + ToBase64(Buffer);
}
async function SetStreaming(s, _Stream) {
    const _arr = await _Stream.arrayBuffer();
    s.setAttributeNS('http://www.w3.org/1999/xlink', 'href', "data:image/jpg;base64," + ToBase64(_arr));
    return true;
}
function ToBase64_Old(buffer) {
    var binary = '';
    var bytes = new Uint8Array(buffer);
    var len = bytes.byteLength; //console.log("arr len: " + len + " Bytes");
    for (var i = 0; i < len; i++) binary += String.fromCharCode(bytes[i]);
    return window.btoa(binary);
}
function ToBase64(buffer) {
    let binary = '';
    const bytes = new Uint8Array(buffer);
    bytes.forEach(b => binary += String.fromCharCode(b));
    return window.btoa(binary);
}

var sx, sy;
function DialogBoxMouseMove(s, e) {
    if (e.buttons == 1) {
        s.style.cursor = "move";
        s.scrollLeft -= (e.offsetX - sx);
        s.scrollTop -= (e.offsetY - sy);
    }
    else {
        s.style.cursor = "default";
        sx = e.offsetX;
        sy = e.offsetY;
    }
}
/// limit input number length
function chkLen(s, len) {
    return s.value.length < len;
}
function isNumberKey(evt) {
    var charCode = (evt.which) ? evt.which : evt.keyCode
    return !(charCode > 31 && (charCode < 48 || charCode > 57));
}
function DragAndDrop(id) {
    //const el = document.getElementById(id);
    const el = document.getElementsByClassName(id)[0];
    const parent = el.parentElement;

    let offsetX = 0, offsetY = 0, isDragging = false;

    el.addEventListener('mousedown', function (e) {
        isDragging = true;
        offsetX = e.clientX - parent.offsetLeft;
        offsetY = e.clientY - parent.offsetTop;
    });

    document.addEventListener('mousemove', function (e) {
        if (isDragging) {
            parent.style.left = (e.clientX - offsetX) + 'px';
            parent.style.top = (e.clientY - offsetY) + 'px';
        }
    });

    document.addEventListener('mouseup', function () {
        isDragging = false;
    });
}