﻿const connection = new signalR.HubConnectionBuilder()
    .withUrl("/frameHub")
    .configureLogging(signalR.LogLevel.Information)
    .withAutomaticReconnect()
    .build();

connection.on("ReceiveFrame", function (data) {
    const { cameraId, imageArr } = data;

    const _img = document.getElementById(cameraId);
    _img.setAttribute("href", "data:image/jpeg;base64," + imageArr);
});

connection.start()
    .then(() => console.log("SignalR connected"))
    .catch(err => console.error("SignalR connection failed:", err));
