#ifndef __TDKTYPE_H__
#define __TDKTYPE_H__

#ifdef __cplusplus
#define	TDKAPIC	extern "C"
#else
#define	TDKAPIC
#endif

#if( defined(WIN32))
#define	_CRT_SECURE_NO_WARNINGS	1
#ifndef WINVER                  // Specifies that the minimum required platform is Windows Vista.
#define WINVER 0x0600           // Change this to the appropriate value to target other versions of Windows.
#endif
#ifndef _WIN32_WINNT            // Specifies that the minimum required platform is Windows Vista.
#define _WIN32_WINNT 0x0600     // Change this to the appropriate value to target other versions of Windows.
#endif
#ifndef _WIN32_WINDOWS          // Specifies that the minimum required platform is Windows 98.
#define _WIN32_WINDOWS 0x0410	// Change this to the appropriate value to target Windows Me or later.
#endif
#ifndef _WIN32_IE               // Specifies that the minimum required platform is Internet Explorer 7.0.
#define _WIN32_IE 0x0700        // Change this to the appropriate value to target other versions of IE.
#endif

#ifndef _WINDOWS_
#define WIN32_LEAN_AND_MEAN     // Exclude rarely-used stuff from Windows headers
#include <windows.h>
#include <Winsock2.h>
#include <Ws2tcpip.h>
#pragma comment(lib, "ws2_32.lib")
#endif

#ifndef __GNUC__
#define TDKAPI	WINAPI
#else
#define TDKAPI
#endif

#ifdef TDKSDK_EXPORTS
#define	TDKSDKAPI TDKAPIC __declspec(dllexport)
#else
#define	TDKSDKAPI TDKAPIC __declspec(dllimport)
#endif


#elif( defined(LINUX) )
// linux 
#define	TDKAPI
#define	TDKSDKAPI
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#else

#error !!!!!!!!!!!!Unsupported OS!!!!!!!!!!!!!

#endif

typedef void*				TDKHANDLE;
typedef char				TDKS8;
typedef short				TDKS16;
typedef int					TDKS32;
typedef long long			TDKS64;
typedef unsigned char		TDKU8;
typedef unsigned short		TDKU16;
typedef unsigned int		TDKU32;
typedef unsigned long long	TDKU64;
typedef int					TDKBOOL;
#if( !defined(TRUE) )
#define	TRUE	1
#endif
#if( !defined(FALSE))
#define FALSE	0
#endif
#if( !defined(IN))
#define IN
#endif
#if( !defined(OUT))
#define OUT
#endif
#if( !defined(INOUT))
#define INOUT
#endif

typedef struct tag_TDK_POINT32
{
	TDKS32	x;
	TDKS32	y;
}TDK_POINT32, *PTDK_POINT32;

typedef struct tag_TDK_POINT16
{
	TDKS16	x;
	TDKS16	y;
}TDK_POINT16, *PTDK_POINT16;

typedef struct tag_TDK_RECT32
{
	TDKS32	x;
	TDKS32	y;
	TDKS32	w;
	TDKS32	h;
}TDK_RECT32, *PTDK_RECT32;

typedef struct tag_TDK_RECT16
{
	TDKS16	x;
	TDKS16	y;
	TDKS16	w;
	TDKS16	h;
}TDK_RECT16, *PTDK_RECT16;

// system time struct [ϵͳʱṹ]
typedef struct tag_TDK_SYSTEM_TIME
{
	TDKS32  year;	//year [2000,2037] [ꡣ[2000,2037]]   
	TDKS32  month;	//month January = 1, February = 2, and so on. [£January = 1, February = 2, and so on. ]  
	TDKS32  day;	//day [ա]   
	TDKS32  wday;	//week, Sunday = 0, Monday = 1, and so on [ڣSunday = 0, Monday = 1, and so on]   
	TDKS32  hour;	//hour [ʱ]   
	TDKS32  minute;//minute [֡]  
	TDKS32  second;//second [롣]   
	TDKS32  isdst;	//flag daylight saving time [ʱʶ]   
}TDK_SYSTEM_TIME;

/****************************************************************************\
						صԭ
\****************************************************************************/
typedef int (TDKAPI *TDKCALLBACK)(void* context, TDKU32 cmd, void* param0, void* param1, void* param2);


/****************************************************************************\
						붨
\****************************************************************************/
#define	TDK_OK					(0)
#define	TDK_FAIL				(-1)
#define	TDKERR_TIMEOUT			(-2)
#define	TDKERR_PENDING			(-3)
#define	TDKERR_PARAMETER		(-4)
#define	TDKERR_HANDLE			(-5)
#define	TDKERR_MEMORY			(-6)
#define	TDKERR_STATE			(-7)
#define	TDKERR_FULL				(-8)
#define	TDKERR_EMPTY			(-9)
#define TDKERR_SUPPORT			(-10)
#define	TDKERR_FOUND			(-11)
#define	TDKERR_RESOURCE			(-12)
#define	TDKERR_SEND				(-13)
#define	TDKERR_RECV				(-14)
#define	TDKERR_FORMAT			(-15)
#define	TDKERR_AUTHEN			(-16)
#define TDKERR_EXISTED			(-17)
#define TDKERR_END				(-18)
#define	TDKERR_CANCELLED		(-19)
#define	TDKERR_FILE_OPEN 		(-20)
#define	TDKERR_FILE_WRITE 		(-21)
#define	TDKERR_DISK_FULL 		(-22)
#define	TDKERR_FOLDER_CREATE	(-23)
#define	TDKERR_FILE_READ 		(-24)
#define	TDKERR_ADDRESS			(-25)
#define TDKERR_REMOVED			(-26)
#define TDKERR_BUSY				(-27)
#define TDKERR_NETWORK			(-28)
#define TDKERR_PASSWORD			(-29)
#define TDKERR_ACCOUNT			(-30)
#define TDKERR_RELOGIN			(-31)
#define TDKERR_LOCKED			(-32)
#define TDKERR_BLACKLIST		(-33)
#define TDKERR_NOT_FIND_HOST	(-34)
#define TDKERR_INACTIVE			(-35)
#define TDKERR_CUSTOMER_NUM		(-36)
#define TDKERR_CAMERA_CLOSED	(-37)
#define	TDKERR_FS				(-38)
/****************************************************************************\
			״̬붨
\****************************************************************************/
#define	TDKSTATE_STREAM_CLOSE		0
#define	TDKSTATE_STREAM_OPEN			1
#define	TDKSTATE_STREAM_CONNECTING 2
#define	TDKSTATE_STREAM_DISCONNECT	 3
#define	TDKSTATE_STREAM_START		    4
#define	TDKSTATE_STREAM_STOP			5
#define TDKSTATE_STREAM_RECONNECT		6

#endif//__TDKTYPE_H__