#ifndef __TDKSDK_H__
#define __TDKSDK_H__
#include "TDKType.h"
#include "TDKMedia.h"
#include "TDKConfig.h"
#include "TDKPanel.h"
#include "TDKIConfig.h"

/********************************************************************************************\
							ϵͳӿ
\********************************************************************************************/
TDKSDKAPI int	TDKAPI TDKSDKInitialize(void);
TDKSDKAPI int	TDKAPI TDKSDKInitializEx(IN TDK_GLOBAL_PARAM* param);
TDKSDKAPI int	TDKAPI TDKSDKInvalidate(void);

/********************************************************************************************\
							صӿ
\********************************************************************************************/
/*
	ص
*/
TDKSDKAPI TDKHANDLE	TDKAPI TDKCBCreate(IN void* context, IN TDKCALLBACK func);

/*
	ɾص
*/
TDKSDKAPI void		TDKAPI TDKCBDelete(IN TDKHANDLE hCallback);
#define	TDKSDK_MSG_BASE			(1000)

/********************************************************************************************\
							ӿ
\********************************************************************************************/
#define	TDKSMART_MSG_BASE		(TDKSDK_MSG_BASE	+ 0)
#define	TDKSMART_MSG_STATE		(TDKSMART_MSG_BASE	+ 0)
//param0:	
//param1:	TDKU32	state
//param2:	TDKS32	error
#define	TDKSMART_MSG_FRAME		(TDKSMART_MSG_BASE	+ 1)
//param0:
//param1:	TDKHANDLE	 hFrame
//param2:	NULL

TDKSDKAPI TDKHANDLE	TDKAPI TDKSmart_Create(void);
TDKSDKAPI int		TDKAPI TDKSmart_Delete(IN TDKHANDLE hStream);
TDKSDKAPI int		TDKAPI TDKSmart_Attach(IN TDKHANDLE hStream, IN TDKHANDLE hCallback);
TDKSDKAPI int		TDKAPI TDKSmart_Detach(IN TDKHANDLE hStream, IN TDKHANDLE hCallback);
TDKSDKAPI int		TDKAPI TDKSmart_Open(IN TDKHANDLE hStream, IN const char* address, IN TDKU16 port, IN const char* username, IN const char* password);
TDKSDKAPI int		TDKAPI TDKSmart_Close(IN TDKHANDLE hStream);

/********************************************************************************************\
							֡ӿ
\********************************************************************************************/
TDKSDKAPI int					TDKAPI TDKSmart_Frame_GetPicture(IN TDKHANDLE hFrame, INOUT TDK_SMART_PIC* pic);
TDKSDKAPI int					TDKAPI TDKSmart_Frame_GetFaceNum(IN TDKHANDLE hFrame);
TDKSDKAPI TDKHANDLE				TDKAPI TDKSmart_Frame_GetFace(IN TDKHANDLE hFrame, IN TDKS32 idx);
TDKSDKAPI const TDK_FACEOBJ* TDKAPI TDKSmart_Face_GetInfo(IN TDKHANDLE hFace);
TDKSDKAPI const TDK_FACE_ATTR*	TDKAPI TDKSmart_Face_GetAttr(IN TDKHANDLE hFace);
TDKSDKAPI int					TDKAPI TDKSmart_Face_GetPicture(IN TDKHANDLE hFace, INOUT TDK_SMART_PIC* pic);
TDKSDKAPI int					TDKAPI TDKSmart_Face_GetPictureEx(IN TDKHANDLE hFace, INOUT TDK_SMART_PIC* pic);

TDKSDKAPI int					TDKAPI TDKSmart_Frame_GetLicensePlateNum(IN TDKHANDLE hFrame);
TDKSDKAPI TDKHANDLE				TDKAPI TDKSmart_Frame_GetLicensePlate(IN TDKHANDLE hFrame, IN TDKS32 idx);
TDKSDKAPI const TDK_LICENCEPALTE_OBJ* TDKAPI TDKSmart_LicensePlate_GetInfo(IN TDKHANDLE hLicensePlate);
TDKSDKAPI int					TDKAPI TDKSmart_LicensePlate_GetPicture(IN TDKHANDLE hLicensePlate, INOUT TDK_SMART_PIC* pic);

TDKSDKAPI int					TDKAPI TDKSmart_Frame_GetSmartCount(IN TDKHANDLE hFrame, IN TDKU32 type);
TDKSDKAPI const TDK_SMART_OBJ*  TDKAPI TDKSmart_Frame_GetSmartInfo(IN TDKHANDLE hFrame, IN TDKU32 type, IN TDKU32 index);
/********************************************************************************************\
							Ƶӿ(Ԥط)
\********************************************************************************************/
#define	TDKPLAYER_MSG_BASE		(TDKSDK_MSG_BASE	+ 1000)
#define	TDKPLAYER_MSG_STATE		(TDKPLAYER_MSG_BASE	+ 0)
//param0:	
//param1:	TDKU32	state
//param2:	TDKS32	error
#define	TDKPLAYER_MSG_FRAME		(TDKPLAYER_MSG_BASE	+ 1)
//param0:
//param1:	TDK_PICTURE*
//param2:	NULL
#define	TDKPLAYER_MSG_PACKET	(TDKPLAYER_MSG_BASE	+ 2)
//param0:
//param1:	TDK_FRAMEHEAD*
//param2:	NULL
TDKSDKAPI TDKHANDLE	TDKAPI TDKPlayer_Create(IN TDKHANDLE hWnd, IN TDKS32 type);
TDKSDKAPI int		TDKAPI TDKPlayer_Delete(IN TDKHANDLE hPlayer);
TDKSDKAPI int		TDKAPI TDKPlayer_Attach(IN TDKHANDLE hPlayer, IN TDKHANDLE hCallback);
TDKSDKAPI int		TDKAPI TDKPlayer_Detach(IN TDKHANDLE hPlayer, IN TDKHANDLE hCallback);
TDKSDKAPI int		TDKAPI TDKPlayer_AttachDecode(IN TDKHANDLE hPlayer, IN TDKHANDLE hCallback);
TDKSDKAPI int		TDKAPI TDKPlayer_DetachDecode(IN TDKHANDLE hPlayer, IN TDKHANDLE hCallback);
TDKSDKAPI int		TDKAPI TDKPlayer_Open(IN TDKHANDLE hPlayer, IN const char* uri, IN const char* username, IN const char* password);
TDKSDKAPI int		TDKAPI TDKPlayer_OpenFile(IN TDKHANDLE hPlayer, IN const char* uri, IN const char* username, IN const char* password, IN TDK_FILE_INFO* list, IN TDKU32 count);
TDKSDKAPI int		TDKAPI TDKPlayer_Close(IN TDKHANDLE hPlayer);
TDKSDKAPI int		TDKAPI TDKPlayer_Start(IN TDKHANDLE hPlayer);
TDKSDKAPI int		TDKAPI TDKPlayer_Stop(IN TDKHANDLE hPlayer);
TDKSDKAPI int		TDKAPI TDKPlayer_SwitchStream(IN TDKHANDLE hPlayer, IN TDKS32 type/*TDK_STREAM_MAIN*/);
TDKSDKAPI int		TDKAPI TDKPlayer_ShowSmart(IN TDKHANDLE hPlayer, IN TDKS32 typemask);
TDKSDKAPI int		TDKAPI TDKPlayer_Pause(IN TDKHANDLE hPlayer);
TDKSDKAPI int		TDKAPI TDKPlayer_Resume(IN TDKHANDLE hPlayer);
TDKSDKAPI int		TDKAPI TDKPlayer_GetState(IN TDKHANDLE hPlayer, OUT TDKU32* state);
TDKSDKAPI int		TDKAPI TDKPlayer_SeekTime(IN TDKHANDLE hPlayer, IN TDK_SYSTEM_TIME* time);
TDKSDKAPI int		TDKAPI TDKPlayer_SeekFile(IN TDKHANDLE hPlayer, IN TDK_FILE_INFO* file);
TDKSDKAPI int		TDKAPI TDKPlayer_SeekNextFile(IN TDKHANDLE hPlayer);
TDKSDKAPI int		TDKAPI TDKPlayer_SeekPrevFile(IN TDKHANDLE hPlayer);

/** player mode that control play in normal or reverse way **/
TDKSDKAPI int		TDKAPI TDKPlayer_SetPlayerMode(IN TDKHANDLE hPlayer, IN int mode);
TDKSDKAPI int		TDKAPI TDKPlayer_SetZoomWindow(IN TDKHANDLE hPlayer, IN TDKHANDLE hWnd);
TDKSDKAPI int		TDKAPI TDKPlayer_SetPlayerZoom(IN TDKHANDLE hPlayer, IN RECT* rectzoom, IN RECT* controlrect);
TDKSDKAPI int		TDKAPI TDKPlayer_SetPlayerSetZoomRECT(IN TDKHANDLE hPlayer, IN RECT* rectzoom);
TDKSDKAPI int		TDKAPI TDKPlayer_TaskSync(IN TDKHANDLE hPlayer, IN int enable);
//TDKSDKAPI int		TDKAPI QVPlayerZoom(HANDLE hPlayer, RECT* rectzoom);

//play speed
#define TDKPLAYER_SPEED_SLOW8	   -8
#define TDKPLAYER_SPEED_SLOW4	   -4
#define TDKPLAYER_SPEED_SLOW2	   -2
#define TDKPLAYER_SPEED_NORMAL		1
#define TDKPLAYER_SPEED_FAST2		2
#define TDKPLAYER_SPEED_FAST4		4
#define TDKPLAYER_SPEED_FAST8		8
TDKSDKAPI int TDKAPI TDKPlayer_SetSpeed(IN TDKHANDLE hPlayer, IN TDKS32 speed/*TDKPLAYER_SPEED_NORMAL*/);
TDKSDKAPI int TDKAPI TDKPlayer_Step(IN TDKHANDLE hPlayer);
TDKSDKAPI int TDKAPI TDKPlayer_SetBitrate(IN TDKHANDLE hPlayer, IN TDKU64 bitrate/*bps*/);
TDKSDKAPI int TDKAPI TDKPlayer_Listen(IN TDKHANDLE hPlayer, IN TDKBOOL enable);
TDKSDKAPI int TDKAPI TDKPlayer_GetPlaybackTime(IN TDKHANDLE hPlayer, INOUT TDK_SYSTEM_TIME* time);
TDKSDKAPI int TDKAPI TDKPlayer_Snapshot(IN TDKHANDLE hPlayer, IN const char* picname, IN TDK_IMAGE_FORMAT format);
TDKSDKAPI int TDKAPI TDKPlayer_StartRecord(IN TDKHANDLE hPlayer, IN const char* filename, IN const char* picname, IN TDK_IMAGE_FORMAT picfmt);
TDKSDKAPI int TDKAPI TDKPlayer_StopRecord(IN TDKHANDLE hPlayer);
/****************************************************************************************\
					Media file search API
\****************************************************************************************/
TDKSDKAPI int TDKAPI TDKMedia_Search(IN const char* uri, IN const char* username, IN const char* password, IN TDK_FILE_SEARCH_PARAM* param, IN TDKU32 maxnum, OUT TDK_FILE_INFO* result, OUT TDKU32* count);
//get the handle of searching 
TDKSDKAPI HANDLE TDKAPI TDKMediaSearch_Create(IN const char* uri, IN const char* username, IN const char* password, IN TDK_FILE_SEARCH_PARAM* param);
// delete handle created by TDKMediaSearchCreate
TDKSDKAPI int TDKAPI TDKMediaSearch_Delete(IN HANDLE h);
// search files 
TDKSDKAPI int TDKAPI TDKAPI TDKMediaSearch_Next(IN HANDLE h, IN TDKU32 maxnum, OUT TDK_FILE_INFO* result, OUT TDKU32* count);
// get record summary information
TDKSDKAPI int TDKAPI TDKMediaSearch_GetSummary(IN const char* uri, IN const char* username, IN const char* password, IN TDK_FILE_SUMMARY_SEARCH_PARAM* param, OUT TDKU32* result);
/****************************************************************************************\
					Media file download API
\****************************************************************************************/
#define	TDKDOWNLOAD_MSG_BASE		(TDKSDK_MSG_BASE	+ 1200)
#define	TDKDOWNLOAD_MSG_PACKET	(TDKDOWNLOAD_MSG_BASE	+ 0)
//param0:
//param1:	TDK_FRAMEHEAD*
//param2:	NULL
TDKSDKAPI TDKHANDLE TDKAPI TDKDownload_Create(void);
TDKSDKAPI int TDKAPI TDKDownload_Delete(IN TDKHANDLE hDownload);
TDKSDKAPI int TDKAPI TDKDownload_Attach(IN TDKHANDLE hDownload, IN TDKHANDLE hCallback);
TDKSDKAPI int TDKAPI TDKDownload_Detach(IN TDKHANDLE hDownload, IN TDKHANDLE hCallback);
TDKSDKAPI int TDKAPI TDKDownload_OpenByTime(IN TDKHANDLE hDownload, IN const char* url, IN const char* username, IN const char* password, IN const TDK_DOWNLOAD_PARAM_TIME* param);
TDKSDKAPI int TDKAPI TDKDownload_OpenByFile(IN TDKHANDLE hDownload, IN const char* url, IN const char* username, IN const char* password, IN const TDK_DOWNLOAD_PARAM_FILE* param);
TDKSDKAPI int TDKAPI TDKDownload_Close(IN TDKHANDLE hDownload);
TDKSDKAPI int TDKAPI TDKDownload_Start(IN TDKHANDLE hDownload);
TDKSDKAPI int TDKAPI TDKDownload_Stop(IN TDKHANDLE hDownload);
TDKSDKAPI int TDKAPI TDKDownload_GetProgress(IN TDKHANDLE hDownload, OUT TDKU32* state, OUT TDKS32* error, OUT TDKU32* progress);
TDKSDKAPI int TDKAPI TDKDownload_GetBitrate(IN TDKHANDLE hDownload, OUT TDKU64* bitrate);
/****************************************************************************************\
					Talk and broadcast API
\****************************************************************************************/
TDKSDKAPI TDKHANDLE TDKAPI TDKTalk_CreateEx(void);
TDKSDKAPI int TDKAPI TDKTalk_DeleteEx(IN TDKHANDLE hTalk);
TDKSDKAPI int TDKAPI TDKTalk_StartEx(IN TDKHANDLE hTalk, IN const char* url, IN const char* username, IN const char* password);
TDKSDKAPI int TDKAPI TDKTalk_StopEx(IN TDKHANDLE hTalk, IN const char* url, IN const char* username, IN const char* password);
/****************************************************************************************\
					Talk data transparent transmission API
\****************************************************************************************/
#define	TDKTALK_MSG_BASE		(TDKSDK_MSG_BASE	+ 2000)
#define	TDKTALK_MSG_PACKET		(TDKTALK_MSG_BASE	+ 0)
//param0:
//param1:	TDK_FRAMEHEAD*
//param2:	NULL
#define	TDKTALK_MSG_STATE		(TDKTALK_MSG_BASE	+ 1)
//param0:	
//param1:	TDKU32	state
//param2:	TDKS32	error
TDKSDKAPI TDKHANDLE TDKAPI TDKTalk_Create(void);
TDKSDKAPI int TDKAPI TDKTalk_Delete(IN TDKHANDLE hTalk);
TDKSDKAPI int TDKAPI TDKTalk_Attach(IN TDKHANDLE hTalk, IN TDKHANDLE hCallback);
TDKSDKAPI int TDKAPI TDKTalk_Detach(IN TDKHANDLE hTalk, IN TDKHANDLE hCallback);
TDKSDKAPI int TDKAPI TDKTalk_Open(IN TDKHANDLE hTalk, IN const char* url, IN const char* username, IN const char* password, IN TDKS32 codec/*TDKCODEC_PCMA*/, IN TDKU32 samples/*8000*/);
TDKSDKAPI int TDKAPI TDKTalk_Close(IN TDKHANDLE hTalk);
TDKSDKAPI int TDKAPI TDKTalk_SendData(IN TDKHANDLE hTalk, IN char* data, IN TDKS32 length);

/****************************************************************************************\
					Alarm listen API
\****************************************************************************************/
#define	TDKALARM_MSG_BASE		(TDKSDK_MSG_BASE	+ 2100)
#define	TDKALARM_MSG_ALARM	(TDKALARM_MSG_BASE	+ 0)
//param0:
//param1:	TDK_ALARM_INFO*
//param2:	NULL
TDKSDKAPI TDKHANDLE TDKAPI TDKAlarm_Create(void);
TDKSDKAPI int TDKAPI TDKAlarm_Delete(IN TDKHANDLE hAlarm);
TDKSDKAPI int TDKAPI TDKAlarm_Attach(IN TDKHANDLE hAlarm, IN TDKHANDLE hCallback);
TDKSDKAPI int TDKAPI TDKAlarm_Detach(IN TDKHANDLE hAlarm, IN TDKHANDLE hCallback);
TDKSDKAPI int TDKAPI TDKAlarm_Open(IN TDKHANDLE hAlarm, IN const char* url, IN const char* username, IN const char* password);
TDKSDKAPI int TDKAPI TDKAlarm_Close(IN TDKHANDLE hAlarm);

/********************************************************************************************\
				Device config/operate API
\********************************************************************************************/
#define	TDKDEVICE_MSG_BASE				(TDKSDK_MSG_BASE	+ 2200)
#define	TDKDEVICE_MSG_UPGRADE_PROGRESS	(TDKDEVICE_MSG_BASE	+ 0)
#define	TDKDEVICE_MSG_DEV_SEARCH		(TDKDEVICE_MSG_BASE	+ 1)
#define	TDKDEVICE_MSG_STATE				(TDKDEVICE_MSG_BASE	+ 2)
#define TDKDEVICE_MSG_ONLINE			(TDKDEVICE_MSG_BASE + 3)
//param0:	
//param1:	TDKU32	state
//param2:	TDKS32	error

TDKSDKAPI int TDKAPI TDKDevice_Search(IN const TDK_DEVICE_SEARCH_PARAM* search_param);

TDKSDKAPI TDKHANDLE TDKAPI TDKDevice_Create(void);
TDKSDKAPI int TDKAPI TDKDevice_Delete(IN TDKHANDLE hDevice);
TDKSDKAPI int TDKAPI TDKDevice_Attach(IN TDKHANDLE hDevice, IN TDKHANDLE hCallback);
TDKSDKAPI int TDKAPI TDKDevice_Detach(IN TDKHANDLE hDevice, IN TDKHANDLE hCallback);
//
TDKSDKAPI int TDKAPI TDKDevice_Open(IN TDKHANDLE hDevice, IN const char* address, IN TDKU16 port, IN const char* username, IN const char* password);
TDKSDKAPI int TDKAPI TDKDevice_OpenEx(IN TDKHANDLE hDevice, IN const char* url, IN const char* username, IN const char* password);
TDKSDKAPI int TDKAPI TDKDevice_Close(IN TDKHANDLE hDevice);
TDKSDKAPI int TDKAPI TDKDevice_ExportConfig(IN TDKHANDLE hDevice, IN const char* szFileName);
TDKSDKAPI int TDKAPI TDKDevice_ImportConfig(IN TDKHANDLE hDevice, IN const char* szFileName);
TDKSDKAPI int TDKAPI TDKDevice_Upgrade(IN TDKHANDLE hDevice, IN const char* szFileName, IN TDKHANDLE hCallback);
TDKSDKAPI int TDKAPI TDKDevice_GetDeviceInfo(IN TDKHANDLE hDevice,OUT TDK_DEVICE_INFO* pdevInfo);
TDKSDKAPI int TDKAPI TDKDevice_GetTime(IN TDKHANDLE hDevice, OUT TDK_TIME_CONFIG* time);
TDKSDKAPI int TDKAPI TDKDevice_SetTime(IN TDKHANDLE hDevice, IN const TDK_TIME_CONFIG* time);
TDKSDKAPI int TDKAPI TDKDevice_GetOSDConfig(IN TDKHANDLE hDevice, INOUT TDK_OSD_CONFIG* config);
TDKSDKAPI int TDKAPI TDKDevice_SetOSDConfig(IN TDKHANDLE hDevice, IN const TDK_OSD_CONFIG* config);
TDKSDKAPI int TDKAPI TDKDevice_GetNTPConfig(IN TDKHANDLE hDevice, OUT TDK_NTP_CONFIG* config);
TDKSDKAPI int TDKAPI TDKDevice_SetNTPConfig(IN TDKHANDLE hDevice, IN const TDK_NTP_CONFIG* config);
TDKSDKAPI int TDKAPI TDKDevice_GetUserConfig(IN TDKHANDLE hDevice, OUT TDK_USER_MANAGE_CONFIG* config);
TDKSDKAPI int TDKAPI TDKDevice_AddGroup(IN TDKHANDLE hDevice, IN const TDK_USER_GROUP_CONFIG* config);
TDKSDKAPI int TDKAPI TDKDevice_ModifyGroup(IN TDKHANDLE hDevice, IN const TDK_USER_GROUP_CONFIG* oldcfg, IN const TDK_USER_GROUP_CONFIG* newcfg);
TDKSDKAPI int TDKAPI TDKDevice_DeleteGroup(IN TDKHANDLE hDevice, IN const TDK_USER_GROUP_CONFIG* config);
TDKSDKAPI int TDKAPI TDKDevice_AddUser(IN TDKHANDLE hDevice, IN const TDK_USER_CONFIG* config);
TDKSDKAPI int TDKAPI TDKDevice_ModifyUser(IN TDKHANDLE hDevice, IN const TDK_USER_CONFIG* oldcfg, IN const TDK_USER_CONFIG* newcfg);
TDKSDKAPI int TDKAPI TDKDevice_DeleteUser(IN TDKHANDLE hDevice, IN const TDK_USER_CONFIG* config);
TDKSDKAPI int TDKAPI TDKDevice_ModifyPassword(IN TDKHANDLE hDevice, IN const TDK_USER_CONFIG* oldcfg, IN const TDK_USER_CONFIG* newcfg);
TDKSDKAPI int TDKAPI TDKDevice_GetChannelState(IN TDKHANDLE hDevice, IN TDKS32 chn, OUT TDK_CHANNELS_STATE* state);
TDKSDKAPI int TDKAPI TDKDevice_GetFaceDetection(IN TDKHANDLE hDevice, IN TDKS32 chn, OUT TDK_FACE_DETECTION_CONFIG* config);
TDKSDKAPI int TDKAPI TDKDevice_SetFaceDetection(IN TDKHANDLE hDevice, IN TDKS32 chn, IN const TDK_FACE_DETECTION_CONFIG* config);
TDKSDKAPI int TDKAPI TDKDevice_GetLineCrossing(IN TDKHANDLE hDevice, IN TDKS32 chn, OUT TDK_LINE_CROSSING_CONFIG* config);
TDKSDKAPI int TDKAPI TDKDevice_SetLineCrossing(IN TDKHANDLE hDevice, IN TDKS32 chn, IN const TDK_LINE_CROSSING_CONFIG* config);
TDKSDKAPI int TDKAPI TDKDevice_GetAreaIntrusion(IN TDKHANDLE hDevice, IN TDKS32 chn, OUT TDK_AREA_INTRUSION_CONFIG* config);
TDKSDKAPI int TDKAPI TDKDevice_SetAreaIntrusion(IN TDKHANDLE hDevice, IN TDKS32 chn, IN const TDK_AREA_INTRUSION_CONFIG* config);
TDKSDKAPI int TDKAPI TDKDevice_GetUnattendedObject(IN TDKHANDLE hDevice, IN TDKS32 chn, OUT TDK_UNATTENDED_OBJECT_CONFIG* config);
TDKSDKAPI int TDKAPI TDKDevice_SetUnattendedObject(IN TDKHANDLE hDevice, IN TDKS32 chn, IN const TDK_UNATTENDED_OBJECT_CONFIG* config);
TDKSDKAPI int TDKAPI TDKDevice_GetObjectMissing(IN TDKHANDLE hDevice, IN TDKS32 chn, OUT TDK_OBJECT_MISSING_CONFIG* config);
TDKSDKAPI int TDKAPI TDKDevice_SetObjectMissing(IN TDKHANDLE hDevice, IN TDKS32 chn, IN const TDK_OBJECT_MISSING_CONFIG* config);
TDKSDKAPI int TDKAPI TDKDevice_GetRegionEntrance(IN TDKHANDLE hDevice, IN TDKS32 chn, OUT TDK_REGION_ENTRANCE_CONFIG* config);
TDKSDKAPI int TDKAPI TDKDevice_SetRegionEntrance(IN TDKHANDLE hDevice, IN TDKS32 chn, IN const TDK_REGION_ENTRANCE_CONFIG* config);
TDKSDKAPI int TDKAPI TDKDevice_GetRegionExiting(IN TDKHANDLE hDevice, IN TDKS32 chn, OUT TDK_REGION_EXITING_CONFIG* config);
TDKSDKAPI int TDKAPI TDKDevice_SetRegionExiting(IN TDKHANDLE hDevice, IN TDKS32 chn, IN const TDK_REGION_EXITING_CONFIG* config);
TDKSDKAPI int TDKAPI TDKDevice_GetFastMoving(IN TDKHANDLE hDevice, IN TDKS32 chn, OUT TDK_FAST_MOVING_CONFIG* config);
TDKSDKAPI int TDKAPI TDKDevice_SetFastMoving(IN TDKHANDLE hDevice, IN TDKS32 chn, IN const TDK_FAST_MOVING_CONFIG* config);
TDKSDKAPI int TDKAPI TDKDevice_GetLoiteringDetection(IN TDKHANDLE hDevice, IN TDKS32 chn, OUT TDK_LOITERING_DETECTION* config);
TDKSDKAPI int TDKAPI TDKDevice_SetLoiteringDetection(IN TDKHANDLE hDevice, IN TDKS32 chn, IN const TDK_LOITERING_DETECTION* config);
TDKSDKAPI int TDKAPI TDKDevice_GetPeopleGatheringDetection(IN TDKHANDLE hDevice, IN TDKS32 chn, OUT TDK_PEOPLE_GATHERING_DETECTION* config);
TDKSDKAPI int TDKAPI TDKDevice_SetPeopleGatheringDetection(IN TDKHANDLE hDevice, IN TDKS32 chn, IN const TDK_PEOPLE_GATHERING_DETECTION* config);
TDKSDKAPI int TDKAPI TDKDevice_GetParkingDetection(IN TDKHANDLE hDevice, IN TDKS32 chn, OUT TDK_PARKING_DETECTION* config);
TDKSDKAPI int TDKAPI TDKDevice_SetParkingDetection(IN TDKHANDLE hDevice, IN TDKS32 chn, IN const TDK_PARKING_DETECTION* config);
TDKSDKAPI int TDKAPI TDKDevice_GetSceneChangeDetection(IN TDKHANDLE hDevice, IN TDKS32 chn, OUT TDK_SCENE_CHANGE_DETECTION* config);
TDKSDKAPI int TDKAPI TDKDevice_SetSceneChangeDetection(IN TDKHANDLE hDevice, IN TDKS32 chn, IN const TDK_SCENE_CHANGE_DETECTION* config);
TDKSDKAPI int TDKAPI TDKDevice_GetBlurredDetection(IN TDKHANDLE hDevice, IN TDKS32 chn, OUT TDK_BLURRED_DETECTION* config);
TDKSDKAPI int TDKAPI TDKDevice_SetBlurredDetection(IN TDKHANDLE hDevice, IN TDKS32 chn, IN const TDK_BLURRED_DETECTION* config);
TDKSDKAPI int TDKAPI TDKDevice_GetAudioExceptionDetection(IN TDKHANDLE hDevice, IN TDKS32 chn, OUT TDK_AUDIO_EXCEPTION_DETECTION* config);
TDKSDKAPI int TDKAPI TDKDevice_SetAudioExceptionDetection(IN TDKHANDLE hDevice, IN TDKS32 chn, IN const TDK_AUDIO_EXCEPTION_DETECTION* config);
TDKSDKAPI int TDKAPI TDKDevice_GetCrossingLineStatistics(IN TDKHANDLE hDevice, IN TDKS32 chn, OUT TDK_CROSSING_LINE_STATISTICS* config);
TDKSDKAPI int TDKAPI TDKDevice_SetCrossingLineStatistics(IN TDKHANDLE hDevice, IN TDKS32 chn, IN const TDK_CROSSING_LINE_STATISTICS* config);
TDKSDKAPI int TDKAPI TDKDevice_ClearCrossingLineStatistics(IN TDKHANDLE hDevice, IN TDKS32 chn);
TDKSDKAPI int TDKAPI TDKDevice_GetCrossingLineStatisticsReport(IN TDKHANDLE hDevice, IN TDKS32 chn, IN ENUM_TDK_CROSSING_LINE_STATISTICS_REPORT type, IN TDK_SYSTEM_TIME* time, OUT TDK_CROSSING_LINE_STATISTICS_REPORT* config);
TDKSDKAPI TDKBOOL TDKAPI TDKDevice_GetSmartSupport(IN TDKHANDLE hDevice, IN ENUM_TDK_SMART type);
TDKSDKAPI TDKBOOL TDKAPI TDKDevice_GetAudioSupport(IN TDKHANDLE hDevice);
TDKSDKAPI TDKBOOL TDKAPI TDKDevice_GetStorageNormal(IN TDKHANDLE hDevice);
TDKSDKAPI int TDKAPI TDKDevice_SetTCPIP(IN TDKHANDLE hDevice, const IN TDK_TCPIP* config);
TDKSDKAPI int TDKAPI TDKDevice_ModifyNetwork(IN const char* username, IN const char* password, IN const TDK_NETWORK* config, IN TDKU32 timeout);
TDKSDKAPI int TDKAPI TDKDevice_RebootDevice(IN TDKHANDLE hDevice);
TDKSDKAPI int TDKAPI TDKDevice_FactoryReset(IN TDKHANDLE hDevice);

TDKSDKAPI int TDKAPI TDKDevice_GetAlarmIn(IN TDKHANDLE hDevice, IN TDKS32 index, OUT TDK_ALARM_IN* config);
TDKSDKAPI int TDKAPI TDKDevice_SetAlarmIn(IN TDKHANDLE hDevice, IN TDKS32 index, IN const TDK_ALARM_IN* config);
TDKSDKAPI int TDKAPI TDKDevice_GetAlarmOut(IN TDKHANDLE hDevice, IN TDKS32 index, OUT TDK_ALARM_OUT* config);
TDKSDKAPI int TDKAPI TDKDevice_SetAlarmOut(IN TDKHANDLE hDevice, IN TDKS32 index, IN const TDK_ALARM_OUT* config);
TDKSDKAPI int TDKAPI TDKDevice_PTZControl(IN TDKHANDLE hDevice, IN TDKS32 chn, IN ENUM_TDK_PTZ_CONTROL cmd, IN TDKS32 param, IN TDK_PTZ_PARAM* param1, IN TDKBOOL stop);

TDKSDKAPI TDKHANDLE TDKAPI TDKDeviceOnline_Create(IN TDKHANDLE hCallback);
TDKSDKAPI int TDKAPI TDKDeviceOnline_Query(IN TDKHANDLE hOnline, IN const char* url);
TDKSDKAPI int TDKAPI TDKDeviceOnline_Delete(IN TDKHANDLE hOnline);
TDKSDKAPI int TDKAPI TDKDevice_GetChannelCount(IN TDKHANDLE hDevice);

/**Remote system config**/
/**++record status**/
TDKSDKAPI int TDKAPI TDKDevice_GetSYSrecordstatus(IN TDKHANDLE hDevice, OUT TDKS32& count, OUT TDK_SYS_RECORDSTATUS*& config);
TDKSDKAPI int TDKAPI TDKDevice_SYSlogINFO_GetCFG(IN TDKHANDLE hDevice, OUT TDK_SYS_LOGINFOCFG* config);
TDKSDKAPI int TDKAPI TDKDevice_SYSlogINFO_Query(IN TDKHANDLE hDevice, IN TDK_SYS_LOGINFOQUERY* pQuery, OUT TDKS32& count, OUT TDK_SYS_LOGINFO*& config);
TDKSDKAPI int TDKAPI TDKDevice_SYSlogINFO_Clear(IN TDKHANDLE hDevice);

TDKSDKAPI int TDKAPI TDKDevice_ENC_GetCFG(IN TDKHANDLE hDevice, INOUT TDK_ENC_CHNCFG* pCfg);
TDKSDKAPI int TDKAPI TDKDevice_ENC_GetCFG_Fps(IN TDKHANDLE hDevice, INOUT TDK_ENC_QUERYFPS* pQuery);
TDKSDKAPI int TDKAPI TDKDevice_ENC_GetCFG_Bit(IN TDKHANDLE hDevice, INOUT TDK_ENC_QUERYBITRATE* pQuery);
TDKSDKAPI int TDKAPI TDKDevice_ENC_SetCFG(IN TDKHANDLE hDevice, IN TDKENCONDCFGDATA* cfg, OUT TDKS32* status);
TDKSDKAPI int TDKAPI TDKDevice_ENC_GetCFG_SubRes(IN TDKHANDLE hDevice, INOUT TDK_ENC_QUERYRES* pQuery);
TDKSDKAPI int TDKAPI TDKDevice_ENC_Release(IN TDKHANDLE pcodecfg);

TDKSDKAPI int TDKAPI TDKDevice_Cover_GetCFG(IN TDKHANDLE hDevice, INOUT TDK_ENC_COVER* pCover);
TDKSDKAPI int TDKAPI TDKDevice_Cover_SetCFG(IN TDKHANDLE hDevice, IN TDK_ENC_COVER* pCover);

TDKSDKAPI int TDKAPI TDKDevice_OSDSetting_CFG_SET(IN TDKHANDLE hDevice, IN TDK_ENC_OSD* pOSD);
TDKSDKAPI int TDKAPI TDKDevice_OSDSetting_CFG_GET(IN TDKHANDLE hDevice, INOUT TDK_ENC_OSD* pOSD);

/**network **/
TDKSDKAPI int TDKAPI TDKDevice_Network_GETTCPIP(IN TDKHANDLE hDevice, OUT TDK_DEVICE_TCPIP* cfg);
TDKSDKAPI int TDKAPI TDKDevice_Network_CheckIPConflict(IN TDKHANDLE hDevice, IN TDKHANDLE IP);
TDKSDKAPI int TDKAPI TDKDevice_Network_SETTCPIP(IN TDKHANDLE hDevice, IN TDK_DEVICE_TCPIP* cfg, OUT TDKHANDLE pState);
TDKSDKAPI int TDKAPI TDKDevice_Network_REALEASETCPCFG(IN TDKHANDLE pTCPCFG);
/****************************************************************************************\
				Device snapshot upload API
\****************************************************************************************/
#define	TDKSNAPSHOT_MSG_BASE		(TDKSDK_MSG_BASE	+ 2300)
#define	TDKSNAPSHOT_MSG_DATA		(TDKSNAPSHOT_MSG_BASE	+ 0)
//param0:
//param1:	TDK_SNAPSHOT_INFO*
//param2:	NULL
#define	TDKSNAPSHOT_MSG_STATE		(TDKSNAPSHOT_MSG_BASE	+ 1)
//param0:	
//param1:	TDKU32	state
//param2:	TDKS32	error
//TDKSDKAPI TDKHANDLE TDKAPI TDKSnapshot_Create(void);
//TDKSDKAPI int TDKAPI TDKSnapshot_Delete(IN TDKHANDLE hSnapshot);
//TDKSDKAPI int TDKAPI TDKSnapshot_Attach(IN TDKHANDLE hSnapshot, IN TDKHANDLE hCallback);
//TDKSDKAPI int TDKAPI TDKSnapshot_Detach(IN TDKHANDLE hSnapshot, IN TDKHANDLE hCallback);
//TDKSDKAPI int TDKAPI TDKSnapshot_Open(IN TDKHANDLE hSnapshot, IN const char* url, IN const char* username, IN const char* password);
//TDKSDKAPI int TDKAPI TDKSnapshot_Close(IN TDKHANDLE hSnapshot);

/****************************************************************************************\
				Face Search API
\****************************************************************************************/
#define	TDKFACESEARCH_MSG_BASE				(TDKSDK_MSG_BASE	+ 2300)
#define TDKFACESEARCH_MSG_DATA				(TDKFACESEARCH_MSG_BASE + 0)
#define TDKFACESEARCH_MSG_SEARCHOVER		(TDKFACESEARCH_MSG_BASE + 1)
#define TDKFACESEARCH_MSG_FILEPATH			(TDKFACESEARCH_MSG_BASE + 2)
#define TDKFACESEARCH_MSG_DOWNLOADOVER		(TDKFACESEARCH_MSG_BASE + 3)

TDKSDKAPI TDKHANDLE TDKAPI TDKFaceSearch_Create(void);
TDKSDKAPI int TDKAPI TDKFaceSearch_Delete(IN TDKHANDLE hFaceSearch);
TDKSDKAPI int TDKAPI TDKFaceSearch_Attach(IN TDKHANDLE hFaceSearch, IN TDKHANDLE hCallback);
TDKSDKAPI int TDKAPI TDKFaceSearch_Detach(IN TDKHANDLE hFaceSearch, IN TDKHANDLE hCallback);
TDKSDKAPI int TDKAPI TDKFaceSearch_Open(IN TDKHANDLE hFaceSearch, IN const char* url, IN const char* username, IN const char* password);
TDKSDKAPI int TDKAPI TDKFaceSearch_Stop(IN TDKHANDLE hFaceSearch);
TDKSDKAPI int TDKAPI TDKFaceSearch_Close(IN TDKHANDLE hFaceSearch);
TDKSDKAPI int TDKAPI TDKFaceSearch_Search(IN TDKHANDLE hFaceSearch, IN const char* szPath[5], IN TDKU64 nChannelMask, IN TDK_SYSTEM_TIME* times, IN TDK_SYSTEM_TIME* timee, IN TDKBOOL bFilter, IN float fSimilarity, IN TDKU32 nSrc);
TDKSDKAPI int TDKAPI TDKFaceSearch_SearchEx(IN TDKHANDLE hFaceSearch, IN const TDK_PICTURE_DATA pPicData[5], IN TDKU64 nChannelMask, IN TDK_SYSTEM_TIME* times, IN TDK_SYSTEM_TIME* timee, IN TDKBOOL bFilter, IN float fSimilarity, IN TDKU32 nSrc, IN TDKU32 nCount, TDKS32 nSortType, TDKS32 nSort);

/////////////////////////
TDKSDKAPI TDKHANDLE TDKAPI TDKCloud_Create(void);
TDKSDKAPI int TDKAPI TDKCloud_Delete(IN TDKHANDLE hCloud);
TDKSDKAPI int TDKAPI TDKCloud_Attach(IN TDKHANDLE hCloud, IN TDKHANDLE hCallback);
TDKSDKAPI int TDKAPI TDKCloud_Detach(IN TDKHANDLE hCloud, IN TDKHANDLE hCallback);
TDKSDKAPI int TDKAPI TDKCloud_Open(IN TDKHANDLE hCloud, IN const char* serverAddr, IN const char* username, IN const char* password);
TDKSDKAPI int TDKAPI TDKCloud_Close(IN TDKHANDLE hCloud);
TDKSDKAPI int TDKAPI TDKCloud_AddP2PPort(IN TDKHANDLE hCloud, IN const char* cloudId, OUT TDKHANDLE& hDevice);
TDKSDKAPI int TDKAPI TDKCloud_DeleteP2PPort(IN TDKHANDLE hCloud, IN TDKHANDLE hDevice);
#endif//__TDKSDK_H__