#ifndef __TDKMEDIA_H__
#define __TDKMEDIA_H__
#include "TDKType.h"

#define  TDK_MAX_CHN_NUM 128
//Codec Types
#define 	TDKCODEC_NONE 	0		
#define 	TDKCODEC_H264 	1		//H264
#define		TDKCODEC_H265 	2		//H265
#define		TDKCODEC_JPEG 	3		//JPEG
#define 	TDKCODEC_PCMA 	4		//PCMA
#define 	TDKCODEC_PCMU 	5		//PCMU
#define 	TDKCODEC_ADPCM	6		//ADPCM
#define		TDKCODEC_MP3 	7		//MP3
#define		TDKCODEC_AAC 	8		//AAC
#define		TDKCODEC_PCM	9		//PCM
#define     TDKCODEC_SMART 10
#define     TDKCODEC_CURRC 11
#define     TDKCODEC_H264P(_n_) (0x10 + (_n_))     //H264P(0)~H264P(15)
#define     TDKCODEC_H265P(_n_) (0x20 + (_n_))     //H265P(0)~H265P(15)

//Picture Types
#define		TDKPIC_NONE			0
#define		TDKPIC_RGB16		1
#define		TDKPIC_RGB24		2
#define		TDKPIC_RGB32		3
#define		TDKPIC_UYVY			4
#define		TDKPIC_YV12			5
#define		TDKPIC_NUM			6

//Frame Types
#define		TDKFRAME_BASE 	0xE0
#define		TDKFRAME_P			0
#define		TDKFRAME_I			1
#define		TDKFRAME_B			2
#define		TDKFRAME_AUDIO		3
#define		TDKFRAME_JPEG		4
#define		TDKFRAME_MOTION		5
#define		TDKFRAME_REC		6
#define		TDKFRAME_SMART		7
#define		TDKFRAME_SMARTEX	8
#define		TDKFRAME_VI			9
#define		TDKFRAME_PB			10	
#define		TDKFRAME_NUM		11
#define		TDKFRAME_NULL		0xff


//ܶ־
#define	TDKSMART_FLAG_NORMAL		0x00000001	//ͨܶ
#define	TDKSMART_FLAG_MOTION		0x00000002	//˶
#define	TDKSMART_FLAG_FACE			0x00000004	//
#define TDKSMART_FLAG_PLATE			0x00000008	//ƶ

//ܶͶ
#define	TDKSMART_OBJECT_NONE			0
#define	TDKSMART_OBJECT_NORMAL			1
#define	TDKSMART_OBJECT_LINE			2
#define	TDKSMART_OBJECT_AREA			3
#define	TDKSMART_OBJECT_AREAIN			4
#define	TDKSMART_OBJECT_AREAOUT			5
#define	TDKSMART_OBJECT_AREAMOVE		6
#define	TDKSMART_OBJECT_AREALEFT		7
#define	TDKSMART_OBJECT_AREALOSE		8
#define	TDKSMART_OBJECT_AREAFACEDETECT	9
#define	TDKSMART_OBJECT_AREAWANDER		10
#define	TDKSMART_OBJECT_AREAPARK		11
#define	TDKSMART_OBJECT_AREACROWD		12
#define	TDKSMART_OBJECT_MOTIONDETECT	13
#define	TDKSMART_OBJECT_NORMALEX		14
#define	TDKSMART_OBJECT_FACEINFO		15
#define	TDKSMART_OBJECT_FACE			16
#define	TDKSMART_OBJECT_FACETLV			17
#define TDKSMART_OBJECT_FACEATTR		18
#define	TDKSMART_OBJECT_PICTURE			19
#define TDKSMART_OBJECT_PICINFO			20

//ܼͶ
#define	TDKSMART_DETECT_NONE			0
#define	TDKSMART_DETECT_MOTION			1	//˶
#define	TDKSMART_DETECT_LINECROSS		2	//
#define	TDKSMART_DETECT_INTRUDE			3	//Ʒ
#define	TDKSMART_DETECT_LOSE			4	//Ʒʧ
#define	TDKSMART_DETECT_LEAVE			5	//Ʒ
#define	TDKSMART_DETECT_AREAIN			6	//
#define	TDKSMART_DETECT_AREAOUT			7	//뿪
#define	TDKSMART_DETECT_FASTMOVE		8	//ƶ
#define	TDKSMART_DETECT_FACE			9	//

typedef struct tag_TDK_SMART_PIC
{
	TDKU16	w;				//picture width
	TDKU16	h;				//picture height
	TDKU16	codec;			//codec type, TDKCODEC_XXX
	TDKU16	ms;				//picture time: millisecond
	time_t	tmf;			//picture time
	TDKU32	len;			//picture length
	char*	data;			//picture data
	char	name[32];		//picture name, utf-8
	char	serialno[32];	//serialno, utf-8
	char	info[64];		//monitoring point information
}TDK_SMART_PIC, *PTDK_SMART_PIC;

//player type
#define	TDKPLAYER_MODE_LIVE	0
#define	TDKPLAYER_MODE_FILE 	1

//file type
#define	TDK_FILE_UNKNOWN		0		//unknown
#define	TDK_FILE_MEDIA			1		//media file
#define	TDK_FILE_PIC			2		//picture file

//record type
#define	TDKREC_TIMER						0		///< timer record
#define	TDKREC_MANUAL						1		///< manual record
#define	TDKREC_EVENT						2		///< event record
#define	TDKREC_ALL							255		///< all record

//stream type
#define TDK_STREAM_MAIN   0			//main stream
#define TDK_STREAM_SUB   1			//sub stream
#define TDK_STREAM_THIRD   2		//third stream


typedef struct tag_TDK_FILE_SEARCH_PARAM
{
	TDKU8 filetype;//ļ
	TDKU8 rectype;	//¼ͣʾ
	TDKU8 res[6];
	TDKU64 chnmask0;	//ͨ룬ǰ64·
	TDKU64 chnmask1;	//ͨ룬64·
	TDKU8 streamtype;//
	TDKU8 res1[3];
	TDK_SYSTEM_TIME starttime;
	TDK_SYSTEM_TIME endtime;
	TDKU8 res2[28];
}TDK_FILE_SEARCH_PARAM;

typedef struct tag_TDK_FILE_SUMMARY_SEARCH_PARAM 
{
	TDKU8 rectype;	//bit mask, reference record type, TDKREC_TIMER/...
	TDKU64 chnmask0;	//channel mask, for 64 channels in front.
	TDKU64 chnmask1;	//channel mask, for 64 channels in back.
	TDK_SYSTEM_TIME searchtime;   //only need year/month value.

}TDK_FILE_SUMMARY_SEARCH_PARAM;

typedef struct tag_TDK_FILE_INFO
{
	TDKU8 filetype;//ļ
	TDKU8 rectype;	//¼
	TDKU8 channel;
	TDKU8 streamtype;
	TDKU8 lockstatus;//0-δ1-
	TDKU8 codec;//ʽ
	TDKU8 res[2];
	TDK_SYSTEM_TIME starttime;
	TDK_SYSTEM_TIME endtime;
	TDKU64 size;//Сλֽ
	TDKU32 picindex;//ļΪͼƬʱЧ
	TDKU8 filename[80];
	TDKU8 res1[32];
}TDK_FILE_INFO;

typedef enum tag_TDK_IMAGE_FORMAT
{
	TDK_IMAGE_BMP,
	TDK_IMAGE_JPEG,
}TDK_IMAGE_FORMAT;
typedef enum tag_TDK_RECORD_FORMAT
{
	TDK_RECORD_DAV,
	TDK_RECORD_MP4,
	TDK_RECORD_AVI
}TDK_RECORD_FORMAT;

typedef struct tag_TDK_DOWNLOAD_PARAM_TIME
{
	TDKU32 channel;
	TDKU32 filetype;//TDK_FILE_MEDIA
	TDKU32 recordtype;//TDKREC_TIMER
	TDKU32 streamtype;
	TDK_SYSTEM_TIME starttime;
	TDK_SYSTEM_TIME endtime;
	char destpath[256];
	TDK_RECORD_FORMAT format;//ļΪTDK_FILE_MEDIAʱЧ
}TDK_DOWNLOAD_PARAM_TIME;

typedef struct tag_TDK_DOWNLOAD_PARAM_FILE
{
	TDKU32 count;
	TDK_FILE_INFO* filelist;
	char destpath[256];
	TDK_RECORD_FORMAT format;//¼ļʱЧ
}TDK_DOWNLOAD_PARAM_FILE;

//////////////////////////////////////////////////////////////////////////
#define TDKALARM_UNKNOWN					0
#define TDKALARM_PORT_ALARMIN					1	//alarm input[]
#define TDKALARM_MOTION							2	//motion detect alarm [̬ⱨ]
#define TDKALARM_VIDEOLOST						3	//video lost alarm [Ƶʧ]
#define TDKALARM_SHELTER							4	//shelter alarm [ڵ]

#define TDKALARM_DISKFULL							5	//disk full alarm [Ӳ]
#define TDKALARM_DISKERROR						6	//disk error alarm [Ӳ̱]
#define TDKALARM_NO_DISK							7	//no disk alarm [Ӳ̱]

#define TDKALARM_CROSSLINE						8	//cross-line alarm [ܣԽ㷨]
#define TDKALARM_AREA_INTRUSION				9	//area intrusion alarm [ܣ㷨]

#define TDKALARM_IP_CONFLICT						10	 //IP conflict alarm[ipͻ]
#define TDKALARM_HDD_SMART						11  //HDD S.M.A.R.T alarm[ӲS.M.A.R.T]
#define TDKALARM_REGION_ENTRANCE			12 //Region Entrance alarm[뱨]
#define TDKALARM_REGION_EXIT						13  //Region Exiting alarm[뿪]
#define TDKALARM_FAST_MOVE						14  //Fast Moving alarm[ƶ]
#define TDKALARM_OBJECT_UNATTEND			15  //Unattended Object alarm[Ʒ]
#define TDKALARM_OBJECT_MISS					16  //Object Missing alarm[Ʒʧ]
#define TDKALARM_FACE_DETECT						17  //Face Detection alarm[ʶ𱨾]
#define TDKALARM_LOITER_DETECT					18  //Loitering Detection alarm[ǻⱨ]
#define TDKALARM_PARK_DETECT					19  //Parking Detection alarm[ͣ]
#define TDKALARM_PEOPLE_GATHER				20  //People Gathering Detection alarm[Աۼ]
#define TDKALARM_DEFOCUS_DETECT             21  //Defocus Detection alarm[齹ⱨ]
//
#define TDKALARM_SCENE_CHANGE                22  //Scene Change Alarm[]
#define TDKALARM_AUDIO_EXCEPTION           23  //Audio Exception Alarm[Ƶ쳣]
#define TDKALARM_SOUND_MUTATION           24  //ͻ  Ϊ
#define TDKALARM_SOUND_ZOOM                 25  //Sound Zoom Alarm 
#define TDKALARM_SOUND_PLUNGE               26  //Sound Plunge Alarm 

typedef struct tag_TDK_ALARM_INFO_CHN
{
	TDKU16 chn;
	TDKU16 type;
	TDKU16 status;//0-no alarm1-alarm;
	TDKU16 number;//number of alarm region or line,for smart
	TDKU8 res[32];
}TDK_ALARM_INFO_CHN;

typedef struct tag_TDK_ALARM_INFO
{
	TDKU16 type;
	TDKU16 count;
	TDK_ALARM_INFO_CHN info[TDK_MAX_CHN_NUM];
	TDKU8 res[32];
}TDK_ALARM_INFO;

//ʱṹ
typedef struct _TDK_TIME
{
	TDKU32 second : 6;                    //        1-60
	TDKU32 minute : 6;                    //        1-60
	TDKU32 hour : 5;                    //    ʱ    1-24
	TDKU32 day : 5;                    //        1-31
	TDKU32 month : 4;                    //        1-12
	TDKU32 year : 6;                    //        2000-2063
}TDK_TIME, *PTDK_TIME, *pTDK_TIME;

typedef struct tag_TDK_FRMHDR
{
	TDKU8 prefix[4];		//prefix[0] = 0, prefix[1] = 0, prefix[2] = 1, prefix[3] = TDKFRAME_BASE + TDKFRAME_XXX
	TDKU32	length;			//֡
	TDK_TIME 	tms;			//ľʱ
	TDKU16 	ms;				//,0~999
	TDKU8 	codec;			//ͣTDKCODEC_XXX
	union
	{
		TDKU8   flag;  		//֡objectޱ enum PackSmartFlag,ΪǷи
		TDKU8	num;		//֡ʱʾܶ
		TDKU8 	fps;		//Ƶ֡,6.2ʽ
		TDKU8 	channum;	//Ƶͨ 
	};
	union
	{
		TDKU16 	width;		//Ƶ
		TDKU16 	freq;		//Ƶ
	};
	TDKU16	height;			//Ƶ߶
}TDK_FRAMEHEAD, *TDK_PFRAMEHEAD;

typedef struct tag_TDK_PICTURE
{
	TDKU16 	format;		//ͼƬʽ
	TDKU16    res;
	TDKU32		width;		//ͼƬ
	TDKU32		height;		//ͼƬ߶
	TDKU32		linesnum[3];	//
	TDKU32		linesize[3];	//ÿЧֽ
	TDKU32		pitch[3];		//ֽ֮
	TDKU8*		data[3];		//ݻַ
}TDK_PICTURE;
///////////////////////////////////////////////////////////////////////////////////
// ض
typedef enum tag_ENUM_TDK_FACE_ATTR
{
	ENUM_TDK_FACE_ATTR_SMILE = 0,	//Ц    0Ц 1Ц
	ENUM_TDK_FACE_ATTR_GENDER,		//Ա  0У   1Ů
	ENUM_TDK_FACE_ATTR_MASK,		//  0 1
	ENUM_TDK_FACE_ATTR_EYE,			//۾  0գ   1
	ENUM_TDK_FACE_ATTR_MOUTH,		//    0գ   1
	ENUM_TDK_FACE_ATTR_BEARD,		//  0ޣ   1
	ENUM_TDK_FACE_ATTR_GLASSES,		//۾  0ޣ   1
}ENUM_TDK_FACE_ATTR;

typedef enum tag_ENUM_TDK_FACE_ATTR_EFFECTFLAG
{
	ENUM_TDK_FACE_ATTR_EFFECTFLAG_NAME = 0,
	ENUM_TDK_FACE_ATTR_EFFECTFLAG_SIM,
	ENUM_TDK_FACE_ATTR_EFFECTFLAG_AGE,
	ENUM_TDK_FACE_ATTR_EFFECTFLAG_ATTRACTIVE,
	ENUM_TDK_FACE_ATTR_EFFECTFLAG_GLASSES,
	ENUM_TDK_FACE_ATTR_EFFECTFLAG_RACE,
	ENUM_TDK_FACE_ATTR_EFFECTFLAG_EMOTION,
	ENUM_TDK_FACE_ATTR_EFFECTFLAG_FEATRUE,
}ENUM_TDK_FACE_ATTR_EFFECTFLAG;

#pragma pack (1)

typedef struct tag_TDK_FACE_ATTR
{
	TDKU32	effectFlag;  	//ENUM_TDK_FACE_ATTR_EFFECTFLAGЧ־λȡ1ʾЧ
	char	name[64]; 		//
	TDKU8	sim;         	//ƶ
	TDKU8	age; 			// 
	TDKU8	attractive;		//ֵ 
	TDKU8	glasses; 		//۾ ENUM_TDK_FACE_ATTR_GLASSESEXT 
	TDKU8	race; 			//ɫ ENUM_TDK_FACE_ATTR_RACEEXT 
	TDKU8	emotion; 		// ENUM_TDK_FACE_ATTR_EMOTIONEXT 
	TDKU16	featurelen;
	float	feature[512];	//ֵ 
	TDKU32	res2;
}TDK_FACE_ATTR, *PTDK_FACE_ATTR;

typedef struct tag_TDK_FACEOBJ
{
	TDKU32				rsvd;
	TDKU16				id;
	TDKU16				quality;
	TDK_POINT16			lefttop;
	TDK_POINT16			rightend;						
	TDKU32               attrEffectFlag;	// Ч־	ENUM_TDK_FACE_ATTR
	TDKU32               attr;			// 	ENUM_TDK_FACE_ATTR
}TDK_FACEOBJ, *PTDK_FACEOBJ;

typedef struct tag_TDK_LICENCEPALTE_OBJ
{
	TDKU32				rsvd;
	TDKU16				id;				
	TDKU16				quality;
	TDK_POINT16			lefttop;	//The location of the recognized license plate in the source image, upper left, range : 0 ~ 8192
	TDK_POINT16			rightend;	//The location of the recognized license plate in the source image, lower right, range : 0 ~ 8192
	char				licenceplate[256];	//license plate, utf-8
}TDK_LICENCEPALTE_OBJ, *PTDK_LICENCEPALTE_OBJ;

#pragma pack ()
#define TDK_SCALE_COORD 8192
#define TDK_MAX_NUM_LINE_POINT 32
typedef struct tag_TDK_SMART_OBJ
{
	TDKU16			type;//TDKSMART_OBJECT_LINE
	TDKU16			id;
	TDKU16			state;//0-normal,1-alarm
	TDKU16			pointnum;
	TDK_POINT32		point[TDK_MAX_NUM_LINE_POINT];
}TDK_SMART_OBJ;

typedef struct tag_TDK_SNAPSHOT_PIC
{
	TDKU16	codec;
	TDKU16	w;
	TDKU16	h;
	TDKU32	len;
	unsigned char*	data;
}TDK_SNAPSHOT_PIC, *PTDK_SNAPSHOT_PIC;

typedef struct tag_TDK_SNAPSHOT_INFO
{
	TDKU32					alarmCount;
	TDK_ALARM_INFO_CHN		alarmInfo[TDK_MAX_CHN_NUM];
	TDK_SNAPSHOT_PIC		pic;
}TDK_SNAPSHOT_INFO;

typedef struct tag_TDK_FACE_SEARCH_INFO
{
	TDKU8					id;
	TDKU8					chnid;
	char					cloudid[32];
	char*					pic;
	TDKU32					piclen;
	TDK_SYSTEM_TIME			time;
	float					sim;
}TDK_FACE_SEARCH_INFO, *PTDK_FACE_SEARCH_INFO;

typedef struct tag_TDK_PICTURE_DATA
{
	char*	picdata;
	TDKU32	piclen;
}TDK_PICTURE_DATA, PTDK_PICTURE_DATA;


#endif//__TDKMEDIA_H__