#ifndef __TDKCONFIG_H__
#define __TDKCONFIG_H__
#include "TDKType.h"
#include "TDKCFG/MDconfig.h"
#include "TDKCFG/VideoLostConfig.h"
#include "TDKCFG/VideoBlockConfig.h"
#include "TDKCFG/AlarmException.h"
#include "TDKCFG/RecordControl.h"
#include "TDKCFG/RecordConfig.h"
#include "TDKCFG/RecordAdvanceConfig.h"
#include "TDKCFG/HDDBase.h"
#include "TDKCFG/SystemInfo.h"
#include "TDKCFG/SystemGeneral.h"


#define TDK_MAX_IPADDR_LEN				16			//max size of IP address string [IPַַ]
#define TDK_MAX_IPV6ADDR_LEN			48			//max size of IPV6 address string [IPַַ]
#define TDK_MACADDR_LEN					40			//max size of MAC address string [MACַַ]
#define TDK_DEV_TYPE_LEN				32			//max size of device type string [豸ַ]
#define TDK_DEV_OEM_LEN					8			//max size of device OEM string [豸ַ]
#define TDK_DEV_MODEL_LEN				128			//max size of device model string [豸ַ]
#define TDK_MAX_CHANNEL					64

typedef struct  
{
	TDKHANDLE	callback;		//create by TDKCBCreate
	TDKU32		timeout;		//search time, millisecond
}TDK_DEVICE_SEARCH_PARAM;
typedef struct
{
	TDKS8	ip[TDK_MAX_IPADDR_LEN];					//IPv4 [IP]
	TDKS8	ipv6[TDK_MAX_IPV6ADDR_LEN];				//IPv6 [IP]
	TDKU16	media_port;								//ipv4 port [˿]
	TDKU16	media_port_ipv6;						//ipv6 port [˿]
	TDKU16	http_port;								//http port
	TDKS8	submask[TDK_MAX_IPADDR_LEN];			//ipv4 sub net mask []
	TDKU32	ipv6_perfix;
	TDKS8	gateway[TDK_MAX_IPADDR_LEN];			//ipv4 gateway []
	TDKS8	gateway_ipv6[TDK_MAX_IPV6ADDR_LEN];		//ipv6 gateway []
	TDKS8	mac_addr[TDK_MACADDR_LEN];				//MAC address [MACַ]
	TDKS8	major_dns[TDK_MAX_IPADDR_LEN];			//ipv4 major DNS
	TDKS8	major_dns_ipv6[TDK_MAX_IPV6ADDR_LEN];	//ipv6 major DNS
	TDKS8	minor_dns[TDK_MAX_IPADDR_LEN];			//ipv4 minor DNS
	TDKS8	minor_dns_ipv6[TDK_MAX_IPV6ADDR_LEN];	//ipv6 minor DNS

	TDKS8	device_type[TDK_DEV_TYPE_LEN];			//device type [豸]
	TDKS8	device_oem[TDK_DEV_OEM_LEN];			//device OEM
	TDKS8	device_model[TDK_DEV_MODEL_LEN];		//device model
	TDKS8	networkcardip[TDK_MAX_IPADDR_LEN];			//The network card IP
}TDK_DEVICE_NET_INFO;

typedef enum
{
	TDKDEVICE_TYPE_DVR,
	TDKDEVICE_TYPE_IPC,
}TDK_DEVICE_TYPE;
typedef struct
{
	TDKU8 devtype;			//device type, refer TDK_DEVICE_TYPE
	TDKU16 analogchnnum;	//Number of analog channels
	TDKU16 digitalchnnum;	//Number of digital channels, total number of channels: analogchnnum + digitalchnnum
	TDKU8 alarmin;			//Number of alarm inputs
	TDKU8 alarmout;			//Number of alarm outputs
	TDKU8 audioin;			//Number of audio in
	TDKU8 audioout;			//Number of auido out
	TDKU8 devmodel[128];
	TDKU8 devversion[128];
	TDKU64 digtal[3];
	TDKU64 analog[3];
}TDK_DEVICE_INFO;

typedef struct tag_TDK_TIME_CONFIG
{
	TDKS8 timezone;
	TDK_SYSTEM_TIME time;
}TDK_TIME_CONFIG;

#define TDK_CHANNEL_NAME_SIZE 64
typedef struct tag_TDK_OSD_WIDGET
{
	TDK_RECT32	pos;					/*!< object's edge distance / total length * 8192 [߾ı*8192] */
	TDKBOOL		encodeblend;			/*!< overprint in code [] */
}TDK_OSD_WIDGET;

typedef struct tag_TDK_OSD_CONFIG
{
	TDKS32			channel;
	TDKS8			name[TDK_CHANNEL_NAME_SIZE];
	TDK_OSD_WIDGET	name_osd;
	TDK_OSD_WIDGET	time_osd;
}TDK_OSD_CONFIG;

typedef struct tag_TDK_NTP_INFO
{
	TDKS32 id;
	TDKS8  name[64];
}TDK_NTP_INFO;

typedef struct tag_TDK_NTP_CONFIG
{
	TDKS32	count;
	TDK_NTP_INFO ntpinfo[32];
	TDKS32	id;
	TDKBOOL	enable;
	TDKS32	port;
	TDKU32	update_interval;//uint is minute(s)
}TDK_NTP_CONFIG;


#define TDK_MAX_RIGHT_NUM		768		//max number of usr authority [ûȨ޸]
#define TDK_MAX_GROUP_NUM		20		//max number of user group [û]
#define TDK_MAX_USER_NUM		200		//max number of user [û]
#define TDK_RIGHT_NAME_LENGTH	32		//max size of authority name [Ȩ]
#define TDK_MEMO_LENGTH			32		//max size of memo [ע]
#define TDK_USER_NAME_LENGTH	96		//max size of user name [û]
#define TDK_USER_PSW_LENGTH		96		//max size of user password [û볤]

#define TDK_GROUP_NAME_LENGTH  16  //user name length [û]
typedef struct tag_TDK_OPR_RIGHT
{
	TDKU32  id;
	TDKS8	name[TDK_RIGHT_NAME_LENGTH];
	TDKS8	memo[TDK_MEMO_LENGTH];
}TDK_OPR_RIGHT;

typedef struct tag_TDK_USER_CONFIG
{
	TDKU32  id;
	TDKU32	groupid;
	TDKS8   name[96];
	TDKS8   passWord[96];
	TDKU32  rightnum;
	TDKU32  rightid[TDK_MAX_RIGHT_NUM];
	TDKS8   memo[TDK_MEMO_LENGTH];
	TDKBOOL	reuse;
}TDK_USER_CONFIG;

typedef struct tag_TDK_USER_GROUP_INFO
{
	TDKU32  id;
	TDKS8	name[TDK_GROUP_NAME_LENGTH];
	TDKU32  rightnum;
	TDKU32  rightid[TDK_MAX_RIGHT_NUM];
	char	memo[TDK_MEMO_LENGTH];
}TDK_USER_GROUP_CONFIG;

//struct user information configure [ûϢýṹ]
typedef struct tag_TDK_USER_MANAGE_CONFIG
{
	TDKU32				rightnum;
	TDK_OPR_RIGHT		rightlist[TDK_MAX_RIGHT_NUM];
	TDKU32				groupnum;
	TDK_USER_GROUP_CONFIG grouplist[TDK_MAX_GROUP_NUM];
	TDKU32				usernum;
	TDK_USER_CONFIG		userlist[TDK_MAX_USER_NUM];
}TDK_USER_MANAGE_CONFIG;


#define  TDK_MAX_RULE								8
#define  TDK_DYAS_WEEK								7
#define	 TDK_MAX_SCHEDULE							6
#define	 TDK_MAX_PTZ_LINK_EVENT_TYPE				4
#define  TDK_MAX_CROSSING_LINE_STATISTICS_REPORT	31

typedef struct tag_TDK_RULE_FACE_DETECT
{
	TDKS32		sensitiveValue;
}TDK_RULE_FACE_DETECT;

typedef struct tag_TDK_RULE_FACE_DETECT_RANGE
{
	TDKS32		sensitiveMin;
	TDKS32		sensitiveMax;
}TDK_RULE_FACE_DETECT_RANGE;

typedef struct tag_TDK_SCHEDULE
{
	TDK_SYSTEM_TIME		beginTime;		//Begin time
	TDK_SYSTEM_TIME		endTime;		//End time
	TDKBOOL				enable;
}TDK_SCHEDULE;


typedef struct tag_TDK_PTZ_LINK
{
	TDKS32		eventTypeID;    //0: never  1: preset  2:Tour  3:pattern
	TDKS32		eventTypeValue;
}TDK_PTZ_LINK;

typedef struct tag_TDK_PTZ_LINK_RANGE
{
	TDKS32		eventTypeID;
	TDKS32		valueMin;
	TDKS32		valueMax;
}TDK_PTZ_LINK_RANGE;


typedef struct tag_TDK_SMART_ALARM
{
	TDKS32						scheduleNum;								//Number of time periods supported in a day, scheduleNum <= TDK_MAX_SCHEDULE
	TDK_SCHEDULE				schedule[TDK_DYAS_WEEK][TDK_MAX_SCHEDULE];
	TDKS32						intervalValue;								//Interval value, range: intervalMin ~ intervalMax					
	TDKS32						intervalMin;
	TDKS32						intervalMax;
	TDKBOOL						alarmOutSupport; 		//Whether to support alarm output
	TDKBOOL						alarmOutEnable; 		//Alarm output enable
	TDKS32						alarmOutPortNum;		//The umber of alarm output ports
	TDKS32						alarmOutPortMask;		//Alarm output port mask, bit wise calculation
	TDKS32						alarmOutDelayValue;		//Alarm output delay value, range:alarmOutDelayMin~ alarmOutDelayMax
	TDKS32						alarmOutDelayMin;
	TDKS32						alarmOutDelayMax;
	TDKBOOL						showMessageSupport;		//Whether to support show Message
	TDKBOOL						showMessageEnable;		//Show message enable
	TDKBOOL						sendEmailSupport;		//Whether to support send email
	TDKBOOL						sendEmailEnable;		//Send Email enable
	TDKBOOL						recordChannelSupport;	//Whether to support record channel and record delay
	TDKBOOL						recordChannelEnable;	//Record channel enable
	TDKU64						recordChannelMask;		//Record channel mask, bit wise calculation
	TDKS32						recordDelayValue;		//Record delay value, range: recordDelayMin~ recordDelayMax
	TDKS32						recordDelayMin;			
	TDKS32						recordDelayMax;			 
	TDKBOOL						ptzLinkSupport;			//Whether to support PTZ act
	TDKBOOL						ptzLinkEnable;
	TDK_PTZ_LINK				ptzLink[TDK_MAX_CHANNEL];					//PTZ act data, the maximum number set at the same time is 16
	TDK_PTZ_LINK_RANGE			ptzLinkRange[TDK_MAX_PTZ_LINK_EVENT_TYPE];	//PTZ act range
	TDKBOOL						smartLightSupport;							//Whether to support smartLight
	TDKBOOL						smartLightEnable;							//SmartLight enable
	TDKS32						smartLightDelayValue;						// SmartLight delay value, range: smartLightDelayMin~ smartLightDelayMax
	TDKS32						smartLightDelayMin;
	TDKS32						smartLightDelayMax;
	TDKBOOL						tourSupport;								//Whether to support tour
	TDKBOOL						tourEnable;									//Tour enable
	TDKU64						tourChannelMask;							//Tour mask, bit wise calculation
	TDKBOOL						buzzerSupport;								//Whether to support buzzer
	TDKBOOL						buzzerEnable;								//Buzzer enable
	TDKS32						buzzerAlarmTimeValue;						//Buzzer alarm time value, range:  buzzerAlarmTimeMin~ buzzerAlarmTimeMax
	TDKS32						buzzerAlarmTimeMin;
	TDKS32						buzzerAlarmTimeMax;							//If buzzerAlarmTimeMax = = 0, buzzer alarm time is not supported
	TDKBOOL						snapshotSupport;							//Whether to support snapshot
	TDKBOOL						snapshotEnable;								//Snapshot enable
	TDKU64						snapshotChannelMask;						//snapshot mask,  bit wise calculation
}TDK_SMART_ALARM;

typedef struct tag_TDK_AREA
{
	TDK_POINT32		point[10];
	TDKS32			pointNum;			//Effective number of points
	TDKBOOL			exist;				//True means valid
}TDK_AREA;


//struct face detection
typedef struct tag_TDK_FACE_DETECTION_CONFIG
{
	TDKBOOL							enable;
	TDKS32							ruleNum;				//The number of valid TDK_RULE_FACE_DETECT and TDK_AREA
	TDK_RULE_FACE_DETECT			rule[TDK_MAX_RULE];		//Sensitivity
	TDK_RULE_FACE_DETECT_RANGE		ruleRange;				//the range of  struct TDK_RULE_FACE_DETECT
	TDK_AREA						area[TDK_MAX_RULE];		//the area of interest
	TDK_SMART_ALARM					alarm;					//Alarm information
}TDK_FACE_DETECTION_CONFIG;



//struct line crossing
typedef struct tag_TDK_RULE_LINE_CROSSING
{
	TDKS32		direction;				// The direction of line,  0: A<->B   1: A->B  2: B<-A
	TDKS32		sensitiveValue;
}TDK_RULE_LINE_CROSSING;

typedef struct tag_TDK_RULE_LINE_CROSSING_RANGE
{
	TDKS32		sensitiveMin;
	TDKS32		sensitiveMax;
}TDK_RULE_LINE_CROSSING_RANGE;

typedef struct tag_TDK_LINE
{
	TDK_POINT32		pointStart;					
	TDK_POINT32		pointEnd;
	TDKBOOL			exist;						//True means valid
}TDK_LINE;

//struct line crossing
typedef struct tag_TDK_LINE_CROSSING_CONFIG
{
	TDKBOOL							enable;
	TDKS32							ruleNum;				//The number of valid TDK_RULE_LINE_CROSSING and TDK_LINE
	TDK_RULE_LINE_CROSSING			rule[TDK_MAX_RULE];
	TDK_RULE_LINE_CROSSING_RANGE	ruleRange;				//The range of struct TDK_RULE_LINE_CROSSING
	TDK_LINE						line[TDK_MAX_RULE];		//the line of interest
	TDK_SMART_ALARM					alarm;					//Alarm information
}TDK_LINE_CROSSING_CONFIG;


typedef struct tag_TDK_RULE_AREA_INTRUSION
{
	TDKS32							timeThresholdValue;		//The value of time threshold
	TDKS32							sensitiveValue;
	TDKS32							percentValue;			//The value of percent  
}TDK_RULE_AREA_INTRUSION;

typedef struct tag_TDK_RULE_AREA_INTRUSION_RANGE
{
	TDKS32							timeThresholdMin;
	TDKS32							timeThresholdMax;
	TDKS32							sensitiveMin;
	TDKS32							sensitiveMax;
	TDKS32							percentMin;
	TDKS32							percentMax;
}TDK_RULE_AREA_INTRUSION_RANGE;

//struct area intrusion
typedef struct tag_TDK_AREA_INTRUSION_CONFIG
{
	TDKBOOL							enable;
	TDKS32							ruleNum;				//The number of valid TDK_RULE_AREA_INTRUSION and TDK_AREA
	TDK_RULE_AREA_INTRUSION			rule[TDK_MAX_RULE];
	TDK_RULE_AREA_INTRUSION_RANGE	ruleRange;				//The range of TDK_RULE_AREA_INTRUSION
	TDK_AREA						area[TDK_MAX_RULE];
	TDK_SMART_ALARM					alarm;
}TDK_AREA_INTRUSION_CONFIG;


typedef struct tag_TDK_RULE_UNATTENDED_OBJECT
{
	TDKS32							timeThresholdValue;
	TDKS32							sensitiveValue;
}TDK_RULE_UNATTENDED_OBJECT;

typedef struct tag_TDK_RULE_UNATTENDED_OBJECT_RANGE
{
	TDKS32							timeThresholdMin;
	TDKS32							timeThresholdMax;
	TDKS32							sensitiveMin;
	TDKS32							sensitiveMax;
}TDK_RULE_UNATTENDED_OBJECT_RANGE;

//struct unattended object
typedef struct  tag_TDK_UNATTENDED_OBJECT_CONFIG
{
	TDKBOOL								enable;
	TDKS32								ruleNum;				//The number of valid TDK_RULE_UNATTENDED_OBJECT and TDK_AREA
	TDK_RULE_UNATTENDED_OBJECT			rule[TDK_MAX_RULE];
	TDK_RULE_UNATTENDED_OBJECT_RANGE	ruleRange;				//The range of TDK_RULE_UNATTENDED_OBJECT
	TDK_AREA							area[TDK_MAX_RULE];
	TDK_SMART_ALARM						alarm;
}TDK_UNATTENDED_OBJECT_CONFIG;


typedef struct tag_TDK_RULE_OBJECT_MISSING
{
	TDKS32							timeThresholdValue;
	TDKS32							sensitiveValue;
}TDK_RULE_OBJECT_MISSING;

typedef struct tag_TDK_RULE_OBJECT_MISSING_RANGE
{
	TDKS32							timeThresholdMin;
	TDKS32							timeThresholdMax;
	TDKS32							sensitiveMin;
	TDKS32							sensitiveMax;
}TDK_RULE_OBJECT_MISSING_RANGE;

//struct object missing
typedef struct tag_TDK_OBJECT_MISSING_CONFIG
{
	TDKBOOL								enable;
	TDKS32								ruleNum;				//The number of valid TDK_RULE_OBJECT_MISSING and TDK_AREA
	TDK_RULE_OBJECT_MISSING				rule[TDK_MAX_RULE];
	TDK_RULE_OBJECT_MISSING_RANGE		ruleRange;				//The range of TDK_RULE_OBJECT_MISSING
	TDK_AREA							area[TDK_MAX_RULE];
	TDK_SMART_ALARM						alarm;	
}TDK_OBJECT_MISSING_CONFIG;


typedef struct tag_TDK_RULE_REGION_ENTRANCE
{
	TDKS32							sensitiveValue;
}TDK_RULE_REGION_ENTRANCE;

typedef struct tag_TDK_RULE_REGION_ENTRANCE_RANGE
{
	TDKS32							sensitiveMin;
	TDKS32							sensitiveMax;
}TDK_RULE_REGION_ENTRANCE_RANGE;

//struct region entrance
typedef struct tag_TDK_REGION_ENTRANCE_CONFIG
{
	TDKBOOL								enable;		
	TDKS32								ruleNum;				//The number of valid TDK_RULE_REGION_ENTRANCE and TDK_AREA
	TDK_RULE_REGION_ENTRANCE			rule[TDK_MAX_RULE];
	TDK_RULE_REGION_ENTRANCE_RANGE		ruleRange;				//The range of TDK_RULE_REGION_ENTRANCE
	TDK_AREA							area[TDK_MAX_RULE];
	TDK_SMART_ALARM						alarm;
}TDK_REGION_ENTRANCE_CONFIG;


typedef struct tag_TDK_RULE_REGION_EXITING
{
	TDKS32							sensitiveValue;
}TDK_RULE_REGION_EXITING;

typedef struct tag_TDK_RULE_EXITING_ENTRANCE_RANGE
{
	TDKS32							sensitiveMin;
	TDKS32							sensitiveMax;
}TDK_RULE_REGION_EXITING_RANGE;

//struct region exiting
typedef struct tag_TDK_REGION_EXITING_CONFIG
{
	TDKBOOL								enable;
	TDKS32								ruleNum;				//The number of valid TDK_RULE_REGION_EXITING and TDK_AREA
	TDK_RULE_REGION_EXITING				rule[TDK_MAX_RULE];
	TDK_RULE_REGION_EXITING_RANGE		ruleRange;				//The range of TDK_RULE_REGION_EXITING
	TDK_AREA							area[TDK_MAX_RULE];
	TDK_SMART_ALARM						alarm;
}TDK_REGION_EXITING_CONFIG;



typedef struct tag_TDK_RULE_FAST_MOVING
{
	TDKS32							sensitiveValue;
}TDK_RULE_FAST_MOVING;

typedef struct tag_TDK_RULE_FAST_MOVING_RANGE
{
	TDKS32							sensitiveMin;
	TDKS32							sensitiveMax;
}TDK_RULE_FAST_MOVING_RANGE;

//struct fast moving
typedef struct tag_TDK_FAST_MOVING_CONFIG
{
	TDKBOOL								enable;
	TDKS32								ruleNum;				//The number of valid TDK_RULE_FAST_MOVING and TDK_AREA
	TDK_RULE_FAST_MOVING				rule[TDK_MAX_RULE];
	TDK_RULE_FAST_MOVING_RANGE			ruleRange;				//The range of TDK_RULE_FAST_MOVING
	TDK_AREA							area[TDK_MAX_RULE];
	TDK_SMART_ALARM						alarm;
}TDK_FAST_MOVING_CONFIG;


typedef struct tag_TDK_RULE_LOITERING_DETECTION
{
	TDKS32								timeThresholdValue;
	TDKS32								sensitiveValue;
	TDKU8								mask;			//bit: 0 : Journey   1: Weight   2 : Offset
}TDK_RULE_LOITERING_DETECTION;

typedef struct tag_TDK_RULE_LOITERING_DETECTION_RANGE
{
	TDKS32							timeThresholdMin;
	TDKS32							timeThresholdMax;
	TDKS32							sensitiveMin;
	TDKS32							sensitiveMax;
}TDK_RULE_LOITERING_DETECTION_RANGE;

//struct loitering detection
typedef struct tag_TDK_LOITERING_DETECTION
{
	TDKBOOL								enable;
	TDKS32								ruleNum;				//The number of valid TDK_RULE_LOITERING_DETECTION and TDK_AREA
	TDK_RULE_LOITERING_DETECTION		rule[TDK_MAX_RULE];
	TDK_RULE_LOITERING_DETECTION_RANGE	ruleRange;
	TDK_AREA							area[TDK_MAX_RULE];
	TDK_SMART_ALARM						alarm;
}TDK_LOITERING_DETECTION;



typedef struct tag_TDK_RULE_PEOPLE_GATHERING_DETECTION
{
	TDKS32								percentValue;
	TDKS32								sensitiveValue;
}TDK_RULE_PEOPLE_GATHERING_DETECTION;

typedef struct tag_TDK_RULE_PEOPLE_GATHERING_DETECTION_RANGE
{
	TDKS32							percentMin;
	TDKS32							percentMax;
	TDKS32							sensitiveMin;
	TDKS32							sensitiveMax;
}TDK_RULE_PEOPLE_GATHERING_DETECTION_RANGE;

//struct people gathering detection
typedef struct tag_TDK_PEOPLE_GATHERING_DETECTION
{
	TDKBOOL										enable;
	TDKS32										ruleNum;				//The number of valid TDK_RULE_PEOPLE_GATHERING_DETECTION and TDK_AREA
	TDK_RULE_PEOPLE_GATHERING_DETECTION			rule[TDK_MAX_RULE];
	TDK_RULE_PEOPLE_GATHERING_DETECTION_RANGE	ruleRange;
	TDK_AREA									area[TDK_MAX_RULE];
	TDK_SMART_ALARM								alarm;
}TDK_PEOPLE_GATHERING_DETECTION;


typedef struct tag_TDK_RULE_PARKING_DETECTION
{
	TDKS32								timeThresholdValue;
	TDKS32								sensitiveValue;
}TDK_RULE_PARKING_DETECTION;

typedef struct tag_TDK_RULE_PARKING_DETECTION_RANGE
{
	TDKS32							timeThresholdMin;
	TDKS32							timeThresholdMax;
	TDKS32							sensitiveMin;
	TDKS32							sensitiveMax;
}TDK_RULE_PARKING_DETECTION_RANGE;

//struct parking detection
typedef struct tag_TDK_PARKING_DETECTION
{
	TDKBOOL										enable;
	TDKS32										ruleNum;				//The number of valid TDK_RULE_PARKING_DETECTION and TDK_AREA
	TDK_RULE_PARKING_DETECTION					rule[TDK_MAX_RULE];
	TDK_RULE_PARKING_DETECTION_RANGE			ruleRange;
	TDK_AREA									area[TDK_MAX_RULE];
	TDK_SMART_ALARM								alarm;
}TDK_PARKING_DETECTION;


typedef struct tag_TDK_RULE_SCENE_CHANGE_DETECTION
{
	TDKS32								sensitiveValue;
}TDK_RULE_SCENE_CHANGE_DETECTION;

typedef struct tag_TDK_RULE_SCENE_CHANGE_DETECTION_RANGE
{
	TDKS32							sensitiveMin;
	TDKS32							sensitiveMax;
}TDK_RULE_SCENE_CHANGE_DETECTION_RANGE;

//struct scene change detection
typedef struct tag_TDK_SCENE_CHANGE_DETECTION
{
	TDKBOOL										enable;
	TDKS32										ruleNum;				//The number of valid TDK_RULE_SCENE_CHANGE_DETECTION
	TDK_RULE_SCENE_CHANGE_DETECTION				rule[TDK_MAX_RULE];
	TDK_RULE_SCENE_CHANGE_DETECTION_RANGE		ruleRange;
	TDK_SMART_ALARM								alarm;
}TDK_SCENE_CHANGE_DETECTION;


typedef struct tag_TDK_RULE_BLURRED_DETECTION
{
	TDKS32								sensitiveValue;
}TDK_RULE_BLURRED_DETECTION;

typedef struct tag_TDK_RULE_BLURRED_DETECTION_RANGE
{
	TDKS32							sensitiveMin;
	TDKS32							sensitiveMax;
}TDK_RULE_BLURRED_DETECTION_RANGE;

//struct blurred detection
typedef struct tag_TDK_BLURRED_DETECTION
{
	TDKBOOL										enable;
	TDKS32										ruleNum;				//The number of valid TDK_RULE_SCENE_CHANGE_DETECTION
	TDK_RULE_BLURRED_DETECTION					rule[TDK_MAX_RULE];
	TDK_RULE_BLURRED_DETECTION_RANGE			ruleRange;
	TDK_SMART_ALARM								alarm;
}TDK_BLURRED_DETECTION;


typedef struct tag_TDK_STRONG_SOUND_INTENSITY
{
	TDKS32			sensitiveValue;
	TDKS32			thresholdValue;
}TDK_STRONG_SOUND_INTENSITY;

typedef struct tag_TDK_STRONG_SOUND_INTENSITY_RANGE
{
	TDKS32			sensitiveMin;
	TDKS32			sensitiveMax;
	TDKS32			thresholdMin;
	TDKS32			thresholdMax;
}TDK_STRONG_SOUND_INTENSITY_RANGE;

typedef struct tag_TDK_SOUND_INTENSITY_DROPPED_SHARPLY
{
	TDKS32			sensitiveValue;
}TDK_SOUND_INTENSITY_DROPPED_SHARPLY;

typedef struct tag_TDK_SOUND_INTENSITY_DROPPED_SHARPLY_RANGE
{
	TDKS32			sensitiveMin;
	TDKS32			sensitiveMax;
}TDK_SOUND_INTENSITY_DROPPED_SHARPLY_RANGE;

//struct audio exception detection
typedef struct tag_TDK_AUDIO_EXCEPTION_DETECTION
{
	TDKBOOL										abnormalAudioIputEnable;			//Abnormal audio input enable 
	TDKBOOL										strongSoundIntensityEnable;			//Strong sound intensity enable
	TDKBOOL										soundIntensityDroppedSharplyEnable; //Sound intensity dropped sharply enable
	TDK_STRONG_SOUND_INTENSITY					strongSoundIntensity;
	TDK_STRONG_SOUND_INTENSITY_RANGE			strongSoundIntensityRange;
	TDK_SOUND_INTENSITY_DROPPED_SHARPLY			soundIntensityDropped;
	TDK_SOUND_INTENSITY_DROPPED_SHARPLY_RANGE	soundIntensityDroppedRange;
	TDK_SMART_ALARM								alarm;
}TDK_AUDIO_EXCEPTION_DETECTION;


typedef struct tag_TDK_RULE_CROSSING_LINE_STATISTICS
{
	TDKS32				index;
	TDK_POINT32			pointStart;
	TDK_POINT32			pointEnd;
	TDKS32				directionMask;
	TDKS32				direction;								//1:A->B   2:A<-B	0:A<=>B
	TDKBOOL				exist;
}TDK_RULE_CROSSING_LINE_STATISTICS;

//struct crossing line statistics
typedef struct tag_TDK_CROSSING_LINE_STATISTICS
{
	TDKBOOL								enable;
	TDKBOOL								osdOverlayEnable;
	TDK_POINT32							osdPositon;									//The upper-left coordinate of osd
	TDKS32								ruleNum;									//The number of valid TDK_RULE_CROSSING_LINE_STATISTICS
	TDK_RULE_CROSSING_LINE_STATISTICS	line[TDK_MAX_RULE];
	TDKBOOL								zeroFlag;									//if zeroFlag == 1, the crossing line statistics revert to 0
	TDKS32								scheduleNum;								//Number of time periods supported in a day, scheduleNum <= TDK_MAX_SCHEDULE
	TDK_SCHEDULE						schedule[TDK_DYAS_WEEK][TDK_MAX_SCHEDULE];	
}TDK_CROSSING_LINE_STATISTICS;


typedef struct tag_TDK_CROSSING_LINE_STATISTICS_DATA
{
	TDKU32								in;									//Enter the number of people
	TDKU32								out;								//Leave the number of people
}TDK_CROSSING_LINE_STATISTICS_DATA;

typedef enum tag_ENUM_TDK_CROSSING_LINE_STATISTICS_REPORT
{
	TDK_DAILY_REPORT = 0,			//Daily report
	TDK_WEEKLY_REPORT,				//Weekly report
	TDK_MONTHLY_REPORT,				//Monthly report
	TDK_ANNUAL_REPORT,				//Annual report
}ENUM_TDK_CROSSING_LINE_STATISTICS_REPORT;

//struct crossing line statistics report
typedef struct tag_TDK_CROSSING_LINE_STATISTICS_REPORT
{
	TDKU32										count;
	ENUM_TDK_CROSSING_LINE_STATISTICS_REPORT	type;												
	TDK_CROSSING_LINE_STATISTICS_DATA			data[TDK_MAX_CROSSING_LINE_STATISTICS_REPORT];		//if type is daily report, data[0] : 0:00 ~ 1:00 , data[1]: 1:00 ~ 2:00 ...... 
}TDK_CROSSING_LINE_STATISTICS_REPORT;																//if type is weekly report, data[0]: Sun. , data[i]: Mon.  .....
																									//if type is monthly report, data[0]:the first day, data[1]:the second day .....
																									//if type is annual report, data[0]:January, data[1]:February ....

typedef enum tag_ENUM_TDK_ALARM_IN_TYPE
{
	TDK_NORMAL_CLOSE = 0,			//normal close
	TDK_NORMAL_OPEN,				//normal open
}ENUM_TDK_ALARM_IN_TYPE;

//struct alarm in
typedef struct tag_TDK_ALARM_IN
{
	TDKBOOL						enable;
	TDKBOOL						portNameSupport;
	TDKS8						portName[64];			//utf-8 encoding
	ENUM_TDK_ALARM_IN_TYPE		type;
	TDK_SMART_ALARM				alarm;
}TDK_ALARM_IN;


typedef enum tag_ENUM_TDK_ALARM_OUT_TYPE
{
	TDKTYPE_STOP = 0,				//stop
	TDKTYPE_MANUAL,					//manual
	TDKTYPE_SCHEDULE,				//schedule
}ENUM_TDK_ALARM_OUT_TYPE;

typedef enum tag_ENUM_TDK_ALARM_OUT_STATUS
{
	TDK_OFF = 0,				
	TDK_ON,
}ENUM_TDK_ALARM_OUT_STATUS;

//struct alarm out
typedef struct tag_TDK_ALARM_OUT
{
	TDKBOOL							portNameSupport;
	TDKS8							portName[64];		//utf-8 encoding
	ENUM_TDK_ALARM_OUT_TYPE			type;
	ENUM_TDK_ALARM_OUT_STATUS		status;
}TDK_ALARM_OUT;

typedef enum tag_ENUM_TDK_PTZ_CONTROL
{
	TDK_PTZ_UP = 0,			//up
	TDK_PTZ_DOWN,			//down
	TDK_PTZ_LEFT,			//left
	TDK_PTZ_RIGHT,			//right
	TDK_PTZ_UPPER_LEFT,		//upper left
	TDK_PTZ_UPPER_RIGHT,	//upper right
	TDK_PTZ_LOWER_LEFT,		//lower left
	TDK_PTZ_LOWER_RIGHT,	//lower right
	TDK_PTZ_ZOOM_EXPAND,	//zoom expand
	TDK_PTZ_ZOOM_REDUCE,	//zoom reduce
	TDK_PTZ_FOCUS_EXPAND,	//focus expand
	TDK_PTZ_FOCUS_REDUCE,	//focus reduce
	TDK_PTZ_IRIS_EXPAND,	//iris expand
	TDK_PTZ_IRIS_REDUCE,	//iris reduce
}ENUM_TDK_PTZ_CONTROL;

typedef struct tag_TDK_PTZ_PARAM
{
	void*			param1;			//reserve
	void*			param2;			//reserve
	void*			param3;			//reserve
}TDK_PTZ_PARAM;

typedef enum tag_ENUM_TDK_SMART
{
	TDK_SMART_LINE_CROSSING = 0,   	//line crossing
	TDK_SMART_AREA_INTRUSION,     	//area intrusion
	TDK_SMART_MOTION_DETCTION,		//motion detection
	TDK_SMART_REGION_ENTRANCE,      //region entrance
	TDK_SMART_REGION_EXITING,       //region exiting
	TDK_SMART_FAST_MOVING,          //fast moving
	TDK_SMART_UNATTENDED_OBJECT,     //unattended object
	TDK_SMART_OBJECT_MISSING,       //object missing
	TDK_SMART_FACE_DETECTION,       //face detection
	TDK_SMART_LOITERING_DETECTION,	//loitering detection
	TDK_SMART_PARKING_DETECTION,	//parking detection	
	TDK_SMART_PEOPLE_GATHERING_DETECTION,       //people gathering detection
	TDK_SMART_CROSSING_LINE_STATISTICS,       //crossing line statistics
	TDK_SMART_BLURRED_DETECTION,       //blurred detection
	TDK_SMART_SCENE_CHANGE_DETECTION,  //scene change detection
	TDK_SMART_AUDIO_EXCEPTION_DETECTION,      //audio exception detection

}ENUM_TDK_SMART;


typedef struct tag_TDK_TCPIP
{
	TDKS8	ip[TDK_MAX_IPADDR_LEN];					//[IP]
	TDKU16	media_port;								//media port [˿]
	TDKU16	http_port;								//http port
	TDKS8	submask[TDK_MAX_IPADDR_LEN];			//sub net mask []
	TDKS8	gateway[TDK_MAX_IPADDR_LEN];			//gateway []
	TDKS8	major_dns[TDK_MAX_IPADDR_LEN];			//major DNS
	TDKS8	minor_dns[TDK_MAX_IPADDR_LEN];			//minor DNS, cannot be the same as major DNS
	TDKBOOL	dhcp;									//dhcp == 1 , DHCP valid
}TDK_TCPIP;

typedef struct tag_TDK_NETWORK
{
	TDKS8	ip[TDK_MAX_IPADDR_LEN];					//[IP]
	TDKS8	networkcardip[TDK_MAX_IPADDR_LEN];		//network card ip
	TDKS8	mac_addr[TDK_MACADDR_LEN];				//MAC address, must input
	TDKS8	submask[TDK_MAX_IPADDR_LEN];			//sub net mask 
	TDKS8	gateway[TDK_MAX_IPADDR_LEN];			//gateway 
	TDKS8	major_dns[TDK_MAX_IPADDR_LEN];			//major DNS
	TDKS8	minor_dns[TDK_MAX_IPADDR_LEN];			//minor DNS, cannot be the same as major DNS
	TDKBOOL	dhcp;									//dhcp == 1 , DHCP valid, dhcp == 2, DHCP invalid
}TDK_NETWORK;


//system config start!!!!!!!!!!!!!!!!!!!!!!!!!!
typedef struct tag_TDK_SYS_RECORDSTATUS
{
	TDKS32 chn;
	TDKS32 status;
	TDKS32 stream;
	TDKU32 fps;
	TDKU32 bitrate;
	TDKS32 redundent;
	TDKS8  resolution[128];
}TDK_SYS_RECORDSTATUS;

typedef struct tag_TDK_SYS_LOGINFOQUERY
{
	TDKU32 searchtype;
	TDK_SYSTEM_TIME       stime;
	TDK_SYSTEM_TIME       etime;
}TDK_SYS_LOGINFOQUERY;
typedef struct tag_TDK_SYS_LOGINFOCFG
{
	int support_clearall;
}TDK_SYS_LOGINFOCFG;
typedef struct tag_TDK_SYS_LOGINGOCFG
{
	TDK_SYSTEM_TIME       eventime;
	TDKU32				  eventype;
	TDKS32                INFOsize;
	TDKS8			      *eventINFO;

}TDK_SYS_LOGINFO;
//systen config end!!!!!!!!!!!!!!!!!!!!!!!!!!!!

//encode management start!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
enum TDK_ENC_COMPLEX
{
	TDK_ENC_CMOLEX_BASE = 0,
	TDK_ENC_CMOLEX_MAIN,
	TDK_ENC_CMOLEX_HIGHT

};
typedef struct tag_TDK_ENC_RES
{
	TDK_RULE_FAST_MOVING_RANGE* pSize;
	TDKS32 count;
	TDKS32 idx;
}TDK_ENC_RES;

typedef struct tag_TDK_ENC_CFG
{
	TDKU32     type;
	struct
	{
		TDKU32  val;
		TDKU32  sup;
	} cmp;
	struct
	{
		TDKU32  val;
		TDKU32  h265_sup;
		TDKU32  h264_sup;
		TDKU32  setting_sup;
		TDKU32  cmplex_sup;
	}cmplex;
	struct
	{
		TDKS32 video;
		TDKS32 audio;
		TDKU32 audio_sup;
	} AVido;
	struct
	{

		TDKS32 h264plus;
		TDKS32 h264plus_sup;
	}h264plus;
	TDKU32 imageQ;
	struct
	{
		TDKS32 alarm_MAXfps;
		TDKS32 MAXfps;
		TDKS32 cur;
	}fps;
	struct
	{

		TDKS32 min;
		TDKS32 max;
		TDKS32 cur;
	}IframeGop;
	struct
	{

		TDKS32 type;
		TDKS32 cur;
		TDKS32 setting_sup; //custom bitrate
		TDKS32 cus_sup; //custom bitrate
		TDKS32 cus_min[6];
		TDKS32 cus_max[6];
		TDKS32 list[6];
	}br;
	TDK_ENC_RES resolution;
}TDK_ENC_CFG;
typedef struct tag_TDK_ENC_CHNCFG
{
	int chn;
	int sup;
	TDKHANDLE pCode;
	TDK_ENC_CFG streamCFG[4];
}TDK_ENC_CHNCFG;
//resolution
typedef struct tag_TDK_ENC_QUERYRES
{
	TDKHANDLE pCode;
	int chn;
	int dest_stream;
	int main_stream;
	TDK_RULE_FAST_MOVING_RANGE main_res;

	//result
	TDK_RULE_FAST_MOVING_RANGE* res;
	TDKS32 count;
	TDKS32 cur_index;
}TDK_ENC_QUERYRES;
//fps
typedef struct tag_TDK_ENC_QUERYFPS
{
	TDKHANDLE pCode;
	TDKS32     chn;
	TDKS32     stream;

	//ڵһ
	TDK_RULE_FAST_MOVING_RANGE main_res;
	TDKS32 main_fps;

	//ڵһ
	TDK_RULE_FAST_MOVING_RANGE sub_res;
	TDKS32 sub_fps;
	TDK_RULE_FAST_MOVING_RANGE third_res;
	TDKS32 third_fps;

	//result
	//TDKS32 cur_fps;
	TDKS32 max_fps;
}TDK_ENC_QUERYFPS;
//bitrate
typedef struct tag_TDK_ENC_QUERYBITRATE
{
	TDKHANDLE pCode;
	TDKS32     chn;
	TDKS32     stream;

	//ڵһ
	TDK_RULE_FAST_MOVING_RANGE main_res;
	TDKS32 main_fps;


	TDKS32 bt_cus;

	//result
	TDKS32 cus_min[6];
	TDKS32 cus_max[6];
	TDKS32 list[6];
}TDK_ENC_QUERYBITRATE;
//set
typedef struct tag_TDKSTREAMDATA
{
	int type;
	int cmp;
	int enc_cap;
	int video_checked;
	int avdio_checked;
	TDK_RULE_FAST_MOVING_RANGE res;
	int fps;
	int bit_type;
	int imageQ;
	int br;
	int iframe;
	int h264p;
}TDKSTREAMDATA;
typedef struct TDKENCONDCFGDATA
{
	INT32 chn;
	TDKHANDLE pCode;
	TDKSTREAMDATA main_stream;
	TDKSTREAMDATA sub_stream;
}TDKENCONDCFGDATA;

//cover region
#define ENCCOVERNUM_MAX (8)
typedef struct
{
	int chn;
	int count;
	int enable;
	TDK_RECT32 cover[ENCCOVERNUM_MAX];
}TDK_ENC_COVER;

typedef struct
{
	int idv;
	int cover_count;
	TDK_RECT32 cover[ENCCOVERNUM_MAX];
}TDK_ENC_COVERDRAW;

//OSD
typedef struct
{
	int chn;
	struct
	{
		int sup;
		char name[64];
		struct
		{
			int sup;
			int modify_sup;
			int checked;
			TDK_RECT32 rect;
		}nameWidget;
	}chnName;

	struct
	{
		struct
		{
			int sup;
			int modify_sup;
			int checked;
			TDK_RECT32 rect;
		}timeWidget;
	}chnTime;

}TDK_ENC_OSD;
typedef struct
{
	int idv;
	POINT point;
	char name[64];
} TDK_ENC_OSDNameDRAW;
typedef struct
{
	int idv;
	POINT point;
} TDK_ENC_OSDTimeDRAW;
//encode management end!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

#define MAX_NETWORK_ADAPTER_NUM (8)
#define MAX_RTSPURL_LEN (512)
typedef struct
{
	TDKS8	ip[TDK_MAX_IPADDR_LEN];					//IPv4 [IP]
	TDKS8	mac_addr[TDK_MACADDR_LEN];				//MAC address [MACַ]
	TDKS8	submask[TDK_MAX_IPADDR_LEN];			//ipv4 sub net mask []
	TDKS8	gateway[TDK_MAX_IPADDR_LEN];			//ipv4 gateway []
	TDKS8	inner_ip[TDK_MAX_IPADDR_LEN];			//IPv4 [IP]
	TDKS8   inner_ip_sup;
	
	TDKS8   dhcp_sup;
	TDKS8   dhcp_checked;

	TDKS8   ethType;
	TDKS32  ethType_sup;
} TDK_NETWORK_ADAPTER;
typedef struct
{
	TDKS8	major_dns_sup;
	TDKS8	major_dns[TDK_MAX_IPADDR_LEN];			//ipv4 major DNS
	TDKS8	minor_dns_sup;
	TDKS8	minor_dns[TDK_MAX_IPADDR_LEN];			//ipv4 minor DNS
} TDK_NETWORK_DNS;
typedef struct
{
	TDKS32 HS_download_sup;
	TDKS32 HS_download;

	TDKS32 transfer_mode_sup;
	TDKS32 transfer_CheckBox_enable;
	TDKS32 transfer_CheckBox_checked;
	TDKS32 transfer_comboBox_enable;
	TDKS32 transfer_comboBox_value;

	TDKS32 http_port;
	TDKS32 http_port_sup;

	TDKS32 max_con_max;
	TDKS32 max_con_val;
	TDKS32 max_con_min;
	TDKS32 max_con_sup;

	TDKS32 moblie_port;
	TDKS32 moblie_port_sup;

	TDKS32 tcp_port;
	TDKS32 tcp_port_sup;

	TDKS32 https_port_sup;
	TDKS32 https_port;
} TDK_NETWORK_TCP;
typedef struct
{
	TDKS32 rtsp_sup;
	TDKS32 rtsp_port;
	TDKS8  rtsp_url[MAX_RTSPURL_LEN];
} TDK_NETWORK_RTSP;
typedef struct
{
	TDK_NETWORK_TCP tcp;
	TDK_NETWORK_RTSP rtsp;
	TDK_NETWORK_DNS  dns;
	TDK_NETWORK_ADAPTER adapter[MAX_NETWORK_ADAPTER_NUM];
	TDKS8 network_adapter_count; // < MAX_NETWORK_ADAPTER_NUM
	TDKS8 network_adapter_default;
	TDKHANDLE pcfg;
} TDK_DEVICE_TCPIP;

//channel management
typedef enum tag_TDK_ENUM_CHANNEL_STATE
{
	TDK_CHN_STATE_UNKOWN = 0,
	TDK_CHN_STATE_NOCONFIG = 1,				// not config
	TDK_CHN_STATE_DISABLE = 2,				// off
	TDK_CHN_STATE_CONNECTING = 3,			// connecting
	TDK_CHN_STATE_AUTHORITY = 4,			// authorize failed
	TDK_CHN_STATE_LINKED = 5,				// connected
}TDK_ENUM_CHANNEL_STATE;

typedef struct tag_TDK_CHANNEL_STATE_ALARM
{
	TDKS8	support;		//0-unsupport, 1-support
	TDKS8	enableState;	//0-open, 1-close
	TDKS8	alarmState;		//0-no alarm, 1-alarming
}TDK_CHANNEL_STATE_ALARM;
//channel state
typedef struct tag_TDK_CHANNEL_STATE
{
	TDKU32					chn;							// logic chn number, start from 0
	TDKS8					chnName[TDK_CHANNEL_NAME_SIZE];	// channel name
	TDK_ENUM_CHANNEL_STATE	connectionState;				// the connection state of the channel, ref TDK_ENUM_CHANNEL_STATE

	TDKU32					mainstreamWidth;				// width of the main-stream resolution
	TDKU32					mainstreamHeight;				// height of the main-stream resolution

	TDKU32					substreamWidth;					// width of the sub-stream resolution
	TDKU32					substreamHeight;				// height of the sub-stream resolution

	TDK_CHANNEL_STATE_ALARM	motionDetect;					// alarm state of motion detect
	TDK_CHANNEL_STATE_ALARM	videoShelter;					// alarm state of video shelter
	TDK_CHANNEL_STATE_ALARM	videoLoss;						// alarm state of video loss
}TDK_CHANNEL_STATE;
typedef struct tag_TDK_CHANNELS_STATE
{
	TDKU32				count;								// count of channel state
	TDK_CHANNEL_STATE	states[TDK_MAX_CHANNEL];			// array of channel state
}TDK_CHANNELS_STATE;

typedef struct tag_TDK_GLOBAL_PARAM
{
	TDKU32	streamThreadCount;   // count of stream thread
	TDKBOOL enableLogging;       // enable print log
	TDKBOOL enableAutoReconnect; // enable auto reconnect device
}TDK_GLOBAL_PARAM, * PTDK_GLOBAL_PARAM;

#endif