#ifndef COMMON_CONFIG_H_
#define COMMON_CONFIG_H_
#include "TDKType.h"


#define TDK_MAX_IPADDR_LEN				16			//max size of IP address string [IPַַ]
#define TDK_MAX_IPV6ADDR_LEN			48			//max size of IPV6 address string [IPַַ]
#define TDK_MACADDR_LEN					40			//max size of MAC address string [MACַַ]
#define TDK_DEV_TYPE_LEN				32			//max size of device type string [豸ַ]
#define TDK_DEV_OEM_LEN					8			//max size of device OEM string [豸ַ]
#define TDK_DEV_MODEL_LEN				128			//max size of device model string [豸ַ]
#define TDK_MAX_CHANNEL					64



enum ptz_link_type
{
	PTZ_LINK_NONE,			/*!< Ҫ */
	PTZ_LINK_PRESET,			/*!< תԤõ */
	PTZ_LINK_TOUR,			/*!< Ѳ */
	PTZ_LINK_PATTERN			/*!< 켣 */
};
typedef struct tagPTZ_LINK
{
	TDKU8 ucType;					/*!     */
	TDKU8 ucVersion;                /*! 汾      */
	TDKU8 ucChannel;                /*! ͨ  */
	TDKU8 Res;						/*!     */
	TDKU8 ucValue;                  /*!     */
	TDKU8 ucRes[3];                 /*!     */
}PTZ_LINK;
typedef struct
{
	TDKU32	dwRecord;				/*!< ¼ */
	TDKS32	iRecordLatch;			/*!< ¼ʱ10300 sec */
	TDKU32	dwTour;					/*!< Ѳ */
	TDKU32	dwSnapShot;				/*!< ץͼ */
	TDKU32	dwAlarmOut;				/*!< ͨ */
	TDKS32	iAOLatch;				/*!< ʱ10300 sec */
	PTZ_LINK PtzLink[64];		/*!< ̨ */

	TDKS32	bRecordEn;				/*!< ¼ʹ */
	TDKS32	bTourEn;				/*!< Ѳʹ */
	TDKS32	bSnapEn;				/*!< ץͼʹ */
	TDKS32	bAlarmOutEn;			/*!< ʹ */
	TDKS32	bPtzEn;					/*!< ̨ʹ */
	TDKS32	bTip;					/*!< Ļʾʹ */
	TDKS32	bMail;					/*!< ʼ */
	TDKS32	bMessage;				/*!< Ϣ */
	TDKS32	bBeep;					/*!<  */
	TDKS32	bVoice;					/*!< ʾ */
	TDKS32	bFTP;					/*!< FTP */

	TDKS32	iWsName;				/*!< ʱѡʱʹҲ */
	TDKU32	dwMatrix;				/*!<  */
	TDKS32	bMatrixEn;				/*!< ʹ */
	TDKS32	bLog;					/*!< ־ʹܣĿǰֻWTN̬ʹ */
	TDKS32	iEventLatch;			/*!< ʼʱʱ䣬sΪλ */
	TDKU32	bMessagetoNet;			/*!< Ϣϴʹ */
	TDKU32	dwRecordEx;				//!¼32-64ͨλʾ
	TDKU32	dwTourEx;				//!Ѳ32-64ͨλʾ
	TDKU32	dwSnapShotEx;			//!ץͼ32-64ͨλʾ

	TDKU32	dwSmartLight;
	TDKS32 	iSmartLightLatch;          /*!< SmartLightʱ10300 sec */
	TDKU32	dwReserved[2]; 			/*!< ֽ */
} TDK_EVENT_HANDLE;

#define N_WEEKS (7)
#define N_TSECT (12)
typedef struct
{
	//!ʹ
	TDKS32 enable;
	//!ʼʱ:Сʱ
	TDKS32 startHour;
	//!ʼʱ:
	TDKS32    startMinute;
	//!ʼʱ:
	TDKS32    startSecond;
	//!ʱ:Сʱ
	TDKS32    endHour;
	//!ʱ:
	TDKS32    endMinute;
	//!ʱ:
	TDKS32    endSecond;
}TDK_TIME_SEG;
typedef struct tagWORKSHEET
{
	TDKS32		 name; /*!< ʱ */
	TDK_TIME_SEG seg[N_WEEKS][N_TSECT];	/*!< ʱ */
}TDK_TIME_SHEET;



typedef struct
{
	//general 
	TDKS32 chn; //button and sensitive eable
	TDKS32 buttonEable_eable; // button enable checked?
	TDKS32 CBsensitive_visiable; //sensitive visiable

	TDKS32 Ped;

	TDKS32 interval;
	TDKS32 interval_min;
	TDKS32 interval_max;

	TDKS32 schedule;
	TDKS32 schedulenum[N_WEEKS];

	TDKS32 alarm_out; 		//alarm link
	TDKS32 alarmout_num;
	TDKS32 alarmouttime_min;
	TDKS32 alarmouttime_max;

	TDKS32 tips_onscreen;   //screen tips

	TDKS32 email;            //email

	TDKS32 rec;
	TDKS32 rec_chnNum;
	TDKS32 recdeaytime_min;
	TDKS32 recdeaytime_max;

	TDKS32 ptzlink;
	TDKS32 ptzlink_num;

	TDKS32 tour;
	TDKS32 tour_count;

	TDKS32 beep_check;
	TDKS32 beep_time;
	TDKS32 beeptime_min;
	TDKS32 beeptime_max;

	TDKS32 snapshot;
	TDKS32 snapshot_count;
	TDKS32 snaptime;
	TDKS32 snaptime_min;
	TDKS32 snaptime_max;

	TDKS32 smartlight;
	TDKS32 smartlighttime;
	TDKS32 smartlighttime_min;
	TDKS32 smartlighttime_max;

	TDKS32 region;
}TDK_EVENTHANDLE_ABILITY;
#endif