#ifndef SYSTEMINFO_H_
#define SYSTEMINFO_H_

#include "TDKType.h"
#include "TDKCFG/TDKCommon.h"

#define MAX_SYSTEMINFO_LEN (64)

typedef struct
{
	TDKS8  mac[TDK_MACADDR_LEN];

	TDKS32 uvr;
	TDKS32 uvr_analogy;
	TDKS32 uvr_digital;
	TDKS32 chnNum;

	TDKS32 audio_input;
	TDKS32 audio_output;

	TDKS32 alarm_input;
	TDKS32 alarm_output;

	TDKS8 system[MAX_SYSTEMINFO_LEN];
	TDKS8 release[MAX_SYSTEMINFO_LEN];

	TDKS32 cloud_upgrade;
}TDK_SYSTEM_INFO;

typedef struct
{
	TDKS32 status;
	TDKS8 system[MAX_SYSTEMINFO_LEN];
	TDKS8 release[MAX_SYSTEMINFO_LEN];
}TDK_SYSTEM_INFO_CLOUDSTATUS;
typedef struct
{
	TDKS32 process;
}TDK_SYSTEM_INFO_CLOUDUPGRADEPROCESS;
#endif