#ifndef HDDBASE_H_
#define HDDBASE_H_

#include "TDKType.h"
#include "TDKCFG/TDKCommon.h"
#define MAX_HDDNUM (24)
#define MAX_HDDNAMELEN (128)

typedef struct
{
	TDKU32	id;
	TDKS8	name[MAX_HDDNAMELEN];
	TDKU32	type;
	TDKU32	status;
	TDKU32  property;
	TDKU32  capacity;
	TDKU32  spaceUsed;
	TDKS32  errCode;
	TDKU32  diskGrpId;
	TDKS32  backup;
}TDK_STORAGE_HDDCFG;

typedef struct
{
	TDKS32	chnid;
	TDKS32  recSpaceQuota;
	TDKS32  recSpaceUsed;

	TDKS32  picSpaceQuota;
	TDKS32  picSpaceUsed;

	TDKS32  recTimeQuota;
	TDKS32  recTimeUsed;

	TDKS32  recCapacity;
	TDKS32  picCapacity;

	TDKS64  diskGrpId_in;
}TDK_STORAGE_HDDCHNCFG;

typedef struct
{
	int devicetype;
}TDK_STORAGE_HDDBASE;


typedef struct tag_TDK_STORAGE_HDDBASE_OTHERS :
	public TDK_STORAGE_HDDBASE
{
	TDKU64 HDDability;
	TDKS32 dormant;
	TDKS32 dataKeptDays;
	TDKS32 diskGrpCount;
	TDKS32 HDDcount;
	TDKS32 dataKeepRecordDays;
	TDKS32 dataTotalRecordDays;
	TDKS32 dataFreeRecordDays;
	TDKS32 custom;
	TDK_STORAGE_HDDCFG hdd[MAX_HDDNUM];
}TDK_STORAGE_HDDBASE_OTHERS;


typedef struct tag_TDK_STORAGE_HDDBASE_IPC :
public TDK_STORAGE_HDDBASE_OTHERS
{
	TDKS32 ipc_mode;
	TDKS32 ipc_sup_picQuota;
	TDKS32 ipc_hddcapacity;
	TDK_STORAGE_HDDCHNCFG ipc_hddchninfo;
}TDK_STORAGE_HDDBASE_IPC;
#endif