/******************************************************************
File Name  : TimeShaftDlg.h
Description: implement draw Timeshaft
Programmer : DVR 
Edit by:lidapeng
Copyright  : qualvision technology 
Make Date  : 2014.8.21
********************************************************************/
#pragma once

#include <vector>
#include <map>
//#include "..\\Depends\\SDKBase.h"

#define N_PLY_CH             64
#define MAX_LIST_FILES		512			// бŶٸļ

/// ϵͳʱṹ
typedef struct SYSTEM_TIME{
	int  year;///< ꡣ   
	int  month;///< £January = 1, February = 2, and so on.   
	int  day;///< ա   
	int  wday;///< ڣSunday = 0, Monday = 1, and so on   
	int  hour;///< ʱ   
	int  minute;///< ֡   
	int  second;///< 롣   
	int  isdst;///< ʱʶ   
}SYSTEM_TIME;

typedef struct _CHNINFO
{
	int chnnum;				// ͨţ0ʼ
	std::string text;		// ǰͨʾļΪΪͨ+1ַ
}CHNINFO;

// һļϢ
typedef struct _FILEINFOONE
{
	int type;	// typeΪ¼
	SYSTEM_TIME timebegin;	// timebeginΪʼʱ
	SYSTEM_TIME timeend;	// timeendΪʱ
}FILEINFOONE;

// ĳͨļϢб
typedef struct _FILEINFO
{
	unsigned char chn;		// chnΪͨ
	unsigned short num;		// numָpfiles
	FILEINFOONE files[MAX_LIST_FILES];
}FILEINFO;

typedef int							VD_BOOL;
typedef void (CALLBACK *CTRLPROC2)(int, SYSTEM_TIME*,unsigned long long pContext);


// TimeShaftDlg Ի
class TimeShaftDlg : public CDialog
{
	DECLARE_DYNAMIC(TimeShaftDlg)

public:
	TimeShaftDlg(CWnd* pParent = NULL);   // ׼캯
	virtual ~TimeShaftDlg();
// Ի
	enum { IDD = IDD_DIALOG_TIMESHAFT };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV ֧

	DECLARE_MESSAGE_MAP()

public:
	typedef enum _ENUM_SHATF_RANGE
	{
		ESR_24HR = 0, 
		ESR_2HR, 
		ESR_1HR, 
		ESR_30MIN
	}ENUM_SHATF_RANGE;


	typedef struct _BGINFO
	{
		VD_BOOL isshow;
		int chn;
		int type;
		SYSTEM_TIME beg;
		SYSTEM_TIME end;
		CRect rect;
	}BGINFO;

	CTRLPROC2 m_proc;
	CWnd* m_pParentWnd;
	void RegisterPlayCallback(CTRLPROC2 cbFun,void* pContext)
	{
		m_proc = cbFun;
		m_pParentWnd = (CWnd*)pContext;
	}

private:
	static const int TIMELENGTH	= 10;

private:
	// 
	int m_margin_left;
	int m_margin_top;
	int m_margin_right;
	int m_margin_bottom;
	CRect m_rectall;					// ؼrect
	CRect m_rectgrid;					// ʱľ
	int m_possum;						// ʱָܷ
	// Ƶ
	//enum_videout_type m_vidouttype;
	// ʱУֵ֧Ͳμ:ENUM_SHATF_RANGE
	int m_col;
	ENUM_SHATF_RANGE m_shafttype;		// ʱͣ24hr, 2hr, 1hr, 30min
	SYSTEM_TIME m_shafttimebeg;			// ʱʼʱ䣬24hrʱ˱Ч
	SYSTEM_TIME m_shafttimeend;			// ʱĽʱ䣬24hrʱ˱Ч
	std::vector<std::string> m_coltext;	// ʱеַm_shafttypeֵͬͬ
	// ʱ
	int m_rownum_show;					// ʱУһҳʾ
	int m_rownum_all;					// ʱе
	int m_rownum_page;					// ʱУǰǵڼҳ
	std::vector<CHNINFO> m_rowtext;		// ʱеַͨSetChnRange
	std::map<int, int> m_rowmap;		// еһӳ䣬<ʵͨ>  -->  <m_rowtext>
	// m_rowmapĴڣʹʱ֧ͨ
	std::vector<int> m_roworder;		// ¼ʵͨţΪ˱˳ʱ
	// ʱϵʾ
	char m_timetext[N_PLY_CH][TIMELENGTH];
	CRect m_timeposrect[N_PLY_CH];
	CRect m_timetextrect[N_PLY_CH];
	// ʱϵĵɫʾ
	std::vector<BGINFO> m_bginfo[N_PLY_CH];
	// ¼Ϣ
	VD_BOOL m_eventdrap;				// ϷϢ¼Ƿа
	int m_eventchn;						// ¼XM_LBUTTONDOWNʱͨ
	// ¼ͨʱ飬¼ÿͨĵǰʱ
	SYSTEM_TIME m_curtime[N_PLY_CH];

	CBrush m_tBrushBG;//ɫ
	CBrush m_tBrushFG;//ǰɫ
	CFont m_Font;
	bool  m_bNew;
public:
	
	void Init();
	VD_BOOL SetChnRange(const std::vector<CHNINFO> &vecrow, int maxShowNum = 4);
	VD_BOOL ChnDown(VD_BOOL reset = FALSE);
	VD_BOOL ChnChange(int chn);
	VD_BOOL SetTimeRange(ENUM_SHATF_RANGE type, int chn, VD_BOOL force = FALSE);
	VD_BOOL UpdateTimeRange(int chn);
	VD_BOOL SeekPos(int chn, const SYSTEM_TIME *sttime);
	VD_BOOL ClearPos();
	VD_BOOL SetFileInfo(const SYSTEM_TIME *curDate,int num, const FILEINFO *pfileinfo);

	void Draw();
	CFont* font;
	COLORREF color_Normal_New;
	//VD_BOOL MsgProc(uint msg, uint wpa, uint lpa);

private:
	void jxprint(CRect rect, char *funname, char* str);
	void calRect();
	VD_BOOL setTimeRange(ENUM_SHATF_RANGE type, const SYSTEM_TIME *sttime, VD_BOOL force);
	VD_BOOL calcTimeRange(ENUM_SHATF_RANGE type, const SYSTEM_TIME *st, SYSTEM_TIME *stbeg, SYSTEM_TIME *stend);
	VD_BOOL calPercentFromTime(const SYSTEM_TIME *sttime, int *percent);
	VD_BOOL calChnTimeFromPoint(int px, int py, int *chn, SYSTEM_TIME *sttime);
	VD_BOOL calBGInfo(BGINFO *pinfo);
	VD_BOOL checkPositionValid(int chn, int x, int y, SYSTEM_TIME *st);
	VD_BOOL checkTimeValid(const SYSTEM_TIME *sttime);
	int compareDate(const SYSTEM_TIME *st1, const SYSTEM_TIME *st2);
	int compareTime(const SYSTEM_TIME *st1, const SYSTEM_TIME *st2);
	VD_BOOL ClearFileInfo();
	void rowtextClear();
	void rowtextAdd(const CHNINFO &_info);
	void coltextClear();
	void coltextAdd(const char *str);
public:
	int m_ChnNum;
	//ʱУһҳʾ
	void SetMaxRowNum(int ChnNum);
	virtual BOOL OnInitDialog();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnPaint();
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	virtual BOOL DestroyWindow();
	void SetNew(bool bNew);
	void GetBeginTimeAndEndTime(SYSTEM_TIME& beginTime, SYSTEM_TIME& endTime);
	SYSTEM_TIME GetCurTime(int chn);
	void GetChnTime(int chn,SYSTEM_TIME &time);
	void ClearCurTime(int nChn);
};