// TimeShaftDlg.cpp : ʵļ
//

#include "stdafx.h"
//#include "VS100.h"
#include "SDKDemo.h"
#include "TimeShaftDlg.h"

#define  COLOR_GRAY67 RGB(67,67,67)
#define  COLOR_GRAY112 RGB(112,112,112)
#define  COLOR_NORMAL RGB(34,172,56)
#define  COLOR_ALARM RGB(125,0,0)
#define  COLOR_MD RGB(243,152,0)
#define  COLOR_LINE RGB(98,98,98)
#define  COLOR_NORMAL_NEW RGB(12,191,194)
// TimeShaftDlg Ի

IMPLEMENT_DYNAMIC(TimeShaftDlg, CDialog)

TimeShaftDlg::TimeShaftDlg(CWnd* pParent /*=NULL*/)
	: CDialog(TimeShaftDlg::IDD, pParent)
{

	COLORREF color_TimeShaft_BK = RGB(100,10,10);// CGlobalpublicData::GetIniColor(_T("TimeShaft_BK"));
	COLORREF color_TimeShaft_FG = RGB(120, 120, 120); //CGlobalpublicData::GetIniColor(_T("TimeShaft_FG"));
	color_Normal_New = RGB(12, 191, 194);// CGlobalpublicData::GetIniColor(_T("TimeShaft_Playback_Graduation_Strip"));

	m_tBrushBG.CreateSolidBrush(color_TimeShaft_BK);
	m_tBrushFG.CreateSolidBrush(color_TimeShaft_FG);
	m_proc = NULL;
	m_pParentWnd = NULL;
	m_ChnNum = 0;
// 	m_Font.CreateFont(
// 		22,                        // nHeight
// 		0,                         // nWidth
// 		0,                         // nEscapement
// 		0,                         // nOrientation
// 		FW_NORMAL,                 // nWeight		
// 		FALSE,                     // bItalic
// 		FALSE,                     // bUnderline
// 		0,                         // cStrikeOut
// 		ANSI_CHARSET,              // nCharSet
// 		OUT_DEFAULT_PRECIS,        // nOutPrecision
// 		CLIP_DEFAULT_PRECIS,       // nClipPrecision
// 		DEFAULT_QUALITY,           // nQuality
// 		DEFAULT_PITCH | FF_SWISS,  // nPitchAndFamily
// 		_T("Microsoft YaHei"));             // lpszFacename

	//CGlobalpublicData::GetFont(_T("Font"), _T("Font_Type"), _T("Font_Size"), _T("Font_Weights"), _T("playback_timeshaft"), FONT_INI, /*FW_NORMAL,*/ m_Font);
	m_Font.CreateFont(20, 0, 0, 0, 10,/*fwType,*/ FALSE, FALSE, FALSE, DEFAULT_CHARSET,
		OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH | FF_SWISS, L"΢ź");

	m_margin_left = 20;
	m_margin_top = 20;
	m_margin_right = 10;
	m_margin_bottom = 1;
	m_eventdrap = FALSE;
	// ʼʱΪ0
	for (int i = 0; i < N_PLY_CH; i++)
	{
		m_curtime[i].hour = 0;
		m_curtime[i].minute = 0;
		m_curtime[i].second = 0;
	}
	//Ĭ24Сʱʾ
	coltextClear();
	char sz[TIMELENGTH];
	m_col = 24;
	for (int i = 0; i <= m_col; i++)
	{
		sprintf_s(sz, TIMELENGTH, "%d", i);
		coltextAdd(sz);
	}
	m_possum = 0;
	// ˢĳЩ
	ClearPos();
	ClearFileInfo();
	memset(m_timetext,0,sizeof(m_timetext));
	memset(m_timeposrect,0,sizeof(m_timeposrect));
	memset(m_timetextrect,0,sizeof(m_timetextrect));
	memset(m_curtime,0,sizeof(m_curtime));
}

TimeShaftDlg::~TimeShaftDlg()
{
	m_tBrushBG.DeleteObject();
	m_tBrushFG.DeleteObject();
	m_Font.DeleteObject();
	m_rowtext.clear();
	m_rowmap.clear();
	m_roworder.clear();
	for ( int i = 0; i < N_PLY_CH; i++ )
	{
		m_bginfo[i].clear();
	}
}

void TimeShaftDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(TimeShaftDlg, CDialog)
	ON_WM_SIZE()
	
	ON_WM_PAINT()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
END_MESSAGE_MAP()


// ³ʼڽʱҪһ
void TimeShaftDlg::Init()
{
	SetTimeRange(ESR_24HR,0,TRUE);

}

// ʱͨţֲ֧ͬͨ
VD_BOOL TimeShaftDlg::SetChnRange(const std::vector<CHNINFO> &vecrow, int maxShowNum/* = 4*/)
{
	
	if (maxShowNum>m_ChnNum)
	{
		m_rownum_show = m_ChnNum;
	}
	else
	{
		m_rownum_show = maxShowNum;	// һҳʾ
	}		
	m_rownum_all = (int)vecrow.size();		// е
	m_rownum_page = 0;					// Ĭǵ0ҳҲǰm_rownum_showʾ

	// vecrowݷ뵽m_rowtext
	rowtextClear();
	for (std::size_t i = 0; i < vecrow.size(); i++)
	{
		rowtextAdd(vecrow[i]);
	}

	// ˢĳЩ
	ClearPos();
	// лťлʱҪ¼ʱϵĵɫ
	for (int i = 0; i < N_PLY_CH; i++)
	{
		for (std::size_t j = 0; j < m_bginfo[i].size(); j++)
		{
			calBGInfo(&m_bginfo[i][j]);
		}
	}

	return TRUE;
}

// лһҳ
// reset: ΪTRUEлһҳ
VD_BOOL TimeShaftDlg::ChnDown(VD_BOOL reset/* = FALSE*/)
{
	printf("<jxlog> TimeShaftDlg::ChnDown m_rowtext: \n");
	for (int i = 0; i < m_rownum_all; i++)
	{
		printf("chn=%d; text=%s\n", m_rowtext[i].chnnum, m_rowtext[i].text.c_str());
	}
	printf("\n");

	if ( m_rownum_all == 0 )
	{
		return FALSE;
	}

	if (reset)
	{
		//modify by kui.wang 2016-5-25 οcms
		/*m_rownum_page = 0;*/
		m_rownum_page = (m_rownum_page - 1) %
			(m_rownum_all / m_rownum_show + ((m_rownum_all % m_rownum_show) ? 1 : 0));
		if (m_rownum_page < 0)
		{
			m_rownum_page = (m_rownum_all / m_rownum_show + ((m_rownum_all % m_rownum_show) ? 1 : 0)) - 1;
		}
	}
	else
	{
		m_rownum_page = (m_rownum_page + 1) % 
			(m_rownum_all / m_rownum_show + ((m_rownum_all % m_rownum_show) ? 1 : 0));
	}

	printf("<jxlog> m_rownum_show=%d\n", m_rownum_show);
	printf("<jxlog> m_rownum_all=%d\n", m_rownum_all);
	printf("<jxlog> m_rownum_page=%d\n", m_rownum_page);

	m_rowmap.clear();
	m_roworder.clear();

	int beg = m_rownum_page * m_rownum_show;
	for (int i = beg; i < beg + m_rownum_show && i < m_rownum_all; i++)
	{
		m_rowmap[m_rowtext[i].chnnum] = i;		// ӳϵ	// <jx> 20140408
		m_roworder.push_back(m_rowtext[i].chnnum);
	}

	// лһҳʱҪ¼ʱϵĵɫ
	for (int i = 0; i < N_PLY_CH; i++)
	{
		for (std::size_t j = 0; j < m_bginfo[i].size(); j++)
		{
			calBGInfo(&m_bginfo[i][j]);
		}
	}

	Draw();

	return TRUE;
}

// ͨıʱлͨţΪ˴лʱһҳ
// :12345678˸ͨ1ʱӦڵһҳ5ʱӦΪڶҳ
// chn: Ϊͨ
VD_BOOL TimeShaftDlg::ChnChange(int chn)
{
	int page = -1;
	for (std::size_t i = 0; i < m_rowtext.size(); i++)
		if (m_rowtext[i].chnnum == chn)
			page = (int)i;

	if (page == -1)
		return FALSE;

	page = page / m_rownum_show;

	if (page == m_rownum_page)
		return TRUE;
	else
		m_rownum_page = page;

	m_rowmap.clear();
	m_roworder.clear();

	int beg = m_rownum_page * m_rownum_show;
	for (int i = beg; i < beg + m_rownum_show && i < m_rownum_all; i++)
	{
		m_rowmap[m_rowtext[i].chnnum] = i;		// ӳϵ	// <jx> 20140408
		m_roworder.push_back(m_rowtext[i].chnnum);
	}

	// лҳʱҪ¼ʱϵĵɫ
	for (int i = 0; i < N_PLY_CH; i++)
	{
		for (std::size_t j = 0; j < m_bginfo[i].size(); j++)
		{
			calBGInfo(&m_bginfo[i][j]);
		}
	}

	Draw();

	return TRUE;
}

// ʱʱ䷶Χ
//   typeָ24hr, 2hr, 1hr, 30minеһμöٶ
//   chnΪͨţΪȡʱֵлָͨʱķΧ
// ע:typeΪESR_24HRʱchnԺԣ0
VD_BOOL TimeShaftDlg::SetTimeRange(ENUM_SHATF_RANGE type, int chn, VD_BOOL force/* = FALSE*/)
{
	if (chn < 0 || chn >= N_PLY_CH/* || m_rowmap.end() == m_rowmap.find(chn)*/)
		return FALSE;

	setTimeRange(type, &m_curtime[chn], force);
	return 0;
}

// ʱ䷶Χ˽ӿڵô:
// 1. лͨʱҪ
// 2. ʱʱڿܻᳬǰʱΣҲҪô˽ӿ
//     ݵǰѡеͨ
VD_BOOL TimeShaftDlg::UpdateTimeRange(int chn)
{
	if (chn < 0 || chn >= N_PLY_CH || m_rowmap.end() == m_rowmap.find(chn))
		return FALSE;

	SetTimeRange(m_shafttype, chn);

	return TRUE;
}

// õǰʱĺ
//   chnΪͨ
//   sttimeΪǰŵʱ䣬TimeShaftDlgὫʱƵ
// ע:sttimeΪNULLʱյǰͨʱַ
VD_BOOL TimeShaftDlg::SeekPos(int chn, const SYSTEM_TIME *sttime)
{
	//printf("<jxlog> TimeShaftDlg::SeekPos entry.\n");
	if (chn < 0 || chn >= N_PLY_CH)
	{
		return FALSE;
	}
	
	if (sttime == NULL) 
	{
		memset(m_timetext[chn], 0, TIMELENGTH);
		if ( m_rowmap.end() == m_rowmap.find(chn) )
		{
			return FALSE;
		}
		Draw();
		return TRUE;
	}

	if ( m_rowmap.end() == m_rowmap.find(chn) )
	{
		return FALSE;
	}

	CRect rect;
	int percent = 0;
	int poswidth = 2;		// Ŀ
	int topindex;			// topbottom

	// Ӧͨʱ䱣浽Ա
	m_curtime[chn] = *sttime;

	// òλʱҪ
	//SetTimeRange(m_shafttype);

	// sttimeʱʱϵǧֱλãõpercentڲῼʱ
	if (!calPercentFromTime(sttime, &percent))
		return FALSE;

	// Ҫʾʱַ
	sprintf_s(m_timetext[chn], "%02d:%02d:%02d", sttime->hour, sttime->minute, sttime->second);

	// m_rowmapȡͨŵvalueȡͨλ
	// Ҫټȥǰҳǰͨõǰҳλ
	// ôλütopbottomȷ
	// ע:m_rownum_page * m_rownum_showõǰҳͨ
	// :ǰǵڶҳһҳʾ4ͨҪȥ4(1*4)
	topindex = m_rowmap[chn] - (m_rownum_page * m_rownum_show);

	m_timeposrect[chn].left = m_rectgrid.left + percent * m_rectgrid.Width() / m_possum - poswidth/2;
	m_timeposrect[chn].right = m_rectgrid.left + percent * m_rectgrid.Width() / m_possum + poswidth/2;
	m_timeposrect[chn].top = m_rectgrid.top + (topindex+0) * m_rectgrid.Height() / m_rownum_show + 1;
	m_timeposrect[chn].bottom = m_rectgrid.top + (topindex+1) * m_rectgrid.Height() / m_rownum_show;
	if (m_timeposrect[chn].left < m_rectgrid.left) {
		m_timeposrect[chn].left = m_rectgrid.left;
		m_timeposrect[chn].right = m_timeposrect[chn].left + poswidth;
	}
	if (m_timeposrect[chn].right > m_rectgrid.right) {
		m_timeposrect[chn].right = m_rectgrid.right;
		m_timeposrect[chn].left = m_timeposrect[chn].right - poswidth;
	}

	CDC* pdc = GetDC();
	if ( !pdc )
	{
		return FALSE;
	}
	CString str;
	str = m_timetext[chn];
	CSize width = pdc->GetTextExtent(str/*, FS_SMALL*/);
	ReleaseDC(pdc);
	m_timetextrect[chn].left = m_timeposrect[chn].left + poswidth - width.cx / 2;
	m_timetextrect[chn].right = m_timetextrect[chn].left + width.cx;
	m_timetextrect[chn].top = m_timeposrect[chn].top - 2;
	m_timetextrect[chn].bottom = m_timeposrect[chn].bottom;
	if (m_timetextrect[chn].left < m_rectgrid.left) {
		m_timetextrect[chn].left = m_rectgrid.left;
		m_timetextrect[chn].right = m_timetextrect[chn].left + width.cx;
	}
	if (m_timetextrect[chn].right > m_rectgrid.right) {
		m_timetextrect[chn].right = m_rectgrid.right;
		m_timetextrect[chn].left = m_timetextrect[chn].right - width.cx;
	}

	jxprint(m_timeposrect[chn], "TimeShaftDlg::SeekPos", "m_timeposrect");
	jxprint(m_timetextrect[chn], "TimeShaftDlg::SeekPos", "m_timetextrect");

	Draw();

	return TRUE;
}

// ͨλò Ϣ
VD_BOOL TimeShaftDlg::ClearPos()
{
	for (int i = 0; i < N_PLY_CH; i++)				// еִͨղ
	{
		memset(m_timetext[i], 0, TIMELENGTH);
	}

	return TRUE;
}

// ļϢҪʼʱֹͣʱ䣬Գֳɫ
//   numΪfileinfonumΪ0ʾ
VD_BOOL TimeShaftDlg::SetFileInfo(const SYSTEM_TIME *curDate, int num, const FILEINFO *pfileinfo)
{
	BGINFO info;
	const FILEINFO *pfiles = pfileinfo;
	const FILEINFOONE *pone = NULL;
	int temp;

	// ֮ǰļϢ
	ClearFileInfo();

	// ѭµļϢ
	for (int i = 0; i < num; i++, pfiles++)
	{
		if (pfiles == NULL)
			break;
		if (pfiles->chn < 0 || pfiles->chn >= N_PLY_CH)
			continue ;

		info.chn = pfiles->chn;
		pone = pfiles->files;
		for (int j = 0; j < pfiles->num; j++, pone++)
		{
			if (pone == NULL)
				break;

			info.type = pone->type;
			info.beg = pone->timebegin;
			info.end = pone->timeend;

			// begڱcurDateСʱΪ0:0:0
			// begڱcurDate
			temp = compareDate(&info.beg, curDate);
			if (temp < 0)
			{
				info.beg.hour = 0;
				info.beg.minute = 0;
				info.beg.second = 0;
			}
			else if (temp > 0)
			{
				continue ;
			}

			// endڱcurDateʱΪ24:0:0
			// endڱcurDateС
			temp = compareDate(&info.end, curDate);
			if (temp > 0)
			{
				info.end.hour = 24;
				info.end.minute = 0;
				info.end.second = 0;
			}
			else if (temp < 0)
			{
				continue ;
			}

			// Ƚʱ䣬begendbegend
			if ( !(compareTime(&info.beg, &info.end) < 0) )
				continue ;

			calBGInfo(&info);
			m_bginfo[info.chn].push_back(info);
		}
	}

	Draw();

	return TRUE;
}
void TimeShaftDlg::SetMaxRowNum(int ChnNum)
{
	m_rownum_show = ChnNum;
}
void TimeShaftDlg::Draw()
{
	int r, c, i, temp;
	
	
#if 1
	CDC* pdc = GetDC();
	if ( !pdc )
	{
		return;
	}

	CDC MemDC;
	MemDC.CreateCompatibleDC(pdc);

	CBitmap BitMap;
	BitMap.CreateCompatibleBitmap(pdc,m_rectall.Width(),m_rectall.Height());
	MemDC.SelectObject(&BitMap);

	CPen pen;
	pen.CreatePen(PS_SOLID, 1, RGB(0,0,0));
	MemDC.SelectObject(&pen);
	MemDC.SelectObject(&m_Font);

	MemDC.SetTextColor(RGB(255,255,255));

	MemDC.SetBkMode(TRANSPARENT);
	MemDC.FillRect(&m_rectall,&m_tBrushBG);


	CRect rect;
	rect = m_rectgrid;
	rect.bottom = rect.bottom - ((m_rownum_show - (int)m_roworder.size()) * m_rectgrid.Height() / m_rownum_show);
	MemDC.FillRect(&rect,&m_tBrushFG);

	// ¼ʱεľΣɫ
	for (i = 0; i < N_PLY_CH; i++)
	{
		// һµǰûʾͨţûʾ
		if (m_rowmap.end() == m_rowmap.find(i))
			continue ;
		for (std::size_t j = 0; j < m_bginfo[i].size(); j++)
		{
			const BGINFO &info = m_bginfo[i][j];
			if (!info.isshow)
				continue ;

			CBrush brush;
			if (info.type == TDKREC_TIMER || info.type == TDKREC_MANUAL)
			{
				if(!m_bNew)
				{
					brush.CreateSolidBrush(COLOR_NORMAL);
				}
				else
				{
					brush.CreateSolidBrush(color_Normal_New);
				}

			}
			else if (info.type == TDKREC_EVENT)
			{
				brush.CreateSolidBrush(COLOR_ALARM);
			}

			MemDC.FillRect(&info.rect,&brush);
		}
	}

	// 
	//VD_SIZE fontsize;
	//g_Locales.GetFontSize(&fontsize, FONTSIZE_SMALL);
	for (c = 0; c <= m_col; c++)
	{
		CString str;
		str = m_coltext[c].c_str();

		CSize temp = MemDC.GetTextExtent(str/*, FS_SMALL*/);
		int x = m_rectgrid.left + c * m_rectgrid.Width() / m_col;
		CRect rect;
		if (c == 0)
			rect = CRect(x, m_rectgrid.top - m_margin_top, x + temp.cx, m_rectgrid.top);
		else if (c == m_col)
			rect = CRect(x - temp.cx, m_rectgrid.top - m_margin_top, x, m_rectgrid.top);
		else
			rect = CRect(x - temp.cx/2, m_rectgrid.top - m_margin_top, x + temp.cx/2, m_rectgrid.top);

		MemDC.TextOut(rect.left,rect.top, str);
		MemDC.MoveTo(x, m_rectgrid.top);
		MemDC.LineTo(x, m_rectgrid.bottom - 
			(m_rownum_show - (int)m_roworder.size()) * m_rectgrid.Height() / m_rownum_show);
	}

	// 
	int cnt = (int)m_roworder.size();
	for (r = 0; r <= cnt; r++)
	{
		int y = m_rectgrid.top + r * m_rectgrid.Height() / m_rownum_show;
		int y2 = m_rectgrid.top + (r+1) * m_rectgrid.Height() / m_rownum_show;
		if (r != m_roworder.size())
		{
			CString cstr;
			cstr = m_rowtext[m_rowmap[m_roworder[r]]].text.c_str();
			CSize temp = MemDC.GetTextExtent(cstr/*, FS_SMALL*/);
			MemDC.TextOut(m_rectgrid.left - temp.cx, y, cstr);
		}

		MemDC.MoveTo(m_rectgrid.left, y);
		MemDC.LineTo(m_rectgrid.right, y);
	}

	temp = (m_rownum_show - (int)m_roworder.size()) * m_rectgrid.Height() / m_rownum_show;
	MemDC.MoveTo(m_rectgrid.left, m_rectgrid.top);
	MemDC.LineTo(m_rectgrid.left, m_rectgrid.bottom - temp);
	MemDC.MoveTo(m_rectgrid.right, m_rectgrid.top);
	MemDC.LineTo(m_rectgrid.right, m_rectgrid.bottom - temp);

	// ûһеĻĬϵУٱһ
	if (m_rownum_all == 0)
	{
		CRect rect = m_rectgrid;
		rect.bottom = rect.bottom - ((m_rownum_show - 1) * m_rectgrid.Height() / m_rownum_show);
		MemDC.FillRect(&rect,&m_tBrushFG);

		for (c = 0; c <= m_col; c++)
		{
			int x = m_rectgrid.left + c * m_rectgrid.Width() / m_col;
			MemDC.MoveTo(x, m_rectgrid.top);
			MemDC.LineTo(x, m_rectgrid.bottom - (m_rownum_show - 1) * m_rectgrid.Height() / m_rownum_show);
		}

		int y = m_rectgrid.top + 0 * m_rectgrid.Height() / m_rownum_show;
		MemDC.MoveTo(m_rectgrid.left, y);
		MemDC.LineTo(m_rectgrid.right, y);
		y = m_rectgrid.top + 1 * m_rectgrid.Height() / m_rownum_show;
		MemDC.MoveTo(m_rectgrid.left, y);
		MemDC.LineTo(m_rectgrid.right, y);

		temp = (m_rownum_show - 1) * m_rectgrid.Height() / m_rownum_show;
		MemDC.MoveTo(m_rectgrid.left, m_rectgrid.top);
		MemDC.LineTo(m_rectgrid.left, m_rectgrid.bottom - temp);
		MemDC.MoveTo(m_rectgrid.right, m_rectgrid.top);
		MemDC.LineTo(m_rectgrid.right, m_rectgrid.bottom - temp);
	}

	// ǰʱʱ
	//MemDC.SetFont(VD_RGB(0, 0, 180)/*, FS_SMALL*/);
	for (i = 0; i < N_PLY_CH; i++)
	{
		// һµǰûʾͨţûʾ
		if (m_rowmap.end() == m_rowmap.find(i))
			continue ;
		// m_timetextַΪգ˵ʾͨʱ䣬
		if ((int)strlen(m_timetext[i]) == 0)
			continue ;
		// һʱǲʾΧڣʾ
		if (!checkTimeValid(&m_curtime[i]))
			continue ;

		MemDC.Rectangle(&m_timeposrect[i]);
		CString cstr;
		cstr = m_timetext[i];
		MemDC.TextOut(m_timetextrect[i].left,m_timetextrect[i].top,cstr);
	}
	
	pdc->BitBlt(0,0,m_rectall.Width(),m_rectall.Height(),&MemDC,0,0,SRCCOPY);

	pen.DeleteObject();
	BitMap.DeleteObject();
	MemDC.DeleteDC();
	
	ReleaseDC(pdc);

#else
	CDC MemDC;
	int ret = MemDC.CreateCompatibleDC(GetDC());
	if (!ret)
	{
		TRACE("<jxlog> pMemDC is NULL, In TimeShaftDlg class ........\n");
		return ;
	}

	//MemDC.SetRgnStyle(RS_FLAT);
	MemDC.SetBkMode(TRANSPARENT);
	MemDC.SetDCBrushColor(RGB(0, 0, 50));
	MemDC.Rectangle(&m_rectall);

	//MemDC.SetFont(GetSysColor(COLOR_CTRLTEXT)/*, FS_SMALL*/);
	MemDC.SetDCBrushColor(RGB(160, 160, 160));
	CRect rect;
	rect = m_rectgrid;
	rect.bottom = rect.bottom - ((m_rownum_show - (int)m_roworder.size()) * m_rectgrid.Height() / m_rownum_show);
	MemDC.Rectangle(&rect);

// 	GetDC()->BitBlt(m_rectall.left,m_rectall.top,m_rectall.Width(),m_rectall.Height(), &MemDC,m_rectall.left,m_rectall.top,SRCCOPY);
// 	return;

	// ¼ʱεľΣɫ
	for (i = 0; i < N_PLY_CH; i++)
	{
		// һµǰûʾͨţûʾ
		if (m_rowmap.end() == m_rowmap.find(i))
			continue ;
		for (std::size_t j = 0; j < m_bginfo[i].size(); j++)
		{
			const BGINFO &info = m_bginfo[i][j];
			if (!info.isshow)
				continue ;
			if (info.type == ERT_RECORD)
				MemDC.SetDCBrushColor(RGB(0, 180, 0));		// (80, 255, 80)
			else if (info.type == ERT_ALM)
				MemDC.SetDCBrushColor(RGB(180, 0, 0));		// (255, 80, 80)
			else if (info.type == ERT_MTD)
				MemDC.SetDCBrushColor(RGB(180, 180, 0));		// (255, 255, 80)
			else if (info.type == ERT_MANUAL)
				MemDC.SetDCBrushColor(RGB(80, 80, 255));		// (80, 80, 255)
			else if (info.type == ERT_OTH)
				MemDC.SetDCBrushColor(RGB(150, 150, 150));	// (150, 150, 150)
			MemDC.Rectangle(&info.rect);
		}
	}

	// ɫ
	HPEN hPen = CreatePen(PS_SOLID, 1, RGB(100,100,100));
	MemDC.SelectObject(hPen);
	//VD_SIZE fontsize;
	//g_Locales.GetFontSize(&fontsize, FONTSIZE_SMALL);
	for (c = 0; c <= m_col; c++)
	{
		CSize temp = MemDC.GetTextExtent((LPCTSTR)m_coltext[c].c_str(), m_coltext[c].length()/*, FS_SMALL*/);
		int x = m_rectgrid.left + c * m_rectgrid.Width() / m_col;
		CRect rect;
		if (c == 0)
			rect = CRect(x, m_rectgrid.top - m_margin_top, x + temp.cx, m_rectgrid.top);
		else if (c == m_col)
			rect = CRect(x - temp.cx, m_rectgrid.top - m_margin_top, x, m_rectgrid.top);
		else
			rect = CRect(x - temp.cx/2, m_rectgrid.top - m_margin_top, x + temp.cx/2, m_rectgrid.top);
		CString str;
		str.Format(_T("%s"),m_coltext[c].c_str());
		MemDC.TextOut(rect.left,rect.top, str);
		MemDC.MoveTo(x, m_rectgrid.top);
		MemDC.LineTo(x, m_rectgrid.bottom - 
			(m_rownum_show - (int)m_roworder.size()) * m_rectgrid.Height() / m_rownum_show);
	}

	// ɫ
	hPen = CreatePen(PS_SOLID, 1, RGB(0,0,0));
	MemDC.SelectObject(hPen);
	for (r = 0; r <= m_roworder.size(); r++)
	{
		int y = m_rectgrid.top + r * m_rectgrid.Height() / m_rownum_show;
		int y2 = m_rectgrid.top + (r+1) * m_rectgrid.Height() / m_rownum_show;
		if (r != m_roworder.size())
		{
			const std::string &str = m_rowtext[m_rowmap[m_roworder[r]]].text;
			CSize temp = MemDC.GetTextExtent((LPCTSTR)str.c_str(), str.length()/*, FS_SMALL*/);
			CString cstr;
			cstr.Format(_T("%s"),str.c_str());
			MemDC.TextOut(m_rectgrid.left - temp.cx, y, cstr);
		}

		MemDC.MoveTo(m_rectgrid.left, y);
		MemDC.LineTo(m_rectgrid.right, y);
	}

	temp = (m_rownum_show - (int)m_roworder.size()) * m_rectgrid.Height() / m_rownum_show;
	MemDC.MoveTo(m_rectgrid.left, m_rectgrid.top);
	MemDC.LineTo(m_rectgrid.left, m_rectgrid.bottom - temp);
	MemDC.MoveTo(m_rectgrid.right, m_rectgrid.top);
	MemDC.LineTo(m_rectgrid.right, m_rectgrid.bottom - temp);

	// ûһеĻĬϵУٱһ
	if (m_rownum_all == 0)
	{
		MemDC.SetDCBrushColor(RGB(220, 220, 220));
		CRect rect = m_rectgrid;
		rect.bottom = rect.bottom - ((m_rownum_show - 1) * m_rectgrid.Height() / m_rownum_show);
		MemDC.Rectangle(&rect);

		hPen = CreatePen(PS_SOLID, 1, RGB(160,160,160));
		MemDC.SelectObject(hPen);
		for (c = 0; c <= m_col; c++)
		{
			int x = m_rectgrid.left + c * m_rectgrid.Width() / m_col;
			MemDC.MoveTo(x, m_rectgrid.top);
			MemDC.LineTo(x, m_rectgrid.bottom - (m_rownum_show - 1) * m_rectgrid.Height() / m_rownum_show);
		}

		hPen = CreatePen(PS_SOLID, 1, RGB(0,0,0));
		MemDC.SelectObject(hPen);
		int y = m_rectgrid.top + 0 * m_rectgrid.Height() / m_rownum_show;
		MemDC.MoveTo(m_rectgrid.left, y);
		MemDC.LineTo(m_rectgrid.right, y);
		y = m_rectgrid.top + 1 * m_rectgrid.Height() / m_rownum_show;
		MemDC.MoveTo(m_rectgrid.left, y);
		MemDC.LineTo(m_rectgrid.right, y);

		temp = (m_rownum_show - 1) * m_rectgrid.Height() / m_rownum_show;
		MemDC.MoveTo(m_rectgrid.left, m_rectgrid.top);
		MemDC.LineTo(m_rectgrid.left, m_rectgrid.bottom - temp);
		MemDC.MoveTo(m_rectgrid.right, m_rectgrid.top);
		MemDC.LineTo(m_rectgrid.right, m_rectgrid.bottom - temp);
	}

	// ǰʱʱ
	MemDC.SetDCBrushColor(RGB(255, 255, 255));
	//MemDC.SetFont(VD_RGB(0, 0, 180)/*, FS_SMALL*/);
	for (i = 0; i < N_PLY_CH; i++)
	{
		// һµǰûʾͨţûʾ
		if (m_rowmap.end() == m_rowmap.find(i))
			continue ;
		// m_timetextַΪգ˵ʾͨʱ䣬
		if ((int)strlen(m_timetext[i]) == 0)
			continue ;
		// һʱǲʾΧڣʾ
		if (!checkTimeValid(&m_curtime[i]))
			continue ;
		MemDC.Rectangle(&m_timeposrect[i]);
		CString cstr;
		cstr.Format(_T("%s"),m_timetext[i]);
		MemDC.TextOut(m_timetextrect[i].left,m_timetextrect[i].top,cstr);
	}

	// ʼͼ
	GetDC()->BitBlt(m_rectall.left,m_rectall.top,m_rectall.Width(),m_rectall.Height(), &MemDC,m_rectall.left,m_rectall.top,SRCCOPY);
	// ͼ


#endif
	return ;
}

#if 0
VD_BOOL TimeShaftDlg::MsgProc(uint msg, uint wpa, uint lpa)
{
	int px, py;
	int chn;
	SYSTEM_TIME sttime;

	switch (msg)
	{
	case XM_LBUTTONDOWN:
		px = VD_HIWORD(lpa);
		py = VD_LOWORD(lpa);
		//printf("<jxlog> TimeShaftDlg::MsgProc px=%d,py=%d\n", px, py);
		if ( (calChnTimeFromPoint(px-m_Rect.left, py-m_Rect.top, &chn, &sttime)) && 
			(checkPositionValid(chn, px-m_Rect.left, py-m_Rect.top, &sttime)) )
		{
			SeekPos(chn, &sttime);
			m_eventdrap = TRUE;
			m_eventchn = chn;
		}
		break;

	case XM_LBUTTONUP:
		m_eventdrap = FALSE;
		px = VD_HIWORD(lpa);
		py = VD_LOWORD(lpa);
		//printf("<jxlog> TimeShaftDlg::MsgProc px=%d,py=%d\n", px, py);
		if ( (calChnTimeFromPoint(px-m_Rect.left, py-m_Rect.top, &chn, &sttime)) && 
			(checkPositionValid(chn, px-m_Rect.left, py-m_Rect.top, &sttime)) )
		{
			chn = m_eventchn;
			SeekPos(chn, &sttime);
			// ûص¼ļλ
			(m_pParent->*m_proc)(chn,&sttime);
		}
		break;

	case XM_MOUSEMOVE:
		if (m_eventdrap)
		{
			px = VD_HIWORD(lpa);
			py = VD_LOWORD(lpa);
			//printf("<jxlog> TimeShaftDlg::MsgProc px=%d,py=%d\n", px, py);
			if ( (calChnTimeFromPoint(px-m_Rect.left, py-m_Rect.top, &chn, &sttime)) && 
				(checkPositionValid(chn, px-m_Rect.left, py-m_Rect.top, &sttime)) )
			{
				chn = m_eventchn;
				SeekPos(chn, &sttime);
			}
			else
			{
				m_eventdrap = FALSE;
			}
		}
		break;
#if 0
	case XM_MOUSEWHEEL:
		signed char delta = (char)VD_HIWORD(wpa);
		//printf("<jxlog> TimeShaftDlg::MsgProc XM_MOUSEWHEEL delta=%d\n", delta);
		SYSTEM_TIME sttime;
		if (delta < 0)
		{
			sttime = m_shafttimebeg;
			if (sttime.minute > 0)
			{
				sttime.minute -= 1;
			}
			else if (sttime.hour > 0)
			{
				sttime.hour -= 1;
				sttime.minute = 59;
			}
			setTimeRange(m_shafttype, &sttime, FALSE);
		}
		else if (delta > 0)
		{
			setTimeRange(m_shafttype, &m_shafttimeend, FALSE);
		}
		break;
#endif
	default:
		return FALSE;
	}

	return FALSE;	// return FALSE, 巽ʱ
}

#endif

void TimeShaftDlg::jxprint(CRect rect, char *funname, char* str)
{
	return ;
	printf("<jxlog> %s %s=%d,%d,%d,%d:%d-%d\n", 
		funname, str, rect.left, rect.top, rect.right, rect.bottom, rect.right - rect.left, rect.bottom - rect.top);
}

// ʱܴСľκбľ
void TimeShaftDlg::calRect()
{
#if 0
	// ݲͬʾͣԵֵֵͬ
	switch(m_vidouttype)
	{
	case ENUM_VIDOUT_1920x1080i60:

		break;
	case ENUM_VIDOUT_1280x1024_60:

		break;
	case ENUM_VIDOUT_1280x720p60:

		break;
	case ENUM_VIDOUT_1024x768p60:

		break;
	case ENUM_VIDOUT_800x600p60:

		break;
	default:
		break;
	}
#endif
	// ݱԵֵʱgridCRect
	GetClientRect(&m_rectall);
	m_rectgrid.left = m_margin_left;
	m_rectgrid.right = m_rectall.Width() - m_margin_right;
	m_rectgrid.top = m_margin_top;
	m_rectgrid.bottom = m_rectall.Height() - m_margin_bottom;

}

// ʱʱ䷶Χ
//   typeָ24hr, 2hr, 1hr, 30minеһμöٶ
//   sttimeΪʱֵлָʱķΧ
// ע:typeΪESR_24HRʱsttimeԺԣNULL
VD_BOOL TimeShaftDlg::setTimeRange(ENUM_SHATF_RANGE type, const SYSTEM_TIME *sttime, VD_BOOL force)
{
	//printf("<jxlog> TimeShaftDlg::SetTimeRange entry.\n");
	char sz[TIMELENGTH];
	SYSTEM_TIME stbeg;
	SYSTEM_TIME stend;

	if (sttime == NULL)
	{
		printf("<jxlog> [ERROR] TimeShaftDlg::setTimeRange sttime is NULL\n");
		return FALSE;
	}

	if (!calcTimeRange(type, sttime, &stbeg, &stend))
	{
		printf("<jxlog> [ERROR] TimeShaftDlg::setTimeRange calcTimeRange failed.\n");
		return FALSE;
	}

	// ûб䣬ֱӷأⲻҪļˢ
	if (!force && type == m_shafttype && 
		stbeg.hour == m_shafttimebeg.hour && 
		stbeg.minute == m_shafttimebeg.minute && 
		stend.hour == m_shafttimeend.hour && 
		stend.minute == m_shafttimeend.minute)
	{
		return TRUE;
	}

	m_shafttype = type;		// ͱ浽Ա
	m_shafttimebeg = stbeg;	// ʱʼʱ
	m_shafttimeend = stend;	// ʱĽʱ

	coltextClear();
	switch (type)
	{
	case ESR_24HR: 
		m_col = 24;
		for (int i = 0; i <= m_col; i++)
		{
			sprintf_s(sz, TIMELENGTH, "%d", i);
			coltextAdd(sz);
		}
		break;
	case ESR_2HR: 
		m_col = 12;
		for (int i = 0; i <= m_col; i++)
		{
			sprintf_s(sz, TIMELENGTH, "%02d:%02d", stbeg.hour, stbeg.minute);
			coltextAdd(sz);
			stbeg.minute += 10;
			if (stbeg.minute >= 60) {
				stbeg.hour += 1;
				stbeg.minute = 0;
			}
		}
		break;
	case ESR_1HR: 
		m_col = 12;
		for (int i = 0; i <= m_col; i++)
		{
			sprintf_s(sz, TIMELENGTH, "%02d:%02d", stbeg.hour, stbeg.minute);
			coltextAdd(sz);
			stbeg.minute += 5;
			if (stbeg.minute >= 60) {
				stbeg.hour += 1;
				stbeg.minute = 0;
			}
		}
		break;
	case ESR_30MIN: 
		m_col = 10;
		for (int i = 0; i <= m_col; i++)
		{
			sprintf_s(sz, TIMELENGTH, "%02d:%02d", stbeg.hour, stbeg.minute);
			coltextAdd(sz);
			stbeg.minute += 3;
			if (stbeg.minute >= 60) {
				stbeg.hour += 1;
				stbeg.minute = 0;
			}
		}
		break;
	default: 
		SetTimeRange(ESR_24HR, 0);	// ĬֵΪ24Сʱ
		break;
	}

	// ʱ䷶ΧʱҪ¼ʱϵĵɫ
	for (int i = 0; i < N_PLY_CH; i++)
	{
		for (std::size_t j = 0; j < m_bginfo[i].size(); j++)
		{
			calBGInfo(&m_bginfo[i][j]);
		}
	}

	Draw();

	return TRUE;
}

// ʱ䷶Χݴststbegstend
VD_BOOL TimeShaftDlg::calcTimeRange(ENUM_SHATF_RANGE type, const SYSTEM_TIME *st, 
								  SYSTEM_TIME *stbeg, SYSTEM_TIME *stend)
{
	VD_BOOL ret = TRUE;
	if (type != ESR_24HR && st == NULL)
		return FALSE;

	switch (type)
	{
	case ESR_24HR: 
		stbeg->hour = 0;
		stend->hour = 24;
		stbeg->minute = 0;
		stend->minute = 0;
		stbeg->second = 0;
		stend->second = 0;
		break;
	case ESR_2HR: 
		stbeg->hour = st->hour;
		stend->hour = st->hour + 2;
		if (stend->hour > 24) {
			stbeg->hour = 22;
			stend->hour = 24;
		}
		if (stbeg->hour < 0) {
			stbeg->hour = 0;
			stend->hour = 2;
		}
		stbeg->minute = 0;
		stend->minute = 0;
		stbeg->second = 0;
		stend->second = 0;
		break;
	case ESR_1HR: 
		stbeg->hour = st->hour;
		stend->hour = st->hour + 1;
		if (stend->hour > 24) {
			stbeg->hour = 23;
			stend->hour = 24;
		}
		if (stbeg->hour < 0) {
			stbeg->hour = 0;
			stend->hour = 1;
		}
		stbeg->minute = 0;
		stend->minute = 0;
		stbeg->second = 0;
		stend->second = 0;
		break;
	case ESR_30MIN: 
		if (st->minute < 30) {
			stbeg->hour = st->hour;
			stbeg->minute = 0;
			stend->hour = st->hour;
			stend->minute = 30;
		}
		else {
			stbeg->hour = st->hour;
			stbeg->minute = 30;
			stend->hour = st->hour + 1;
			stend->minute = 0;
		}
		if (stend->hour >= 24 && stend->minute > 0) {
			stbeg->hour = 23;
			stbeg->minute = 30;
			stend->hour = 24;
			stend->minute = 0;
		}
		if (stbeg->hour < 0) {
			stbeg->hour = 0;
			stbeg->minute = 0;
			stend->hour = 0;
			stend->minute = 30;
		}
		stbeg->second = 0;
		stend->second = 0;
		break;
	default: 
		ret = FALSE;
		break;
	}

	return ret;
}

// sttimeʱǧֱȵλ
// õĳԱ:
// 1. ʱm_shafttype
// 2. ǰʱĿʼʱm_shafttimebeg
VD_BOOL TimeShaftDlg::calPercentFromTime(const SYSTEM_TIME *sttime, int *percent)
{
	int sum = 0, cur = 0;
	SYSTEM_TIME st;
	*percent = 0;
	if (sttime == NULL)
		return FALSE;

	st = *sttime;

	if (compareTime(&st, &m_shafttimebeg) < 0)
	{
		st.hour = m_shafttimebeg.hour;
		st.minute = m_shafttimebeg.minute;
		st.second = m_shafttimebeg.second;
	}
	if (compareTime(&st, &m_shafttimeend) > 0)
	{
		st.hour = m_shafttimeend.hour;
		st.minute = m_shafttimeend.minute;
		st.second = m_shafttimeend.second;
	}

	// ʾλãCRect
	sum = 60 * 60 * 24;
	if (m_shafttype == ESR_2HR)
		sum = 60 * 60 * 2;
	else if (m_shafttype == ESR_1HR)
		sum = 60 * 60 * 1;
	else if (m_shafttype == ESR_30MIN)
		sum = 60 * 30;
	cur += (60 * 60 * (st.hour - m_shafttimebeg.hour));
	cur += (60 * (st.minute - m_shafttimebeg.minute));
	cur += st.second;
	*percent = (int)(cur * m_possum / sum);
	//printf("<jxlog> TimeShaftDlg::calPercentFromTime sum=%d, cur=%d, percent=%d\n", sum, cur, percent);

	return TRUE;
}

// ʱϵλãͨĶʱ
VD_BOOL TimeShaftDlg::calChnTimeFromPoint(int px, int py, int *chn, SYSTEM_TIME *sttime)
{
	int sum = 0;		// 
	int addsecond = 0;	// ǰĸ
	int temp;

	// sttimeΪNULLĲrectgrid棬ֱӷ
	POINT pt;
	pt.x = px;
	pt.y = py;
	if (sttime == NULL || (!PtInRect(&m_rectgrid, pt)))
		return FALSE;

	// ǰĸ
	sum = 60 * 60 * 24;
	if (m_shafttype == ESR_2HR)
		sum = 60 * 60 * 2;
	else if (m_shafttype == ESR_1HR)
		sum = 60 * 60 * 1;
	else if (m_shafttype == ESR_30MIN)
		sum = 60 * 30;
	addsecond = (px - m_rectgrid.left) * sum / m_rectgrid.Width();

	// SYSTEM_TIMEڿʼʱĻϼaddsecond
	// Сʱ
	temp = addsecond / (60 * 60);
	sttime->hour = m_shafttimebeg.hour + temp;
	addsecond -= (temp * 60 * 60);
	// 
	temp = addsecond / (60);
	sttime->minute = m_shafttimebeg.minute + temp;
	addsecond -= (temp * 60);
	// 
	sttime->second = m_shafttimebeg.second + addsecond;

	// ͨ
	*chn = (py - m_rectgrid.top) * m_rownum_show / m_rectgrid.Height();
	// m_roworder[*chn]кתΪʵͨ
	if (*chn >= (int)m_roworder.size())
		return FALSE;
	*chn = m_roworder[*chn];

	printf("<jxlog> TimeShaftDlg::calChnTimeFromPoint chn=%d, hour=%d, minute=%d, second=%d\n", 
		*chn, sttime->hour, sttime->minute, sttime->second);

	return TRUE;
}

// ɫεĴСinfoʱ䷶Χ
// ע:лͨʾ(1234, 5678)ʱҪ
VD_BOOL TimeShaftDlg::calBGInfo(BGINFO *pinfo)
{
	int percentbeg = 0;
	int percentend = 0;
	int topindex;			// εtopbottomȻҪ

	if (NULL == pinfo)
		return FALSE;
	if (m_rowmap.end() == m_rowmap.find(pinfo->chn))
		return FALSE;

	// m_rowmapȡͨŵvalueȡͨλ
	// Ҫټȥǰҳǰͨõǰҳλ
	// ôλütopbottomȷ
	// ע:m_rownum_page * m_rownum_showõǰҳͨ
	// :ǰǵڶҳһҳʾ4ͨҪȥ4(1*4)
	topindex = m_rowmap[pinfo->chn] - (m_rownum_page * m_rownum_show);

	// ʱʱϵǧֱλãõpercentڲῼʱ
	if (!calPercentFromTime(&pinfo->beg, &percentbeg) || 
		!calPercentFromTime(&pinfo->end, &percentend))
	{
		pinfo->isshow = FALSE;
		return FALSE;
	}
	// ڷΧڣҪʾ
	if ( (percentbeg <= 0 && percentend <= 0) || 
		(percentbeg >= m_possum && percentend >= m_possum) )
	{
		pinfo->isshow = FALSE;
		return FALSE;
	}

	pinfo->rect.left = m_rectgrid.left + percentbeg * m_rectgrid.Width() / m_possum;
	pinfo->rect.right = m_rectgrid.left + percentend * m_rectgrid.Width() / m_possum;
	pinfo->rect.top = m_rectgrid.top + (topindex+0) * m_rectgrid.Height() / m_rownum_show + 1;
	pinfo->rect.bottom = m_rectgrid.top + (topindex+1) * m_rectgrid.Height() / m_rownum_show;
	if (pinfo->rect.left < m_rectgrid.left)
		pinfo->rect.left = m_rectgrid.left;
	if (pinfo->rect.right > m_rectgrid.right)
		pinfo->rect.right = m_rectgrid.right;
	pinfo->isshow = TRUE;

	// εleftrightȣΪҪʾЧʹΪ1
	if (pinfo->isshow && pinfo->rect.left == pinfo->rect.right)
	{
		if (pinfo->rect.right < m_rectgrid.right)
			pinfo->rect.right += 1;
		else
			pinfo->rect.left -= 1;
	}

	return TRUE;
}

// ĵ㣬Ƿ¼ڣ򷵻TRUE,򷵻FALSE
// ȥʱǷ¼ʱ䷶Χڣ粻΢
VD_BOOL TimeShaftDlg::checkPositionValid(int chn, int x, int y, SYSTEM_TIME *st)
{
	VD_BOOL ret = FALSE;
	int begcmp = 0;
	int endcmp = 0;
	for (std::size_t i = 0; i < m_bginfo[chn].size(); i++)
	{
		const BGINFO &info = m_bginfo[chn][i];
		if (!info.isshow)
			continue ;

		POINT pt;
		pt.x = x;
		pt.y = y;
		st->year = info.end.year;
		st->month = info.end.month;
		st->day = info.end.day;
		if (PtInRect(&info.rect, pt))
		{
			begcmp = compareTime(st, &info.beg);
			endcmp = compareTime(st, &info.end);
			// ʱ΢ʱ䲢ڿʼʱ䷶Χʱ֮
			if (begcmp < 0)
				*st = info.beg;
			if (endcmp > 0)
				*st = info.end;

			ret = TRUE;
			break;
		}
	}
	return ret;
}

VD_BOOL TimeShaftDlg::checkTimeValid(const SYSTEM_TIME *sttime)
{
	if (sttime == NULL)
		return FALSE;

	// ʱ䲻ڵǰʾڣ򷵻FALSE
	if ( (compareTime(sttime, &m_shafttimebeg) < 0) || 
		(compareTime(sttime, &m_shafttimeend) > 0) )
		return FALSE;

	return TRUE;
}

// Ƚڣst1st2ȷ0st1Сst2ֵС0򷵻ֵ0
int TimeShaftDlg::compareDate(const SYSTEM_TIME *st1, const SYSTEM_TIME *st2)
{
	if (st1->year == st2->year && st1->month == st2->month && st1->day == st2->day)
		return 0;

	if ( (st1->year < st2->year) || 
		(st1->year <= st2->year && 
		st1->month < st2->month) || 
		(st1->year <= st2->year && 
		st1->month <= st2->month && 
		st1->day < st2->day))
		return -1;

	else
		return 1;
}

// Ƚʱ䣬st1st2ȷ0st1Сst2ֵС0򷵻ֵ0
int TimeShaftDlg::compareTime(const SYSTEM_TIME *st1, const SYSTEM_TIME *st2)
{
	if (st1->hour == st2->hour && st1->minute == st2->minute && st1->second == st2->second)
		return 0;

	if ( (st1->hour < st2->hour) || 
		(st1->hour <= st2->hour && 
		st1->minute < st2->minute) || 
		(st1->hour <= st2->hour && 
		st1->minute <= st2->minute && 
		st1->second < st2->second))
		return -1;

	else
		return 1;
}

// ͨļϢ
VD_BOOL TimeShaftDlg::ClearFileInfo()
{
	for (int i = 0; i < N_PLY_CH; i++)				// еִͨղ
	{
		m_bginfo[i].clear();
	}

	return TRUE;
}

void TimeShaftDlg::rowtextClear()
{
	for (std::size_t i = 0; i < m_rowtext.size(); i++)
	{
		m_rowtext[i].text = "";
	}
	m_rowtext.clear();
	m_rowmap.clear();
	m_roworder.clear();
}

void TimeShaftDlg::rowtextAdd(const CHNINFO &_info)
{
	CHNINFO info = _info;

	if (info.text.empty())
	{
		char sz[TIMELENGTH] = {0};
		sprintf_s(sz, TIMELENGTH, "%d", info.chnnum + 1);
		info.text = sz;
	}

	m_rowtext.push_back(info);
	if ((int)m_rowmap.size() < m_rownum_show)
		m_rowmap[info.chnnum] = (int)m_rowtext.size() - 1;		// ӳϵ
	if ((int)m_roworder.size() < m_rownum_show)
		m_roworder.push_back(info.chnnum);
}

void TimeShaftDlg::coltextClear()
{
	m_coltext.clear();
}

void TimeShaftDlg::coltextAdd(const char *str)
{
	m_coltext.push_back(str);
}
BOOL TimeShaftDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

//BUG#8283 zhaoyongsheng 2015-8-31
	// TODO:  ڴӶĳʼ
	std::vector<CHNINFO> vecrow;
	CHNINFO info;
	info.text = "";
	for (int i = 0; i < m_ChnNum; i++)
	{
		info.chnnum = i;
		vecrow.push_back(info);
	}


	m_rownum_all = (int)vecrow.size();		// е
	m_rownum_page = 0;					// Ĭǵ0ҳҲǰm_rownum_showʾ

	// vecrowݷ뵽m_rowtext
	rowtextClear();
	for (std::size_t i = 0; i < vecrow.size(); i++)
	{
		rowtextAdd(vecrow[i]);
	}

	Init();

// 	CGlobalpublicData *pAppData = CGlobalpublicData::Instance();		
// 	string strClassName = typeid(this).name(); 
// 	font = pAppData->InitFont(this, strClassName);

	return TRUE;  // return TRUE unless you set the focus to a control
	// 쳣: OCX ҳӦ FALSE
}

void TimeShaftDlg::OnSize(UINT nType, int cx, int cy)
{
	CDialog::OnSize(nType, cx, cy);

#if 1
	// TODO: ڴ˴Ϣ
	// εĴСDrawлõЩCRect
	// ע:calRectдm_margin_top, m_margin_bottomע:
	//     (m_Rect.Height() - (m_margin_top + m_margin_bottom)) / m_rownum_showӦǿ
	//     Ȼеĺʱͼβ
	calRect();
	// m_possumҪĿȣȻʱϵɫʱʱƫ
	// m_rectgridcalRectмģԴ˸ֵҪcalRect֮
	m_possum = m_rectgrid.Width();
#endif

	// СʱҪ¼ʱϵĵɫ
	for (int i = 0; i < m_ChnNum; i++)
	{
		for (std::size_t j = 0; j < m_bginfo[i].size(); j++)
		{
			calBGInfo(&m_bginfo[i][j]);
		}
	}
	Draw();
}



void TimeShaftDlg::OnPaint()
{
	CPaintDC dc(this); // device context for painting
	// TODO: ڴ˴Ϣ
	// ΪͼϢ CDialog::OnPaint()
	Draw();
}

void TimeShaftDlg::OnLButtonDown(UINT nFlags, CPoint point)
{
	// TODO: ڴϢ/Ĭֵ
	int chn = 0;
	SYSTEM_TIME sttime;
	if ( (calChnTimeFromPoint(point.x, point.y, &chn, &sttime)) && 
		(checkPositionValid(chn, point.x, point.y, &sttime)) )
	{
		SeekPos(chn, &sttime);
		m_eventchn = chn;

		SetCapture();
	}

	CDialog::OnLButtonDown(nFlags, point);
}

void TimeShaftDlg::OnMouseMove(UINT nFlags, CPoint point)
{
	// TODO: ڴϢ/Ĭֵ

	if ( GetCapture() )
	{
		int chn = 0;
		SYSTEM_TIME sttime;
		if ( (calChnTimeFromPoint(point.x, point.y, &chn, &sttime)) 
			&&(checkPositionValid(chn, point.x, point.y, &sttime)) )
		{
			SeekPos(m_eventchn, &sttime);
		}
	}

	CDialog::OnMouseMove(nFlags, point);
}

void TimeShaftDlg::OnLButtonUp(UINT nFlags, CPoint point)
{
	// TODO: ڴϢ/Ĭֵ
	int chn = 0;
	SYSTEM_TIME sttime ;
	memset(&sttime, 0, sizeof(SYSTEM_TIME));
	if ( (calChnTimeFromPoint(point.x, point.y, &chn, &sttime)) && 
		(checkPositionValid(chn, point.x, point.y, &sttime)) )
	{
		SeekPos(m_eventchn, &sttime);
		if ( m_proc )
		{
			m_proc(m_eventchn,&sttime, (unsigned long long)m_pParentWnd);
			
		}
	}
	else
	{
		SeekPos(m_eventchn,NULL);
	}

	if ( GetCapture() )
	{
		ReleaseCapture();
	}

	CDialog::OnLButtonUp(nFlags, point);
}



BOOL TimeShaftDlg::DestroyWindow()
{
	// TODO: ڴרô/û
	font->DeleteObject();
	return CDialog::DestroyWindow();
}

void TimeShaftDlg::SetNew(bool bNew)
{
	m_bNew = bNew;
}

void TimeShaftDlg::GetBeginTimeAndEndTime(SYSTEM_TIME& beginTime, SYSTEM_TIME& endTime)
{
	beginTime = m_shafttimebeg;
	endTime = m_shafttimeend;
}

SYSTEM_TIME TimeShaftDlg::GetCurTime(int chn)
{
	return m_curtime[chn];
}

void TimeShaftDlg::GetChnTime(int chn,SYSTEM_TIME &time)
{
	memcpy(&time,&m_curtime[chn],sizeof(SYSTEM_TIME));
	return;
}

void TimeShaftDlg::ClearCurTime(int nChn)
{
	if( nChn >= N_PLY_CH  )
		return;

	if( nChn <= -1 )
	{
		memset(&m_curtime,0,sizeof(m_curtime));
	}
	else
	{
		memset(&m_curtime[nChn], 0, sizeof(m_curtime[nChn]));
	}

}