// SystemInfo.cpp : ʵļ
//

#include "stdafx.h"
#include "SDKDemo.h"
#include "SystemInfo.h"
#include "afxdialogex.h"
#include "RemoteConfig.h"

// CSystemInfo Ի

IMPLEMENT_DYNAMIC(CSystemInfo, CDialogEx)

CSystemInfo::CSystemInfo(CWnd* pParent /*=NULL*/)
	: CDialogEx(CSystemInfo::IDD, pParent)
{
	m_brunning = false;
	m_crthread = NULL;
}

CSystemInfo::~CSystemInfo()
{
}

void CSystemInfo::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST1, m_infolist);
}


BEGIN_MESSAGE_MAP(CSystemInfo, CDialogEx)
	ON_BN_CLICKED(IDC_BUTTON_REFRESH, &CSystemInfo::OnBnClickedButtonRefresh)
	ON_MESSAGE(WM_USER, &CSystemInfo::OnRecvMsg)
	ON_WM_SIZE()
END_MESSAGE_MAP()


// CSystemInfo Ϣ


BOOL CSystemInfo::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// TODO:  ڴӶĳʼ
	m_infolist.InsertColumn(1, _T("Item"), LVCFMT_LEFT, 120);
	m_infolist.InsertColumn(2, _T("Information"), LVCFMT_LEFT, 400);
	m_infolist.SetExtendedStyle(m_infolist.GetExtendedStyle() | LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES | LVS_EX_SUBITEMIMAGES);

	//OnBnClickedButtonRefresh();
	return TRUE;  // return TRUE unless you set the focus to a control
	// 쳣:  OCX ҳӦ FALSE
}


BOOL CSystemInfo::DestroyWindow()
{
	// TODO:  ڴרô/û

	return CDialogEx::DestroyWindow();
}

int CALLBACK CSystemInfo::callback(void* context, TDKU32 cmd, void* param0, void* param1, void* param2)
{
	CSystemInfo* self = (CSystemInfo*)context;
	if (!self)
	{
		return 0;
	}
	if (cmd == TDKDEVICE_MSG_STATE)
	{
		TDKU32 state = (TDKU32)(size_t)param1;
		TDKS32 error = (TDKS32)(size_t)param2;
		TRACE("Live Stream State = %d, error = %d\n", state, error);
		if (state == TDKSTATE_STREAM_DISCONNECT)
		{
			::PostMessage(self->GetSafeHwnd(), WM_USER, (WPARAM)2, (LPARAM)self);
		}
	}
	
	return 0;
}

UINT CSystemInfo::DoRefreshThread(LPVOID param)
{
	auto self = static_cast<CSystemInfo*>(param);
	TDKHANDLE hdevice = TDKDevice_Create();
	if (hdevice == NULL)
	{
		::PostMessage(self->GetSafeHwnd(), WM_USER, (WPARAM)1, (LPARAM)self);
		return 0;
	}
	std::string strurl;
	CStringW2string(self->GetUrl(), strurl, CP_ACP);
	int ret = TDKDevice_OpenEx(hdevice, strurl.c_str(), self->GetUsername().c_str(), self->GetPassword().c_str());
	if (ret != TDK_OK)
	{
		TDKDevice_Delete(hdevice);
		::PostMessage(self->GetSafeHwnd(), WM_USER, (WPARAM)1, (LPARAM)self);
		return 0;
	}
	TDKHANDLE hcallback = TDKCBCreate(self, callback);
	TDKDevice_Attach(hdevice, hcallback);
	TDK_DEVICE_INFO* devinfo = new TDK_DEVICE_INFO;
	ret = TDKDevice_GetDeviceInfo(hdevice, devinfo);
	if (ret != TDK_OK)
	{
		TDKDevice_Detach(hdevice, hcallback);
		//TDKCBDelete(hcallback);
		TDKDevice_Close(hdevice);
		TDKDevice_Delete(hdevice);
		::PostMessage(self->GetSafeHwnd(), WM_USER, (WPARAM)1, (LPARAM)self);
		return 0;
	}
	TDKDevice_Detach(hdevice, hcallback);
	//TDKCBDelete(hcallback);
	TDKDevice_Close(hdevice);
	TDKDevice_Delete(hdevice);
	::PostMessage(self->GetSafeHwnd(), WM_USER, (WPARAM)3, (LPARAM)devinfo);
	return 0;
}

void CSystemInfo::OnBnClickedButtonRefresh()
{
	m_infolist.DeleteAllItems();
	// TODO:  ڴӿؼ֪ͨ
	m_url = ((CRemoteConfig*)(GetParent()->GetParent()->GetParent()))->GetLoginInfo(m_username, m_password);
	if (m_brunning)
		return;
	m_brunning = true;
	auto btn = (CButton*)GetDlgItem(IDC_BUTTON_REFRESH);
	btn->SetWindowTextW(L"Refreshing...");
	m_crthread = AfxBeginThread((AFX_THREADPROC)DoRefreshThread, (LPVOID)this);
}


void CSystemInfo::OnSize(UINT nType, int cx, int cy)
{
	CDialogEx::OnSize(nType, cx, cy);

	// TODO:  ڴ˴Ϣ
// 	if (m_infolist.GetSafeHwnd())
// 	{
// 		m_infolist.MoveWindow(0, 0, cx, cy);
// 	}
}

LRESULT CSystemInfo::OnRecvMsg(WPARAM wParam, LPARAM lParam)
{
	m_brunning = false;
	auto btn = (CButton*)GetDlgItem(IDC_BUTTON_REFRESH);
	btn->SetWindowTextW(L"Refresh");

	switch (wParam)
	{
	case 1:
	{
		MessageBox(_T("Operation failed!!!"));
		break;
	}
	case 2:
	{
		MessageBox(_T("Device is disconnected!!!"));
		break;
	}
	case 3:
	{
		TDK_DEVICE_INFO* devInfo = (TDK_DEVICE_INFO*)lParam;
		if (devInfo == NULL)
			return 0;
		SetListCtrl(*devInfo);
		delete devInfo;
		break;
	}
	}
	return 0;
}

void CSystemInfo::SetListCtrl(TDK_DEVICE_INFO devinfo)
{
	CString strTmp;
	long lItem;
	lItem = m_infolist.InsertItem(m_infolist.GetItemCount(), _T("Device type"), -1);
	if (devinfo.devtype == TDKDEVICE_TYPE_IPC)
		strTmp = "IPC";
	if (devinfo.devtype == TDKDEVICE_TYPE_DVR)
		strTmp = "DVR";
	m_infolist.SetItemText(lItem, 1, strTmp);

	lItem = m_infolist.InsertItem(m_infolist.GetItemCount(), _T("Channel number"), -1);
	strTmp.Format(_TEXT("%d"), devinfo.analogchnnum + devinfo.digitalchnnum);
	m_infolist.SetItemText(lItem, 1, strTmp);

	lItem = m_infolist.InsertItem(m_infolist.GetItemCount(), _T("Alarm port I/O"), -1);
	strTmp.Format(_TEXT("%d/%d"), devinfo.alarmin, devinfo.alarmout);
	m_infolist.SetItemText(lItem, 1, strTmp);

	lItem = m_infolist.InsertItem(m_infolist.GetItemCount(), _T("Audio port I/O"), -1);
	strTmp.Format(_TEXT("%d/%d"), devinfo.audioin, devinfo.audioout);
	m_infolist.SetItemText(lItem, 1, strTmp);

	lItem = m_infolist.InsertItem(m_infolist.GetItemCount(), _T("Model"), -1);
	strTmp = devinfo.devmodel;
	m_infolist.SetItemText(lItem, 1, strTmp);

	lItem = m_infolist.InsertItem(m_infolist.GetItemCount(), _T("Vervison"), -1);
	strTmp = devinfo.devversion;
	m_infolist.SetItemText(lItem, 1, strTmp);
}
