// RemoteConfig.cpp : ʵļ
//

#include "stdafx.h"
#include "SDKDemo.h"
#include "RemoteConfig.h"
#include "afxdialogex.h"
#include <regex>

// CRemoteConfig Ի

IMPLEMENT_DYNAMIC(CRemoteConfig, CDialogEx)

CRemoteConfig::CRemoteConfig(CWnd* pParent /*=NULL*/)
	: CDialogEx(CRemoteConfig::IDD, pParent)
{
	m_arraydlg.clear();
	m_dlgmaintain = NULL;
	m_basicdlg = NULL;
}

CRemoteConfig::~CRemoteConfig()
{
}

void CRemoteConfig::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT_CLOUDID, m_editcloudid);
	DDX_Control(pDX, IDC_COMBO_PROTOCOL, m_cbProtocol);
	DDX_Control(pDX, IDC_EDIT_PORT_HTTP, m_hpPort);
	DDX_Control(pDX, IDC_EDIT_SERVER_CLOUD3, m_editCloudServer);
	DDX_Control(pDX, IDC_EDIT_PORT_CLOUD3, m_editCloudPort);
	DDX_Control(pDX, IDC_EDIT_USERNAME_CLOUD, m_editCloudUser);
	DDX_Control(pDX, IDC_EDIT_PWD_CLOUD, m_editCloudPwd);
	DDX_Control(pDX, IDC_EDIT_IP, m_editDevAddr);
	DDX_Control(pDX, IDC_EDIT_PORT, m_editDevPort);
	DDX_Control(pDX, IDC_EDIT_USERNAME, m_editDevUser);
	DDX_Control(pDX, IDC_EDIT_PWD, m_editDevPwd);
}

BOOL CRemoteConfig::OnCommand(WPARAM wParam, LPARAM lParam)
{
	UINT code = HIWORD(wParam);
	HWND hwnd = (HWND)(lParam);
	UINT unid = LOWORD(wParam);
	if (code == EN_KILLFOCUS && IsWindowVisible())
	{
		auto addrRgx = "(?:[1-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(?:\\.(?:[1-9]?[0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}";
		auto portRgx = "(?:[0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4]{4}|65[0-4]{2}|655[0-2]|6553[0-5])";
		if (IsEditTextValid(IDC_EDIT_IP, unid, addrRgx))
		{
			MessageBox(_T("DevAddr text is illegal!"));
			GetDlgItem(IDC_EDIT_IP)->SetFocus();
		}
		else if (IsEditTextValid(IDC_EDIT_PORT, unid, portRgx))
		{
			MessageBox(_T("Port text is illegal!"));
			GetDlgItem(IDC_EDIT_PORT)->SetFocus();
		}
		else if (IsEditTextValid(IDC_EDIT_PORT_HTTP, unid, portRgx))
		{
			MessageBox(_T("Http Port text is illegal!"));
			GetDlgItem(IDC_EDIT_PORT_HTTP)->SetFocus();
		}
		else if (IsEditTextValid(IDC_EDIT_PORT_CLOUD2, unid, portRgx))
		{
			MessageBox(_T("Port text is illegal!"));
			GetDlgItem(IDC_EDIT_PORT_CLOUD2)->SetFocus();
		}
	}
	return CDialogEx::OnCommand(wParam, lParam);
}


BEGIN_MESSAGE_MAP(CRemoteConfig, CDialogEx)
	ON_CBN_SELCHANGE(IDC_COMBO_PROTOCOL, &CRemoteConfig::OnCbnSelchangeComboProtocol)
	ON_BN_CLICKED(IDC_BUTTON_MAINT, &CRemoteConfig::OnBnClickedButtonMaint)
	ON_BN_CLICKED(IDC_BUTTON_SET_BASIC, &CRemoteConfig::OnBnClickedButtonSetBasic)
	ON_BN_CLICKED(IDC_BUTTON_SET_STORAGE2, &CRemoteConfig::OnBnClickedButtonSetStorage2)
END_MESSAGE_MAP()


// CRemoteConfig Ϣ

BOOL CRemoteConfig::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// TODO:  ڴӶĳʼ
	GetDlgItem(IDC_STATIC_DLG_BG)->GetWindowRect(&m_rectdlgbg);
	ScreenToClient(&m_rectdlgbg);

	LoadLoginInfo();

	m_cbProtocol.AddString(L"tdk");
	m_cbProtocol.AddString(L"umsp");
	m_cbProtocol.AddString(L"tdks");
	m_cbProtocol.SetCurSel(0);
	OnCbnSelchangeComboProtocol();

	OnBnClickedButtonSetBasic();

	return TRUE;  // return TRUE unless you set the focus to a control
	// 쳣:  OCX ҳӦ FALSE
}


int CRemoteConfig::LoadLoginInfo()
{
	char		path[1024];
	path[0] = '\0';
	HMODULE hModule = GetModuleHandleA("TDKSDK.dll");
	GetModuleFileNameA(hModule, path, 1024);
	size_t	len = strlen(path) - strlen("TDKSDK.dll");
	path[len] = '\0';
	m_pathIniFIle = path;
	m_pathIniFIle += "ServerInfo.ini";

	CString cstrport;
	GetPrivateProfileString(L"umspcloudserver", L"addr", L"", m_cstrcloudserveraddr.GetBuffer(MAX_PATH), MAX_PATH, m_pathIniFIle);
	m_cloudserverport = GetPrivateProfileInt(L"umspcloudserver", L"port", 0, m_pathIniFIle);
	GetPrivateProfileString(L"umspcloudserver", L"user", L"", m_cstrcloudserveruser.GetBuffer(MAX_USERNAME_LEN), MAX_USERNAME_LEN, m_pathIniFIle);
	GetPrivateProfileString(L"umspcloudserver", L"pwd", L"", m_cstrcloudserverpwd.GetBuffer(MAX_PASSWORD_LEN), MAX_PASSWORD_LEN, m_pathIniFIle);
	GetPrivateProfileString(L"umspcloudserver", L"cloudid", L"", m_cstrcloudid.GetBuffer(MAX_PASSWORD_LEN), MAX_PASSWORD_LEN, m_pathIniFIle);
	m_editCloudServer.SetWindowText(m_cstrcloudserveraddr);
	cstrport.Format(L"%d", m_cloudserverport);
	m_editCloudPort.SetWindowText(cstrport);
	m_editCloudUser.SetWindowText(m_cstrcloudserveruser);
	m_editCloudPwd.SetWindowText(m_cstrcloudserverpwd);
	m_editcloudid.SetWindowText(m_cstrcloudid);

	GetPrivateProfileString(L"device", L"addr", L"", m_cstrdevaddr.GetBuffer(MAX_PATH), MAX_PATH, m_pathIniFIle);
	m_devport = GetPrivateProfileInt(L"device", L"port", 0, m_pathIniFIle);
	GetPrivateProfileString(L"device", L"user", L"", m_cstrdevuser.GetBuffer(MAX_USERNAME_LEN), MAX_USERNAME_LEN, m_pathIniFIle);
	GetPrivateProfileString(L"device", L"pwd", L"", m_cstrdevpwd.GetBuffer(MAX_PASSWORD_LEN), MAX_PASSWORD_LEN, m_pathIniFIle);
	m_editDevAddr.SetWindowText(m_cstrdevaddr);
	cstrport.Format(L"%d", m_devport);
	m_editDevPort.SetWindowText(cstrport);
	m_editDevUser.SetWindowText(m_cstrdevuser);
	m_editDevPwd.SetWindowText(m_cstrdevpwd);

	unsigned int httpPort = GetPrivateProfileInt(L"device", L"httpport", 0, m_pathIniFIle);
	cstrport.Format(L"%d", httpPort);
	m_hpPort.SetWindowText(cstrport);
	return 0;
}

bool CRemoteConfig::IsEditTextValid(int nID, int uID, const char* rgxStr)
{
	if (nID != uID)
		return false;
	CString text;
	GetDlgItemTextW(nID, text);
	std::regex regex(rgxStr);
	std::wstring wstr(text.GetBuffer());
	std::string str(wstr.begin(), wstr.end());
	if (!std::regex_match(str, regex))
		return true;
	return false;
}

CString CRemoteConfig::GetLoginInfo(string& username, string& password)
{
	m_url.Empty();
	std::string str;
	CString cstr;

	CString protocol;
	int index = m_cbProtocol.GetCurSel();
	m_cbProtocol.GetLBText(index, protocol);
	m_url += protocol;

	m_url += _T("://");
	if (protocol == L"tdks" || protocol == L"umsp")
	{
		//	p2p
		//	tdks://[clouduser:cloudpass@]cloud_domain:cloud_port/authen=devusr&devpass/cloudid=umksxxxxxxxx/hp=httpPort";
		m_editCloudUser.GetWindowTextW(cstr);
		m_url += cstr;
		CStringW2string(cstr, username, CP_ACP);
		m_editCloudPwd.GetWindowTextW(cstr);
		if (cstr.IsEmpty() == false)
		{
			m_url += _T(":");
			m_url += cstr;
			CStringW2string(cstr, password, CP_ACP);
		}
		m_url += _T("@");
		m_editCloudServer.GetWindowTextW(cstr);
		m_url += cstr;
		m_url += _T(":");
		m_editCloudPort.GetWindowTextW(cstr);
		m_url += cstr;

		m_url += _T("/authen=");
		m_editDevUser.GetWindowTextW(cstr);
		m_url += cstr;
		m_editDevPwd.GetWindowTextW(cstr);
		if (cstr.IsEmpty() == false)
		{
			m_url += _T("&");
			m_url += cstr;
		}

		m_editcloudid.GetWindowTextW(cstr);
		m_url += _T("/cloudid=");
		m_url += cstr;
	}
	else
	{
		m_editDevUser.GetWindowTextW(cstr);
		CStringW2string(cstr, username, CP_ACP);
		m_editDevPwd.GetWindowTextW(cstr);
		CStringW2string(cstr, password, CP_ACP);

		m_editDevAddr.GetWindowTextW(cstr);
		CStringW2string(cstr, m_ip, CP_ACP);
		m_url += cstr;
		m_url += _T(":");
		m_editDevPort.GetWindowTextW(cstr);
		m_port = _ttoi(cstr.GetBuffer());
		m_url += cstr;
	}
	m_url += L"/hp=";
	m_hpPort.GetWindowTextW(cstr);
	m_url += cstr;

	return m_url;
}

void CRemoteConfig::OnCbnSelchangeComboProtocol()
{
	// TODO:  ڴӿؼ֪ͨ
	CString protocol;
	m_cbProtocol.GetLBText(m_cbProtocol.GetCurSel(), protocol);
	if (protocol == L"tdk")
	{
		m_editDevAddr.EnableWindow(TRUE);
		m_editDevPort.EnableWindow(TRUE);
		m_editDevUser.EnableWindow(TRUE);
		m_editDevPwd.EnableWindow(TRUE);

		m_editCloudServer.EnableWindow(FALSE);
		m_editCloudPort.EnableWindow(FALSE);
		m_editcloudid.EnableWindow(FALSE);
		m_editCloudUser.EnableWindow(FALSE);
		m_editCloudPwd.EnableWindow(FALSE);

		m_hpPort.EnableWindow(TRUE);
	}
	else if (protocol == L"umsp" || protocol == L"tdks")//cloud
	{
		m_editDevAddr.EnableWindow(FALSE);
		m_editDevPort.EnableWindow(FALSE);

		m_editCloudServer.EnableWindow(TRUE);
		m_editCloudPort.EnableWindow(TRUE);
		m_editcloudid.EnableWindow(TRUE);
		m_editCloudUser.EnableWindow(TRUE);
		m_editCloudPwd.EnableWindow(TRUE);

		m_hpPort.EnableWindow(FALSE);
		CString cloudServer = L"";
		if (protocol == L"umsp")
		{
			cloudServer = "umspcloudserver";
		}
		else
		{
			cloudServer = "tdkscloudserver";
		}
		GetPrivateProfileString(cloudServer, L"addr", L"", m_cstrcloudserveraddr.GetBuffer(MAX_PATH), MAX_PATH, m_pathIniFIle);
		GetPrivateProfileString(cloudServer, L"user", L"", m_cstrcloudserveruser.GetBuffer(MAX_USERNAME_LEN), MAX_USERNAME_LEN, m_pathIniFIle);
		GetPrivateProfileString(cloudServer, L"pwd", L"", m_cstrcloudserverpwd.GetBuffer(MAX_PASSWORD_LEN), MAX_PASSWORD_LEN, m_pathIniFIle);
		GetPrivateProfileString(cloudServer, L"cloudid", L"", m_cstrcloudid.GetBuffer(MAX_PASSWORD_LEN), MAX_PASSWORD_LEN, m_pathIniFIle);
		unsigned int port = GetPrivateProfileInt(cloudServer, L"port", 0, m_pathIniFIle);
		CString strPort;
		strPort.Format(L"%d", port);
		m_editCloudPort.SetWindowText(strPort);
		m_editCloudServer.SetWindowText(m_cstrcloudserveraddr);
		m_editCloudUser.SetWindowText(m_cstrcloudserveruser);
		m_editCloudPwd.SetWindowText(m_cstrcloudserverpwd);
		m_editcloudid.SetWindowText(m_cstrcloudid);
	}
}


void CRemoteConfig::OnBnClickedButtonMaint()
{
	// TODO:  ڴӿؼ֪ͨ
	if (!m_dlgmaintain)
	{
		m_dlgmaintain = new CMaintain(this);
		m_dlgmaintain->Create(IDD_DIALOG_MAINT, this);
		m_dlgmaintain->MoveWindow(&m_rectdlgbg);
		m_arraydlg.push_back(m_dlgmaintain);
	}
	ShowDlg(false);
	m_dlgmaintain->ShowWindow(TRUE);
}


BOOL CRemoteConfig::DestroyWindow()
{
	// TODO:  ڴרô/û
	for (unsigned int i = 0; i < m_arraydlg.size(); i++)
	{
		if (m_arraydlg[i])
		{
			m_arraydlg[i]->DestroyWindow();
			delete (m_arraydlg[i]);
			m_arraydlg[i] = NULL;
		}
	}
	return CDialogEx::DestroyWindow();
}

int CRemoteConfig::ShowDlg(bool bshow)
{
	for (unsigned int i = 0; i < m_arraydlg.size(); i++)
	{
		if (m_arraydlg[i])
		{
			m_arraydlg[i]->ShowWindow(bshow);
		}
	}
	return 0;
}

void CRemoteConfig::OnBnClickedButtonSetBasic()
{
	// TODO:  ڴӿؼ֪ͨ
	if (!m_basicdlg)
	{
		m_basicdlg = new CBasicSetting(this);
		m_basicdlg->Create(IDD_DIALOG_BASIC_SET, this);
		m_basicdlg->MoveWindow(&m_rectdlgbg);
		m_arraydlg.push_back(m_basicdlg);
	}
	ShowDlg(false);
	m_basicdlg->ShowWindow(TRUE);
}


void CRemoteConfig::OnBnClickedButtonSetStorage2()
{
	// TODO:  ڴӿؼ֪ͨ
	TDKHANDLE handel = TDKDevice_Create();
	TDKDevice_Open(handel, "192.168.2.103", 34567, "admin", "16");
	TDK_OSD_CONFIG config;
	config.channel = 0;
	TDKDevice_GetOSDConfig(handel, &config);

	string str = config.name;
	CString cstr;
	string2CStringW(cstr, str, CP_UTF8);

	config.channel = 0;
	config.name_osd.pos.x = 4096;
	config.name_osd.pos.y = 0;
	config.name_osd.pos.w = 4096;
	config.name_osd.pos.h = 100;
	config.name_osd.encodeblend = 1;

	config.time_osd.pos.x = 4096;
	config.time_osd.pos.y = 200;
	config.time_osd.pos.w = 4096;
	config.time_osd.pos.h = 100;
	config.time_osd.encodeblend = 1;

	TDKDevice_SetOSDConfig(handel, &config);


	//TDKDevice_Close(handel);
	//TDKDevice_Delete(handel);

}
