//

#include "stdafx.h"
#include "SDKDemo.h"
#include "Preview.h"
#include "afxdialogex.h"
#include "VideoView.h"
#include <regex>

#define  TIMER_BITRATE 1
#define  TIMER_AUTOCLOSE 2
#define  TIMER_AUTOOPEN 3

#define  TIMER_AUTOCLOSE_RTSPSERVER 4
#define  TIMER_AUTOOPEN_RTSPSERVER 5
// CPreview Ի

IMPLEMENT_DYNAMIC(CPreview, CDialogEx)

CPreview::CPreview(CWnd* pParent /*=NULL*/)
	: CDialogEx(CPreview::IDD, pParent)
{
	memset(&m_blisten, 0, sizeof(m_blisten));
	memset(&m_hPlayer, 0, sizeof(m_hPlayer));

	m_videoview = NULL;
	memset(&m_previewhwnd, 0, sizeof(m_previewhwnd));
	memset(&m_previewwnd, 0, sizeof(m_previewwnd));
	m_hTalk = NULL;

	m_bzoomin = false;
	m_selwnd = 0;

	m_bAutoTest = false;
	m_timerun = 10;
	m_timestop = 10;
	indexuuid = 0;

	m_hcallbackFACE = NULL;
	//m_hcallbackpreview = NULL;
	memset(&m_hcallbackpreview, 0, sizeof(m_hcallbackpreview));
	m_hcallbacktalk = NULL;
}

CPreview::~CPreview()
{
	if (m_videoview != NULL)
	{
		delete m_videoview;
		m_videoview = NULL;
	}		
}

void CPreview::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COMBO_PROTOCOL, m_cbProtocol);
	DDX_Control(pDX, IDC_COMBO_FILETYPE3, m_cbpictype);
	DDX_Control(pDX, IDC_COMBO_FILETYPE4, m_cbrectype);
	DDX_Control(pDX, IDC_COMBO_STREAM, m_cbstreamtype);
	DDX_Control(pDX, IDC_EDIT_CLOUDID, m_editcloudid);
	DDX_Control(pDX, IDC_COMBO_SERVER, m_cbRTSPServer);
	DDX_Control(pDX, IDC_EDIT_SERVER_ADDR, m_editServerAddr);
	DDX_Control(pDX, IDC_EDIT_PORT_SERVER, m_editRTSPServerPort);
	DDX_Control(pDX, IDC_EDIT_USERNAME_RTSPSEVER, m_editRTSPServerUser);
	DDX_Control(pDX, IDC_EDIT_PWD_RTSPSERVER, m_editRTSPServerPwd);
	DDX_Control(pDX, IDC_EDIT_USERNAME_CLOUD, m_editCloudUser);
	DDX_Control(pDX, IDC_EDIT_PWD_CLOUD, m_editCloudPwd);
	DDX_Control(pDX, IDC_EDIT_IP, m_editDevAddr);
	DDX_Control(pDX, IDC_EDIT_PORT, m_editDevPort);
	DDX_Control(pDX, IDC_EDIT_USERNAME, m_editDevUser);
	DDX_Control(pDX, IDC_EDIT_PWD, m_editDevPwd);
	DDX_Control(pDX, IDC_EDIT_SERVER_CLOUD, m_editCloudServer);
	DDX_Control(pDX, IDC_EDIT_PORT_CLOUD, m_editCloudPort);
	DDX_Control(pDX, IDC_COMBO_CHN_NUM, m_cbChanNum);
	DDX_Control(pDX, IDC_LIST_CHN, m_listChn);
	DDX_Control(pDX, IDC_CHECK_ALL_CHN, m_chkAllChn);
	DDX_Control(pDX, IDC_EDIT_TIMER_RUN, m_editRuntime);
	DDX_Control(pDX, IDC_EDIT_TIMER_STOP, m_editStoptime);
	DDX_Control(pDX, IDC_EDIT_NUM, m_testnum);
	DDX_Control(pDX, IDC_COMBO_UNICAST, m_cbunicast);
	DDX_Control(pDX, IDC_EDIT_PORT_HTTP, m_hpPort);
}

BOOL CPreview::OnCommand(WPARAM wParam, LPARAM lParam)
{
	UINT code = HIWORD(wParam);
	HWND hwnd = (HWND)(lParam);
	UINT unid = LOWORD(wParam);
	if (code == EN_KILLFOCUS && IsWindowVisible())
	{
		auto addrRgx = "(?:[1-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(?:\\.(?:[1-9]?[0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}";
		auto portRgx = "(?:[0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4]{4}|65[0-4]{2}|655[0-2]|6553[0-5])";
		if (IsEditTextValid(IDC_EDIT_IP, unid, addrRgx))
		{
			MessageBox(_T("DevAddr text is illegal!"));
			GetDlgItem(IDC_EDIT_IP)->SetFocus();
		}
		else if (IsEditTextValid(IDC_EDIT_PORT, unid, portRgx))
		{
			MessageBox(_T("Port text is illegal!"));
			GetDlgItem(IDC_EDIT_PORT)->SetFocus();
		}
		else if (IsEditTextValid(IDC_EDIT_PORT_HTTP, unid, portRgx))
		{
			MessageBox(_T("Http Port text is illegal!"));
			GetDlgItem(IDC_EDIT_PORT_HTTP)->SetFocus();
		}
		else if (IsEditTextValid(IDC_EDIT_PORT_CLOUD, unid, portRgx))
		{
			MessageBox(_T("Port text is illegal!"));
			GetDlgItem(IDC_EDIT_PORT_CLOUD)->SetFocus();
		}
	}
	return CDialogEx::OnCommand(wParam, lParam);
}


BEGIN_MESSAGE_MAP(CPreview, CDialogEx)
	ON_BN_CLICKED(IDC_BUTTON_PREVIEW, &CPreview::OnBnClickedButtonPreview)
	ON_BN_CLICKED(IDC_BUTTON_SNAP, &CPreview::OnBnClickedButtonSnap)
	ON_BN_CLICKED(IDC_BUTTON_LISTEN, &CPreview::OnBnClickedButtonListen)
	ON_BN_CLICKED(IDC_BUTTON_CLOSE, &CPreview::OnBnClickedButtonClose)
	ON_WM_SIZE()
	ON_BN_CLICKED(IDC_BUTTON_REC, &CPreview::OnBnClickedButtonRec)
	ON_BN_CLICKED(IDC_BUTTON_REC_STOP, &CPreview::OnBnClickedButtonRecStop)
	ON_BN_CLICKED(IDC_BUTTON_TALK, &CPreview::OnBnClickedButtonTalk)
	ON_BN_CLICKED(IDC_BUTTON_STOP_TALK, &CPreview::OnBnClickedButtonStopTalk)
	ON_CBN_SELCHANGE(IDC_COMBO_PROTOCOL, &CPreview::OnCbnSelchangeComboProtocol)
	ON_BN_CLICKED(IDC_BUTTON_SMART, &CPreview::OnBnClickedButtonSmart)
	ON_WM_TIMER()
	ON_WM_DESTROY()
	ON_WM_LBUTTONDBLCLK()
	ON_WM_LBUTTONDOWN()
	ON_BN_CLICKED(IDC_BUTTON_CLOSE_ALL, &CPreview::OnBnClickedButtonCloseAll)
	ON_CBN_SELCHANGE(IDC_COMBO_SERVER, &CPreview::OnCbnSelchangeComboServer)
	ON_CBN_SELCHANGE(IDC_COMBO_CHN_NUM, &CPreview::OnCbnSelchangeComboChnNum)
	ON_BN_CLICKED(IDC_CHECK_ALL_CHN, &CPreview::OnBnClickedCheckAllChn)
	ON_BN_CLICKED(IDC_BUTTON_AUTO, &CPreview::OnBnClickedButtonAuto)
	ON_BN_CLICKED(IDC_BUTTON_LOGIN, &CPreview::OnBnClickedButtonLogin)
	ON_BN_CLICKED(IDC_BUTTON_AUTO_TEST, &CPreview::OnBnClickedButtonAutoTest)
	ON_BN_CLICKED(IDC_BUTTON1, &CPreview::OnBnClickedButton1)
	ON_CBN_SELCHANGE(IDC_COMBO_STREAM, &CPreview::OnCbnSelchangeComboStream)
END_MESSAGE_MAP()


// CPreview Ϣ
int CPreview::LoadLoginInfo()
{
	//Get work path
	char		path[1024];
	path[0] = '\0';
	HMODULE hModule = GetModuleHandleA("TDKSDK.dll");
	GetModuleFileNameA(hModule, path, 1024);
	size_t	len = strlen(path) - strlen("TDKSDK.dll");
	path[len] = '\0';
	m_pathIniFIle = path;
	m_pathIniFIle += "ServerInfo.ini";

	
	GetPrivateProfileString(L"rtspserver", L"addr", L"", m_cstrrtspserveraddr.GetBuffer(MAX_PATH), MAX_PATH, m_pathIniFIle);
	m_rtspserverport = GetPrivateProfileInt(L"rtspserver", L"port", 0, m_pathIniFIle);
	GetPrivateProfileString(L"rtspserver", L"user", L"", m_cstrrtspserveruser.GetBuffer(MAX_USERNAME_LEN), MAX_USERNAME_LEN, m_pathIniFIle);
	GetPrivateProfileString(L"rtspserver", L"pwd", L"", m_cstrrtspserverpwd.GetBuffer(MAX_PASSWORD_LEN), MAX_PASSWORD_LEN, m_pathIniFIle);
	m_editServerAddr.SetWindowText(m_cstrrtspserveraddr);
	CString cstrport;
	cstrport.Format(L"%d", m_rtspserverport);
	m_editRTSPServerPort.SetWindowText(cstrport);
	m_editRTSPServerUser.SetWindowText(m_cstrrtspserveruser);
	m_editRTSPServerPwd.SetWindowText(m_cstrrtspserverpwd);

	GetPrivateProfileString(L"umspcloudserver", L"addr", L"", m_cstrcloudserveraddr.GetBuffer(MAX_PATH), MAX_PATH, m_pathIniFIle);
	m_cloudserverport = GetPrivateProfileInt(L"umspcloudserver", L"port", 0, m_pathIniFIle);
	GetPrivateProfileString(L"umspcloudserver", L"user", L"", m_cstrcloudserveruser.GetBuffer(MAX_USERNAME_LEN), MAX_USERNAME_LEN, m_pathIniFIle);
	GetPrivateProfileString(L"umspcloudserver", L"pwd", L"", m_cstrcloudserverpwd.GetBuffer(MAX_PASSWORD_LEN), MAX_PASSWORD_LEN, m_pathIniFIle);
	GetPrivateProfileString(L"umspcloudserver", L"cloudid", L"", m_cstrcloudid.GetBuffer(MAX_PASSWORD_LEN), MAX_PASSWORD_LEN, m_pathIniFIle);

	m_editCloudServer.SetWindowText(m_cstrcloudserveraddr);
	cstrport.Format(L"%d", m_cloudserverport);
	m_editCloudPort.SetWindowText(cstrport);
	m_editCloudUser.SetWindowText(m_cstrcloudserveruser);
	m_editCloudPwd.SetWindowText(m_cstrcloudserverpwd);
	m_editcloudid.SetWindowText(m_cstrcloudid);

	GetPrivateProfileString(L"device", L"addr", L"", m_cstrdevaddr.GetBuffer(MAX_PATH), MAX_PATH, m_pathIniFIle);
	m_devport = GetPrivateProfileInt(L"device", L"port", 0, m_pathIniFIle);
	GetPrivateProfileString(L"device", L"user", L"", m_cstrdevuser.GetBuffer(MAX_USERNAME_LEN), MAX_USERNAME_LEN, m_pathIniFIle);
	GetPrivateProfileString(L"device", L"pwd", L"", m_cstrdevpwd.GetBuffer(MAX_PASSWORD_LEN), MAX_PASSWORD_LEN, m_pathIniFIle);
	m_editDevAddr.SetWindowText(m_cstrdevaddr);
	cstrport.Format(L"%d", m_devport);
	m_editDevPort.SetWindowText(cstrport);
	m_editDevUser.SetWindowText(m_cstrdevuser);
	m_editDevPwd.SetWindowText(m_cstrdevpwd);

	unsigned int httpPort = GetPrivateProfileInt(L"device", L"httpport", 0, m_pathIniFIle);
	cstrport.Format(L"%d", httpPort);
	m_hpPort.SetWindowText(cstrport);

	m_maxchn= GetPrivateProfileInt(L"channel", L"num", 36, m_pathIniFIle);
	if ( m_maxchn > MAX_CHN_NUM )
	{
		m_maxchn = MAX_CHN_NUM;
	}
	else if ( m_maxchn < 4 )
	{
		m_maxchn = 4;
	}

	return 0;
}
BOOL CPreview::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// TODO:  ڴӶĳʼ
	LoadLoginInfo();
	for (int i = 0; i < m_maxchn; i++)
	{
		RECT rt = { 0 };
		m_previewwnd[i] = new CStatic;
		m_previewwnd[i]->Create(L"", SS_BLACKFRAME, rt, this);
		m_previewhwnd[i] = m_previewwnd[i]->GetSafeHwnd();
		//m_previewwnd[i]->ShowWindow(TRUE);
	}
#if 0
	m_videoview = new CVideoView();
	m_videoview->Create(NULL, _T("VideoView"), WS_CHILD | WS_BORDER, rect, this, 0, NULL);
	m_videoview->ShowWindow(SW_SHOW);
#endif
	m_cbRTSPServer.AddString(L"No");
	//m_cbRTSPServer.AddString(L"Yes");
	m_cbRTSPServer.SetCurSel(0);
	OnCbnSelchangeComboServer();

	m_cbProtocol.AddString(L"tdk");
	m_cbProtocol.AddString(L"rtsp");
	m_cbProtocol.AddString(L"umsp");
	m_cbProtocol.AddString(L"tdks");
	m_cbProtocol.SetCurSel(0);
	OnCbnSelchangeComboProtocol();

	m_smartmask = 0;

	m_cbpictype.ResetContent();
	m_cbpictype.AddString(L"bmp");
	m_cbpictype.AddString(L"jpg");
	m_cbpictype.SetCurSel(0);

	m_cbrectype.ResetContent();
	m_cbrectype.AddString(L"avi");
	m_cbrectype.AddString(L"mp4");
	m_cbrectype.SetCurSel(0);

	m_cbstreamtype.AddString(L"main stream");
	m_cbstreamtype.AddString(L"sub stream");
	//m_cbstreamtype.AddString(L"third stream");
	//m_cbstreamtype.AddString(L"alarm stream");
	m_cbstreamtype.SetCurSel(0);

	m_listChn.SetExtendedStyle(m_listChn.GetExtendedStyle() | LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES | LVS_EX_SUBITEMIMAGES | LVS_EX_CHECKBOXES);
	m_listChn.InsertColumn(0, _T(""), LVCFMT_CENTER, 50);
	m_listChn.InsertColumn(1, L"", LVCFMT_LEFT, 170);

	m_cbChanNum.AddString(L"1");
	m_cbChanNum.AddString(L"4");
	if ( m_maxchn > 4 )
	{
		m_cbChanNum.AddString(L"9");
	}
	if (m_maxchn > 9)
	{
		m_cbChanNum.AddString(L"16");
	}
	if (m_maxchn > 16)
	{
		m_cbChanNum.AddString(L"36");
	}
	if (m_maxchn > 36)
	{
		m_cbChanNum.AddString(L"64");
	}
	m_cbChanNum.SetCurSel(0);
	OnCbnSelchangeComboChnNum();

	m_chkAllChn.SetCheck(TRUE);
	OnBnClickedCheckAllChn();

	m_editRuntime.SetWindowText(_T("10"));
	m_editStoptime.SetWindowText(_T("10"));

	m_testnum.SetWindowTextW(L"5");

	return TRUE;  // return TRUE unless you set the focus to a control
	// 쳣:  OCX ҳӦ FALSE
}
int CPreview::AjustPreviewWnd()
{
	if (m_cbstreamtype.GetSafeHwnd() == NULL)
	{
		return 0;
	}
	CRect rect;
	GetDlgItem(IDC_STATIC_LOGIN_INFO)->GetWindowRect(&rect);
	ScreenToClient(&rect);
	int top = rect.bottom + MARGIN;

	m_cbstreamtype.GetWindowRect(&rect);
	ScreenToClient(&rect);
	int left = rect.right + MARGIN;

	CRect dlgrect;
	GetClientRect(&dlgrect);
	m_rectPreviewWndZoomIn.left = left;
	m_rectPreviewWndZoomIn.top = top;
	m_rectPreviewWndZoomIn.right = dlgrect.right - MARGIN;
	m_rectPreviewWndZoomIn.bottom = dlgrect.bottom - MARGIN;
	if (m_bzoomin)
	{
		m_previewwnd[m_selwnd]->MoveWindow(&m_rectPreviewWndZoomIn);
		return 0;
	}
	int  sqrtnum= (int)sqrt(m_chnnum);
	int width = (m_rectPreviewWndZoomIn.Width() - INTERVAL_WND*(sqrtnum - 1)) / sqrtnum;
	int height = (m_rectPreviewWndZoomIn.Height() - INTERVAL_WND*(sqrtnum - 1)) / sqrtnum;

	for (int i = 0; i < m_chnnum; i++)
	{
		m_previewwnd[i]->MoveWindow((i%sqrtnum)*(width + INTERVAL_WND) + m_rectPreviewWndZoomIn.left, (i / sqrtnum)*(height + INTERVAL_WND) + m_rectPreviewWndZoomIn.top, width, height, TRUE);
// 		g_dlgOutput[i].m_struCardPlayParam.nLeft = (i%iSqrtNum)*(width + INTERVAL_WND);
// 		g_dlgOutput[i].m_struCardPlayParam.nTop = (i / iSqrtNum)*(iHeight + INTERVAL_WND);
// 		g_dlgOutput[i].m_struCardPlayParam.nWidth = width;
// 		g_dlgOutput[i].m_struCardPlayParam.nHeight = iHeight;
		m_previewwnd[i]->ShowWindow(SW_SHOW);
	}
	return 0;
}
int CPreview::ClearAllPreviewWnd()
{
	for (int i = 0; i < m_maxchn; i++)
	{
		if ( m_previewwnd[i])
		{
			m_previewwnd[i]->DestroyWindow();
			delete m_previewwnd[i];
		}
	}
	return 0;
}
int CPreview::GetLoginInfo()
{
	m_url.Empty();
	std::string str;
	CString cstr;
	
	int index = m_cbRTSPServer.GetCurSel();
	if (index == 1)//rtsp server
	{
		m_url += _T("rtsp://");
		m_editDevUser.GetWindowTextW(cstr);
		CStringW2string(cstr, m_username, CP_ACP);
		m_editDevPwd.GetWindowTextW(cstr);
		CStringW2string(cstr, m_password, CP_ACP);
		m_editServerAddr.GetWindowTextW(cstr);
		m_url+=cstr;
		m_url += _T(":");
		m_editRTSPServerPort.GetWindowTextW(cstr);
		m_url += cstr;

		m_url += _T("/mode=stream&uri=&&");
		//////////////////////////////////////////////////////////////////////////
		index = m_cbProtocol.GetCurSel();
		m_cbProtocol.GetLBText(index, cstr);
		m_url += cstr;

		m_url += _T("://");
		if ( index == 0 || index == 1)
		{
			m_editDevAddr.GetWindowTextW(cstr);
			m_url += cstr;
			m_url += _T(":");
			m_editDevPort.GetWindowTextW(cstr);
			m_url += cstr;
		}
		else if (index == 2)
		{
			m_editCloudServer.GetWindowTextW(cstr);
			m_url += cstr;
			m_url += _T(":");
			m_editCloudPort.GetWindowTextW(cstr);
			m_url += cstr;

			m_editcloudid.GetWindowTextW(cstr);
			m_url += _T("/cloudid=");
			m_url += cstr;
		}
	}
	else
	{
		CString protocol;
		index = m_cbProtocol.GetCurSel();
		m_cbProtocol.GetWindowTextW(protocol);
		m_url += protocol;

		m_url += _T("://");
		if (protocol == L"umsp" || protocol == L"tdks")
		{
			//	p2p
			//	tdks://[clouduser:cloudpass@]cloud_domain:cloud_port/authen=devusr&devpass/cloudid=umksxxxxxxxx/mode=real&idc=1&ids=1&hp=httpPort";
			m_editCloudUser.GetWindowTextW(cstr);
			m_url += cstr;
			CStringW2string(cstr, m_username, CP_ACP);
			m_editCloudPwd.GetWindowTextW(cstr);
			if (cstr.IsEmpty() == false)
			{
				m_url += _T(":");
				m_url += cstr;
				CStringW2string(cstr, m_password, CP_ACP);
			}
			m_url += _T("@");
			m_editCloudServer.GetWindowTextW(cstr);
			m_url += cstr;
			m_url += _T(":");
			m_editCloudPort.GetWindowTextW(cstr);
			m_url += cstr;

			m_url += _T("/authen=");
			m_editDevUser.GetWindowTextW(cstr);
			m_url += cstr;
			m_editDevPwd.GetWindowTextW(cstr);
			if (cstr.IsEmpty() == false)
			{
				m_url += _T("&");
				m_url += cstr;
			}

			m_editcloudid.GetWindowTextW(cstr);
			m_url += _T("/cloudid=");
			m_url += cstr;
		}
		else if(protocol == L"tdk" || protocol == L"rtsp")
		{
			//"tdk://ip:port/mode=real&idc=1&ids=1&hp=httpPort";
			GetDlgItem(IDC_EDIT_USERNAME)->GetWindowTextW(cstr);
			CStringW2string(cstr, m_username, CP_ACP);
			m_editDevPwd.GetWindowTextW(cstr);
			CStringW2string(cstr, m_password, CP_ACP);
			GetDlgItem(IDC_EDIT_IP)->GetWindowTextW(cstr);
			CStringW2string(cstr, m_ip, CP_ACP);
			m_url += cstr;
			m_url += _T(":");
			GetDlgItem(IDC_EDIT_PORT)->GetWindowTextW(cstr);
			std::string strport;
			CStringW2string(cstr, strport, CP_ACP);
			m_port = atoi(strport.c_str());
			m_url += cstr;
		}

		if (protocol == L"rtsp")
		{
			m_url += L"/";
		}
		else
		{
			m_url += L"/hp=";
			m_hpPort.GetWindowTextW(cstr);
			m_url += cstr;
			m_url += L"&";
		}
	}

	return 0;
}
void CPreview::OnSize(UINT nType, int cx, int cy)
{
	CDialogEx::OnSize(nType, cx, cy);

	// TODO:  ڴ˴Ϣ
	if (m_videoview != NULL)
	{
		CRect	rect;
		GetDlgItem(IDC_STATIC_PREVIEW)->GetWindowRect(&rect);
		rect.left = rect.right - rect.Width() / 4;
		rect.top = rect.bottom - rect.Height() / 4;

		ScreenToClient(&rect);
		m_videoview->MoveWindow(&rect);
	}
	AjustPreviewWnd();
	Invalidate(TRUE);
}

void CPreview::OnBnClickedButtonPreview()
{
	// TODO:  ڴӿؼ֪ͨ
	BeginWaitCursor();
	stopAll();
	GetLoginInfo();
	int index = 0;
	int streamtype = m_cbstreamtype.GetCurSel()+1;
	if (streamtype == 4)//alarm stream
	{
		for (int i = 0; i < m_chnnum; i++)
		{
			if (m_listChn.GetCheck(i) == false)
				continue;
			m_hPlayer[index] = TDKSmart_Create();
			if (!m_hPlayer[index])
				continue;
			if (!m_hcallbackFACE)
				m_hcallbackFACE = TDKCBCreate(this, (TDKCALLBACK)&callback_FACE);
			int ret = TDKSmart_Attach(m_hPlayer[index], m_hcallbackFACE);
			if (ret != TDK_OK)
			{
				TRACE("TDKSmartAttach Fail: ret = %d\n", ret);
			}
			
			ret = TDKSmart_Open(m_hPlayer[index],m_ip.c_str(), m_port, m_username.c_str(), m_password.c_str());
			index++;
		}
	}
	else
	{
		for (int i = 0; i < m_chnnum; i++)
		{
			if (m_listChn.GetCheck(i) == false)
				continue;
			m_hPlayer[index] = TDKPlayer_Create(m_previewhwnd[index], 0);
			if (!m_hPlayer[index])
				continue;
			CString cstr;
			cstr.Format(_T("mode=real&idc=%d&ids=%d"), i + 1, streamtype);
			cstr = m_url + cstr;
			if (m_cbRTSPServer.GetCurSel() == 1)
			{
				cstr += _T("&&");
			}
			if (!m_hcallbackpreview[index])
				m_hcallbackpreview[index] = TDKCBCreate(this, (TDKCALLBACK)&callback_preview);
			TDKPlayer_Attach(m_hPlayer[index], m_hcallbackpreview[index]);
			std::string strurl;
			CStringW2string(cstr, strurl, CP_ACP);
			int ret = TDKPlayer_Open(m_hPlayer[index], (const char*)strurl.c_str(), m_username.c_str(), m_password.c_str());
			TDKPlayer_Start(m_hPlayer[index]);
			index++;
		}
	}

	SetTimer(TIMER_BITRATE, 1000, NULL);
	EndWaitCursor();
}

void CPreview::OnBnClickedButtonClose()
{
	// TODO:  ڴӿؼ֪ͨ
	BeginWaitCursor();
	for (int i = 0; i < m_listChn.GetItemCount(); ++i)
	{
		if (m_listChn.GetCheck(i))
		{
			m_selwnd = i;
			stop(m_selwnd);
			m_hPlayer[m_selwnd] = NULL;
			int i = 0;
			for (; i < MAX_PREVIEW_NUM; i++)
			{
				if (m_hPlayer[i])
				{
					break;
				}
			}
			if (i == MAX_PREVIEW_NUM)
			{
				KillTimer(TIMER_BITRATE);
			}
			Invalidate();
			EndWaitCursor();
		}
	}
	
	
	
	
}
int CPreview::stop(int index)
{
	if ( index < 0 || index >= MAX_PREVIEW_NUM)
	{
		return -1;
	}
	if (m_videoview)
	{
		m_videoview->SetPlayer(NULL);
	}
	if ( m_hPlayer[index] == NULL )
	{
		return -1;
	}
	int streamtype = m_cbstreamtype.GetCurSel() + 1;
	if (streamtype == 4)
	{
		TDKSmart_Close(m_hPlayer[index]);
		TDKSmart_Detach(m_hPlayer[index], m_hcallbackFACE);
		TDKSmart_Delete(m_hPlayer[index]);
	}
	else
	{
		TDKPlayer_Stop(m_hPlayer[index]);
		TDKPlayer_Close(m_hPlayer[index]);
		TDKPlayer_Detach(m_hPlayer[index], m_hcallbackpreview[index]);
		TDKCBDelete(m_hcallbackpreview[index]);
		TDKPlayer_Delete(m_hPlayer[index]);
	}

	m_hPlayer[index] = NULL;
	m_hcallbackpreview[index] = NULL;
	KillTimer(TIMER_BITRATE);
	return 0;
}
int CPreview::stopAll()
{
	KillTimer(TIMER_BITRATE);
	for (int i = 0; i < MAX_PREVIEW_NUM; i++)
	{
		stop(i);
	}
	TDKCBDelete(m_hcallbackFACE);
	m_hcallbackFACE = NULL;
	return 0;
}

void CPreview::OnBnClickedButtonRec()
{
	// TODO:  ڴӿؼ֪ͨ
	
}

void CPreview::OnBnClickedButtonRecStop()
{
	// TODO:  ڴӿؼ֪ͨ

}

int CPreview::callback_talk(void* context, TDKU32 cmd, void* param0, void* param1, void* param2)
{
	if (cmd != TDKTALK_MSG_PACKET)
		return 0;
	CPreview* pthis = (CPreview*)context;
	if (cmd == TDKTALK_MSG_PACKET)
	{
		TDK_FRAMEHEAD* head = (TDK_FRAMEHEAD*)param1;
		TDKU8*	data = (TDKU8*)(head + 1);
		TRACE("Frame(%04d-%02d-%02d %02d:%02d:%02d.%03u), codec = %d, type = %d, fps = %.3f, len = %d, \
			  			  			  			  			(%02x %02x %02x %02x-%02x %02x %02x %02x) -----(%02x %02x %02x %02x %02x %02x %02x %02x)\n",
															head->tms.year + 2000, head->tms.month, head->tms.day,
															head->tms.hour, head->tms.minute, head->tms.second, head->ms,
															head->codec, head->prefix[3] - TDKFRAME_BASE, (float)(head->fps / 4.0), head->length,
															data[0], data[1], data[2], data[3], data[4], data[5], data[6], data[7],
															data[8], data[9], data[10], data[11], data[12], data[13], data[14], data[15]);
		//
		//TDKTalk_SendData(pthis->m_hTalk, (char*)data, head->length);
	}
	return 0;
}
int CPreview::OnFaceStreamState(TDKU32 state, TDKS32 error)
{
	TRACE("Smart Stream State = %d, error = %d\n", state, error);
	return 0;
}
int CPreview::callback_FACE(void* context, TDKU32 cmd, void* param0, void* param1, void* param2)
{
	CPreview* pthis = (CPreview*)context;
	if (cmd == TDKSMART_MSG_STATE)
	{
		return pthis->OnFaceStreamState((TDKU32)(size_t)param1, (TDKS32)(size_t)param2);
	}
	if (cmd == TDKSMART_MSG_FRAME)
		return pthis->OnFaceRecv(param1);
	return 0;
}

int CPreview::OnFaceRecv(TDKHANDLE hFrame)
{
	int ret;
	TRACE("\nhFrame = %p\n", hFrame);
	if (hFrame == NULL)
		return 0;
	TDK_SMART_PIC	pic;
	int				num = TDKSmart_Frame_GetFaceNum(hFrame);
	ret = TDKSmart_Frame_GetPicture(hFrame, &pic);
	if (ret == TDK_OK)
	{
		TRACE("Source Picture: w = %d, h = %d, codec = %d, len = %d, facenum = %d\n", pic.w, pic.h, pic.codec, pic.len, num);
	}
	for (int i = 0; i < num; i++)
	{
		TDKHANDLE				hFace = TDKSmart_Frame_GetFace(hFrame, i);
		const TDK_FACEOBJ*		obj = TDKSmart_Face_GetInfo(hFace);
		const TDK_FACE_ATTR*	attr = TDKSmart_Face_GetAttr(hFace);
		ret = TDKSmart_Face_GetPicture(hFace, &pic);
		if (ret == TDK_OK)
		{
			TRACE("Face(%d)---> Picture: w = %d, h = %d, codec = %d, len = %d\n", i, pic.w, pic.h, pic.codec, pic.len);
		}
		if (obj != NULL)
		{
			TRACE("Face(%d)---> Object:  ID = %d, Quality = %d, pos = (%d, %d), (%d, %d)\n", i, obj->id, obj->quality, obj->lefttop.x, obj->lefttop.y, obj->rightend.x, obj->rightend.y);
		}
	}
	TRACE("\n");
	return 0;
}
void CPreview::OnBnClickedButtonTalk()
{
	// TODO:  ڴӿؼ֪ͨ
	if (m_hTalk|| m_hPlayer[m_selwnd] == NULL) {
		return;
	}
	BeginWaitCursor();
	OnBnClickedButtonStopTalk();
	GetLoginInfo();
	m_hTalk = TDKTalk_CreateEx();
	if (!m_hTalk)
	{
		EndWaitCursor();
		MessageBox(_T("Create talk failed!"));
		return;
	}
	m_url += L"talk";
	std::string strurl;
	CStringW2string(m_url, strurl, CP_ACP);
	int ret = TDKTalk_StartEx(m_hTalk, strurl.c_str(), m_username.c_str(), m_password.c_str());
	if ( ret != TDK_OK )
	{
		MessageBox(_T("Open talk failed!"));
	}
	else
	{
		MessageBox(_T("Open talk successed!"));
		printf("TDKTalk_Open OK!!!\n");
	}
	EndWaitCursor();
}


void CPreview::OnBnClickedButtonStopTalk()
{
	// TODO:  ڴӿؼ֪ͨ
	if (!m_hTalk)
		return;
	BeginWaitCursor();
	std::string strurl;
	CStringW2string(m_url, strurl, CP_ACP);
	TDKTalk_StopEx(m_hTalk, strurl.c_str(), m_username.c_str(), m_password.c_str());
	MessageBox(_T("Stop talk successed!")); 
	TDKTalk_DeleteEx(m_hTalk);
	m_hTalk = NULL;
	EndWaitCursor();
}


void CPreview::OnCbnSelchangeComboProtocol()
{
	// TODO:  ڴӿؼ֪ͨ
	int index = m_cbProtocol.GetCurSel();
	CString protocol;
	m_cbProtocol.GetLBText(index, protocol);
	if (protocol == L"rtsp")
	{
		m_editDevAddr.EnableWindow(TRUE);
		m_editDevPort.EnableWindow(TRUE);
		m_editDevUser.EnableWindow(TRUE);
		m_editDevPwd.EnableWindow(TRUE);
		GetDlgItem(IDC_EDIT_IP)->SetWindowTextW(m_cstrdevaddr);
		GetDlgItem(IDC_EDIT_PORT)->SetWindowTextW(L"554");

		m_editCloudServer.EnableWindow(FALSE);
		m_editCloudPort.EnableWindow(FALSE);
		m_editcloudid.EnableWindow(FALSE);
		m_editCloudUser.EnableWindow(FALSE);
		m_editCloudPwd.EnableWindow(FALSE);

		m_hpPort.EnableWindow(FALSE);
	}
	else if (protocol == L"tdk")
	{
		m_editDevAddr.EnableWindow(TRUE);
		m_editDevPort.EnableWindow(TRUE);
		m_editDevUser.EnableWindow(TRUE);
		m_editDevPwd.EnableWindow(TRUE);
		GetDlgItem(IDC_EDIT_IP)->SetWindowTextW(m_cstrdevaddr);
		GetDlgItem(IDC_EDIT_PORT)->SetWindowTextW(L"34567");

		m_editCloudServer.EnableWindow(FALSE);
		m_editCloudPort.EnableWindow(FALSE);
		m_editcloudid.EnableWindow(FALSE);
		m_editCloudUser.EnableWindow(FALSE);
		m_editCloudPwd.EnableWindow(FALSE);

		m_hpPort.EnableWindow(TRUE);
	}
	else if (protocol == L"umsp" || protocol == L"tdks")//UMSP CLOUD || tdks cloud
	{
		m_editDevAddr.EnableWindow(FALSE);
		m_editDevPort.EnableWindow(FALSE);
	
		m_editCloudServer.EnableWindow(TRUE);
		m_editCloudPort.EnableWindow(TRUE);
		m_editcloudid.EnableWindow(TRUE);
		m_editCloudUser.EnableWindow(TRUE);
		m_editCloudPwd.EnableWindow(TRUE);

		m_hpPort.EnableWindow(FALSE);
		CString cloudServer = L"";
		if (protocol == L"umsp")
		{
			cloudServer = "umspcloudserver";
		}
		else
		{
			cloudServer = "tdkscloudserver";
		}
		GetPrivateProfileString(cloudServer, L"addr", L"", m_cstrcloudserveraddr.GetBuffer(MAX_PATH), MAX_PATH, m_pathIniFIle);
		GetPrivateProfileString(cloudServer, L"user", L"", m_cstrcloudserveruser.GetBuffer(MAX_USERNAME_LEN), MAX_USERNAME_LEN, m_pathIniFIle);
		GetPrivateProfileString(cloudServer, L"pwd", L"", m_cstrcloudserverpwd.GetBuffer(MAX_PASSWORD_LEN), MAX_PASSWORD_LEN, m_pathIniFIle);
		GetPrivateProfileString(cloudServer, L"cloudid", L"", m_cstrcloudid.GetBuffer(MAX_PASSWORD_LEN), MAX_PASSWORD_LEN, m_pathIniFIle);
		unsigned int port = GetPrivateProfileInt(cloudServer, L"port", 0, m_pathIniFIle);
		CString strPort;
		strPort.Format(L"%d", port);
		m_editCloudPort.SetWindowText(strPort);
		m_editCloudServer.SetWindowText(m_cstrcloudserveraddr);
		m_editCloudUser.SetWindowText(m_cstrcloudserveruser);
		m_editCloudPwd.SetWindowText(m_cstrcloudserverpwd);
		m_editcloudid.SetWindowText(m_cstrcloudid);
	}
}


void CPreview::OnBnClickedButtonSmart()
{
	// TODO:  ڴӿؼ֪ͨ
	int index = m_cbProtocol.GetCurSel();
	CString protocol;
	m_cbProtocol.GetLBText(index, protocol);
	if (!m_hPlayer[m_selwnd])
	{
		return;
	}
	if (protocol == L"umsp" || protocol == L"rtsp") {
		MessageBox(_T("Not support!"));
		return;
	}
	m_smartmask = !m_smartmask;
	int ret = TDKPlayer_ShowSmart(m_hPlayer[m_selwnd], m_smartmask);
	if (ret == 1)
	{
		MessageBox(_T("Open Smart OK!"));
	}
	else {
		MessageBox(_T("Stop Smart OK!"));
	}
	
}


void CPreview::OnTimer(UINT_PTR nIDEvent)
{
	// TODO:  ڴϢ/Ĭֵ
	switch ( nIDEvent)
	{
	case TIMER_BITRATE:
	{
		for (int i = 0; i < MAX_PREVIEW_NUM; i++ )
		{
			if (m_hPlayer[i])
			{

			}
		}
	}
	break;
	case TIMER_AUTOCLOSE:
	{
							KillTimer(TIMER_AUTOCLOSE);
							OnBnClickedButtonCloseAll();
							SetTimer(TIMER_AUTOOPEN, m_timestop*1000, NULL);
							
	}
		break;
	case TIMER_AUTOOPEN:
	{
							KillTimer(TIMER_AUTOOPEN);
							OnBnClickedButtonPreview();
							SetTimer(TIMER_AUTOCLOSE, m_timerun*1000, NULL);

	}
		break;
	case TIMER_AUTOCLOSE_RTSPSERVER:
	{
							KillTimer(TIMER_AUTOCLOSE_RTSPSERVER);
							OnBnClickedButtonCloseAll();
							SetTimer(TIMER_AUTOOPEN_RTSPSERVER, m_timestop * 1000, NULL);

	}
		break;
	case TIMER_AUTOOPEN_RTSPSERVER:
	{
						   KillTimer(TIMER_AUTOOPEN_RTSPSERVER);
						   OnAutoTest();
						   SetTimer(TIMER_AUTOCLOSE_RTSPSERVER, m_timerun * 1000, NULL);

	}
		break;
	default:
		break;
	}
	__super::OnTimer(nIDEvent);
}


void CPreview::OnDestroy()
{
	__super::OnDestroy();

	// TODO:  ڴ˴Ϣ
	stopAll();
	OnBnClickedButtonStopTalk();
	ClearAllPreviewWnd();
}


void CPreview::OnLButtonDblClk(UINT nFlags, CPoint point)
{
	// TODO:  ڴϢ/Ĭֵ
	if (m_rectPreviewWndZoomIn.PtInRect(point)&& m_chnnum >1) {
		m_bzoomin = !m_bzoomin;
		for (int i = 0; i < m_chnnum; i++)
		{
			CRect rt;
			m_previewwnd[i]->GetWindowRect(&rt);
			ScreenToClient(&rt);
			BOOL  ret = rt.PtInRect(point);
			if (ret)
			{
				if (m_bzoomin)
				{
					m_selwnd = i;
					m_normalsize = rt;
					m_previewwnd[i]->MoveWindow(&m_rectPreviewWndZoomIn);
				}
				else
				{
					AjustPreviewWnd();
				}
			}
			else
			{
				if (m_bzoomin)
				{
					m_previewwnd[i]->ShowWindow(FALSE);
				}
				else
				{
					m_previewwnd[i]->ShowWindow(TRUE);
				}
			}
		}
		Invalidate(TRUE);
		__super::OnLButtonDblClk(nFlags, point);
	}
	
}


void CPreview::OnLButtonDown(UINT nFlags, CPoint point)
{
	// TODO:  ڴϢ/Ĭֵ
	for (int i = 0; i < m_chnnum; i++)
	{
		CRect rt;
		m_previewwnd[i]->GetWindowRect(&rt);
		ScreenToClient(&rt);
		BOOL  ret = rt.PtInRect(point);
		if (ret)
		{
			m_selwnd = i;
			break;
		}
	}
	__super::OnLButtonDown(nFlags, point);
}


void CPreview::OnBnClickedButtonCloseAll()
{
	// TODO:  ڴӿؼ֪ͨ
	BeginWaitCursor();
	stopAll();
	Invalidate();
	EndWaitCursor();
}


void CPreview::OnCbnSelchangeComboServer()
{
	// TODO:  ڴӿؼ֪ͨ
	int sel = m_cbRTSPServer.GetCurSel();

	m_editServerAddr.EnableWindow(sel);
	m_editRTSPServerPort.EnableWindow(sel);
	m_editRTSPServerUser.EnableWindow(sel);
	m_editRTSPServerPwd.EnableWindow(sel);
}


void CPreview::OnCbnSelchangeComboChnNum()
{
	// TODO:  ڴӿؼ֪ͨ
	m_listChn.DeleteAllItems();
	//ClearAllPreviewWnd();
	m_chkAllChn.SetCheck(FALSE);
	CString cstr;
	m_cbChanNum.GetWindowTextW(cstr);
	m_chnnum = _ttoi(cstr.GetBuffer());
	for (int i = 0; i < m_maxchn; i++)
	{
		if (i < m_chnnum )
		{
			cstr.Format(L"%d", i + 1);
			m_listChn.InsertItem(m_listChn.GetItemCount(), cstr);
			m_previewwnd[i]->ShowWindow(TRUE);
		}
		m_previewwnd[i]->ShowWindow(FALSE);
	}
	m_bzoomin = false;
	AjustPreviewWnd();
}


void CPreview::OnBnClickedCheckAllChn()
{
	// TODO:  ڴӿؼ֪ͨ
	int check = m_chkAllChn.GetCheck();
	for (int i = 0; i < m_chnnum; i++)
	{
		m_listChn.SetCheck(i,check);
	}
}

void CPreview::OnBnClickedButtonAuto()
{
	// TODO:  ڴӿؼ֪ͨ
	if (m_bAutoTest)
	{
		KillTimer(TIMER_AUTOCLOSE);
		KillTimer(TIMER_AUTOOPEN);
		GetDlgItem(IDC_BUTTON_AUTO)->SetWindowText(_T("Auto"));
		m_bAutoTest = false;
		return;
	}
	OnBnClickedButtonPreview();
	CString strtime;
	m_editRuntime.GetWindowText(strtime);
	m_timerun = _ttoi(strtime.GetBuffer());
	m_editStoptime.GetWindowText(strtime);
	m_timestop = _ttoi(strtime.GetBuffer());

	SetTimer(TIMER_AUTOCLOSE, m_timerun*1000, NULL);
	GetDlgItem(IDC_BUTTON_AUTO)->SetWindowText(_T("Stop"));
	m_bAutoTest = true;
}


void CPreview::OnBnClickedButtonLogin()
{
	// TODO:  ڴӿؼ֪ͨ
}


void CPreview::OnBnClickedButtonAutoTest()
{
	// TODO:  ڴӿؼ֪ͨ
	if (m_bAutoTest)
	{
		indexuuid = 0;
		KillTimer(TIMER_AUTOCLOSE_RTSPSERVER);
		KillTimer(TIMER_AUTOOPEN_RTSPSERVER);
		GetDlgItem(IDC_BUTTON_AUTO_TEST)->SetWindowText(_T("Auto Test"));
		m_bAutoTest = false;
		return;
	}
	OnAutoTest();
	
	CString strtime;
	m_editRuntime.GetWindowText(strtime);
	m_timerun = _ttoi(strtime.GetBuffer());
	m_editStoptime.GetWindowText(strtime);
	m_timestop = _ttoi(strtime.GetBuffer());

	SetTimer(TIMER_AUTOCLOSE_RTSPSERVER, m_timerun * 1000, NULL);
	GetDlgItem(IDC_BUTTON_AUTO_TEST)->SetWindowText(_T("Stop"));
	m_bAutoTest = true;
}
int CPreview::OnAutoTest()
{
	
	return 0;
}
void CPreview::OnBnClickedButton1()
{
	// TODO:  ڴӿؼ֪ͨ
}
//	Ԥرͽӿ
//	TDKHANDLE	m_hLiveStream;
//	TDKHANDLE	m_hLiveCallback;
int CPreview::OnLiveStreamState(TDKU32 state, TDKS32 error)
{
	TRACE("Live Stream State = %d, error = %d\n", state, error);
	return 0;
}
int CPreview::callback_preview(void* context, TDKU32 cmd, void* param0, void* param1, void* param2)
{
	CPreview* pthis = (CPreview*)context;
	if (cmd == TDKPLAYER_MSG_PACKET)
	{
		TDK_FRAMEHEAD* head = (TDK_FRAMEHEAD*)param1;
		TDKU8*	data = (TDKU8*)(head + 1);
#if 0
		TRACE("Frame(%04d-%02d-%02d %02d:%02d:%02d.%03u), codec = %d, type = %d, fps = %.3f, len = %d, \
			  			(%02x %02x %02x %02x-%02x %02x %02x %02x) -----(%02x %02x %02x %02x %02x %02x %02x %02x)\n",
						head->tms.year + 2000, head->tms.month, head->tms.day,
						head->tms.hour, head->tms.minute, head->tms.second, head->ms,
						head->codec, head->prefix[3] - TDKFRAME_BASE, (float)(head->fps / 4.0), head->length,
						data[0], data[1], data[2], data[3], data[4], data[5], data[6], data[7],
						data[8], data[9], data[10], data[11], data[12], data[13], data[14], data[15]);
#endif
	}
	if (cmd == TDKPLAYER_MSG_STATE)
		return pthis->OnLiveStreamState((TDKU32)(size_t)param1, (TDKS32)(size_t)param2);
	if (cmd == TDKSMART_MSG_FRAME)
	{
		pthis->OnSmartRecv(param1);
	}
	return TDK_OK;
}

int CPreview::OnSmartRecv(TDKHANDLE hFrame)
{
	if (!hFrame)
	{
		return 0;
	}
	int cnt = TDKSmart_Frame_GetSmartCount(hFrame, TDKSMART_OBJECT_LINE);
	TRACE("Line cross count = %d\n", cnt);
	for (int i = 0; i < cnt; i++ )
	{
		const TDK_SMART_OBJ* obj = TDKSmart_Frame_GetSmartInfo(hFrame,TDKSMART_OBJECT_LINE,i);
		if (obj)
		{
			TRACE("Line cross info, id = %d, state = %d, point num = %d\n",obj->id, obj->state, obj->pointnum);
			for (int i = 0; i < obj->pointnum; i++)
			{
				TRACE("Point x%d = %d, y%d = %d\n", i,obj->point[i].x, i, obj->point[i].y);
			}
		}
	}
	cnt = TDKSmart_Frame_GetSmartCount(hFrame, TDKSMART_OBJECT_AREA);
	TRACE("Area intrusion count = %d\n", cnt);
	for (int i = 0; i < cnt; i++)
	{
		const TDK_SMART_OBJ* obj = TDKSmart_Frame_GetSmartInfo(hFrame, TDKSMART_OBJECT_AREA, i);
		if (obj)
		{
			TRACE("Area intrusion info, id = %d, state = %d, x1 = %d, y1 = %d, x2 = %d, y2 = %d, x3 = %d, y3 = %d, x4 = %d, y4 = %d\n", obj->id, obj->state, 
				obj->point[0].x, obj->point[0].y, obj->point[1].x, obj->point[1].y, obj->point[2].x, obj->point[2].y, obj->point[3].x, obj->point[3].y);
		}
	}
	return 0;
}

bool CPreview::IsEditTextValid(int nID, int uID, const char* rgxStr)
{
	if (nID != uID)
		return false;
	CString text;
	GetDlgItemTextW(nID, text);
	std::regex regex(rgxStr);
	std::wstring wstr(text.GetBuffer());
	std::string str(wstr.begin(), wstr.end());
	if (!std::regex_match(str, regex))
		return true;
	return false;
}

void CPreview::OnCbnSelchangeComboStream()
{
	// TODO:  ڴӿؼ֪ͨ
	int streamtype = m_cbstreamtype.GetCurSel();
	int ret = TDKPlayer_SwitchStream(m_hPlayer[m_selwnd], streamtype);
}

void CPreview::OnBnClickedButtonSnap()
{

}

void CPreview::OnBnClickedButtonListen()
{
	if (m_hPlayer[m_selwnd] == NULL)
	{
		//MessageBox(_T("Not open audio!"));
		return;
	}
	m_blisten[m_selwnd] = !m_blisten[m_selwnd];
	int ret = TDKPlayer_Listen(m_hPlayer[m_selwnd], m_blisten[m_selwnd]);
	if (ret == TDK_OK)
	{
		TRACE("QVPlayerListen %s OK!!!.\n", m_blisten[m_selwnd] ? "Open" : "Close");
		if (m_blisten[m_selwnd]) {
			MessageBox(_T("Open audio OK!"));
		}
		else {
			MessageBox(_T("Stop audio OK!"));
		}
	}
	else
	{
		TRACE("QVPlayerListen %s ERROR!!!.\n", m_blisten[m_selwnd] ? "Open" : "Close");
	}
}