#pragma once
#include "afxcmn.h"
#include "afxwin.h"
#include <map>
#include "VideoView.h"
#include "TimeShaftDlg.h"
#include <string>
#include <list>
using namespace std;

#define  MAX_PLAYBACK_NUM 16

#define  TIMER_PLAY_REMOTE 1
#define  TIMER_DOWNLOAD 2
#define  TIMER_CUT 3
#define  TIMER_PLAY_LOCAL 4

// CPlayback Ի
class CVideoView;
class CPlayback : public CDialogEx
{
	DECLARE_DYNAMIC(CPlayback)

public:
	CPlayback(CWnd* pParent = NULL);   // ׼캯
	virtual ~CPlayback();

// Ի
	enum { IDD = IDD_DIALOG_PLAYBACK };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV ֧
	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);

	TDKHANDLE		m_hPlayer[MAX_PLAYBACK_NUM];
	CVideoView*	m_videoview;
	BOOL m_blisten[MAX_PLAYBACK_NUM];
	HWND m_previewhwnd[MAX_PLAYBACK_NUM];
	//CWnd* m_previewwnd[MAX_PLAYBACK_NUM];
	CStatic* m_previewwnd[MAX_PLAYBACK_NUM];
	TDK_FILE_SEARCH_PARAM m_search;
	TDK_FILE_SUMMARY_SEARCH_PARAM m_searchmonth;
	TDK_FILE_INFO* m_playinfo;

	HANDLE m_hDownload;
	unsigned long m_downsize;
	bool m_bLocalPlayback;

	HANDLE m_hplayersync[MAX_PLAYBACK_NUM];
	int GetLoginInfo();
	CString m_url;
	string m_username;
	string m_password;
	string m_ip;
	unsigned short m_port;

	HANDLE m_task;
	std::list<TDK_FILE_INFO*> m_filelist[MAX_PLAYBACK_NUM];
	HANDLE m_hevtsearch;

	int m_selwnd;
	bool IsSync();
	CWnd* m_check[MAX_CHN_NUM];
	bool m_bzoomin;
	CRect  m_normalsize;

	int m_ChnNum;
	TimeShaftDlg* m_pTimeShaftDlg;
	std::vector<CHNINFO> m_vecChn;//ݵͨϢ
	int count;

	int LoadLoginInfo();
	CString m_pathIniFIle;
	CString m_cstrcloudserveraddr;
	int m_cloudserverport;
	CString m_cstrcloudserveruser;
	CString m_cstrcloudserverpwd;
	CString m_cstrcloudid;
	CString m_cstrdevaddr;
	CString m_cstrdevaddr2;
	CString m_cstrdevport;
	CString m_cstrhttpport;
	CString m_cstrcloudport;
	int m_devport;
	CString m_cstrdevuser;
	CString m_cstrdevpwd;

	int m_maxchn;
	HANDLE m_hdevice;
	int AjustPreviewWnd();
	CRect m_rectPreviewWndZoomIn;

	int SetTimeShaftFilesInfo();
	unsigned long long m_chnmask;
	int PlayBackByTime(int chn, TDK_SYSTEM_TIME* time);
	//int Seek(const TDK_SYSTEM_TIME* time);
	bool IsEditTextValid(int nID, int uID, const char* rgxStr);

	HANDLE m_hDown;
	static HMODULE	s_hLib;

	string					m_enckey;
	string					m_deckey;
	string					m_mediadeckey;

	int SearchEvent();

	int		OnStreamState(TDKU32 state, TDKS32 error);

	TDKHANDLE m_hcallback;
	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnBnClickedButtonPlayback();
	afx_msg void OnBnClickedButtonClose();
	afx_msg void OnBnClickedButtonListen();
	afx_msg void OnBnClickedButtonSnap();
	afx_msg void OnBnClickedButtonPause();
	afx_msg void OnBnClickedButtonResume();
	afx_msg void OnBnClickedButtonFast1();
	afx_msg void OnBnClickedButtonFast2();
	afx_msg void OnBnClickedButtonFast4();
	afx_msg void OnBnClickedButtonFast8();
	afx_msg void OnBnClickedButtonShow2();
	afx_msg void OnBnClickedButtonSlow4();
	afx_msg void OnBnClickedButtonSlow8();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	virtual BOOL OnInitDialog();

	LRESULT StreamEnd(WPARAM p0, LPARAM p1);
	LRESULT StreamStart(WPARAM p0, LPARAM p1);
	int startByTime(int wnd, const TDK_SYSTEM_TIME* time);
	int startByFile(int wnd, const TDK_FILE_INFO* file);
	int stop(int wnd);
	int stopAll();
	static int CALLBACK callback_playback(void* context, TDKU32 cmd, void* param0, void* param1, void* param2);
	static void CALLBACK CBFunctionOfTimeShaft(int chn, SYSTEM_TIME* pst, unsigned long long pContext);

	//HANDLE	GetPlayer(void) const { return m_hPlayer; }
	afx_msg void OnBnClickedButtonSearch();
	CListCtrl m_list;
	afx_msg void OnNMDblclkList1(NMHDR *pNMHDR, LRESULT *pResult);
	virtual BOOL DestroyWindow();
	afx_msg void OnBnClickedButtonStep();
	afx_msg void OnTimer(UINT_PTR nIDEvent);
	CSliderCtrl m_slider;
	afx_msg void OnBnClickedButtonDownload();
	CProgressCtrl m_progressDown;
	afx_msg void OnBnClickedButtonStopDown();
	CComboBox m_filetype;
	afx_msg void OnNMReleasedcaptureSlider1(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnBnClickedButtonStepback();
	afx_msg void OnBnClickedButtonPlay();
	afx_msg void OnBnClickedButtonPlaySync();
	afx_msg void OnBnClickedButtonStopSync();
	afx_msg void OnBnClickedButtonSyncPause();
	afx_msg void OnBnClickedButtonSyncResume();
	CComboBox m_cbProtocol;
	afx_msg void OnCbnSelchangeComboProtocol();
	afx_msg void OnStnClickedStaticPreview();
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	CComboBox m_cbChnNum;
	CComboBox m_cbsearchfiletype;
	CComboBox m_cbsearchrecordtype;
	CButton m_checksubstream;
	CComboBox m_cbrectype;
	CComboBox m_cbpictype;
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnBnClickedButtonCloseAll();
	afx_msg void OnBnClickedButtonSeek();
	CButton m_btn24hr;
	CButton m_btn2hr;
	CButton m_btn1hr;
	CButton m_btn30m;
	afx_msg void OnBnClickedButton24();
	afx_msg void OnBnClickedButton1hr();
	afx_msg void OnBnClickedButton2hr();
	afx_msg void OnBnClickedButton30min();
	CEdit m_editCloudServer;
	CEdit m_editCloudPort;
	CEdit m_editCloudUser;
	CEdit m_editCloudPwd;
	CEdit m_editcloudid;
	CEdit m_editDevUser;
	CEdit m_editDevPwd;
	CEdit m_editDevAddr;
	CEdit m_editDevPort;
	CListCtrl m_listChn;
	CButton m_chkAllChn;
	afx_msg void OnBnClickedButtonLogin();
	afx_msg void OnBnClickedCheckAllChn();
	afx_msg void OnBnClickedCheckSync();
	CButton m_checkSync;
	afx_msg void OnBnClickedButtonPre();
	afx_msg void OnBnClickedButtonNext();
	afx_msg void OnCbnSelchangeComboFileType();
	CComboBox m_cbdisk;
	afx_msg void OnCbnSelchangeComboDisk();
	CStatic m_staticfilebegintime;
	CStatic m_staticfileendtime;
	CStatic m_staticFileName;
	CComboBox m_cbPlaybackMode;
	afx_msg void OnCbnSelchangeComboPlayMode();
	CButton m_btnSearch;
	afx_msg void OnCbnSelchangeComboRecType();
	CListCtrl m_listctrlevent;
	afx_msg void OnNMDblclkListEvent(NMHDR *pNMHDR, LRESULT *pResult);
	CEdit m_hpPort;
};
