// Playback.cpp : ʵļ
//

#include "stdafx.h"
#include "SDKDemo.h"
#include "Playback.h"
#include "afxdialogex.h"
#include <regex>
// CPlayback Ի

HMODULE CPlayback::s_hLib = NULL;

IMPLEMENT_DYNAMIC(CPlayback, CDialogEx)

CPlayback::CPlayback(CWnd* pParent /*=NULL*/)
	: CDialogEx(CPlayback::IDD, pParent)
{
	memset(m_blisten, 0, sizeof(m_blisten));
	memset(m_hPlayer, 0, sizeof(m_hPlayer));
	m_videoview = NULL;
	memset(&m_previewhwnd, 0, sizeof(m_previewhwnd));
	memset(&m_previewwnd, 0, sizeof(m_previewwnd));
	m_playinfo = NULL;
	count = 0;

	m_hDownload = NULL;
	m_downsize = 0;
	m_bLocalPlayback = false;

	memset(&m_hplayersync, 0, sizeof(m_hplayersync));
	m_bzoomin = false;

	m_pTimeShaftDlg = NULL;
	m_ChnNum = 4;

	m_hdevice = NULL;
	m_maxchn = 64;
	m_chnmask = 0;

	m_hDown = NULL;
	m_hevtsearch = NULL;
	m_hcallback = NULL;
}

CPlayback::~CPlayback()
{
	if (s_hLib)
	{
		FreeLibrary(s_hLib);
		s_hLib = NULL;
	}
}

void CPlayback::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST1, m_list);
	DDX_Control(pDX, IDC_SLIDER1, m_slider);
	DDX_Control(pDX, IDC_PROGRESS_DOWN, m_progressDown);
	DDX_Control(pDX, IDC_COMBO_FILETYPE, m_filetype);
	DDX_Control(pDX, IDC_COMBO_PROTOCOL2, m_cbProtocol);
	DDX_Control(pDX, IDC_COMBO1, m_cbChnNum);
	DDX_Control(pDX, IDC_COMBO_FILE_TYPE, m_cbsearchfiletype);
	DDX_Control(pDX, IDC_COMBO_REC_TYPE, m_cbsearchrecordtype);
	DDX_Control(pDX, IDC_CHECK_SUBSTREAM, m_checksubstream);
	DDX_Control(pDX, IDC_COMBO_FILETYPE2, m_cbrectype);
	DDX_Control(pDX, IDC_COMBO_FILETYPE3, m_cbpictype);
	DDX_Control(pDX, IDC_BUTTON_24, m_btn24hr);
	DDX_Control(pDX, IDC_BUTTON_2HR, m_btn2hr);
	DDX_Control(pDX, IDC_BUTTON_1HR, m_btn1hr);
	DDX_Control(pDX, IDC_BUTTON_30MIN, m_btn30m);
	DDX_Control(pDX, IDC_EDIT_SERVER_CLOUD, m_editCloudServer);
	DDX_Control(pDX, IDC_EDIT_PORT_CLOUD, m_editCloudPort);
	DDX_Control(pDX, IDC_EDIT_USERNAME_CLOUD, m_editCloudUser);
	DDX_Control(pDX, IDC_EDIT_PWD_CLOUD, m_editCloudPwd);
	DDX_Control(pDX, IDC_EDIT_CLOUDID2, m_editcloudid);
	DDX_Control(pDX, IDC_EDIT_USERNAME2, m_editDevUser);
	DDX_Control(pDX, IDC_EDIT_PWD2, m_editDevPwd);
	DDX_Control(pDX, IDC_EDIT_IP2, m_editDevAddr);
	DDX_Control(pDX, IDC_EDIT_PORT, m_editDevPort);
	DDX_Control(pDX, IDC_LIST_CHN, m_listChn);
	DDX_Control(pDX, IDC_CHECK_ALL_CHN, m_chkAllChn);
	DDX_Control(pDX, IDC_CHECK_SYNC, m_checkSync);
	DDX_Control(pDX, IDC_COMBO_DISK, m_cbdisk);
	DDX_Control(pDX, IDC_STATIC_FILE_BEGIN_TIME, m_staticfilebegintime);
	DDX_Control(pDX, IDC_STATIC_FILE_END_TIME, m_staticfileendtime);
	DDX_Control(pDX, IDC_STATIC_FILE_NAME, m_staticFileName);
	DDX_Control(pDX, IDC_COMBO_PLAY_MODE, m_cbPlaybackMode);
	DDX_Control(pDX, IDC_BUTTON_SEARCH, m_btnSearch);
	DDX_Control(pDX, IDC_LIST_EVENT, m_listctrlevent);
	DDX_Control(pDX, IDC_EDIT_PORT_HTTP2, m_hpPort);
}

BOOL CPlayback::OnCommand(WPARAM wParam, LPARAM lParam)
{
	UINT code = HIWORD(wParam);
	HWND hwnd = (HWND)(lParam);
	UINT unid = LOWORD(wParam);
	if (code == EN_KILLFOCUS && IsWindowVisible())
	{
		auto addrRgx = "(?:[1-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(?:\\.(?:[1-9]?[0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}";
		auto portRgx = "(?:[0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4]{4}|65[0-4]{2}|655[0-2]|6553[0-5])";
		if (IsEditTextValid(IDC_EDIT_PORT_CLOUD, unid, portRgx))
		{
			MessageBox(_T("Port text is illegal!"));
			GetDlgItem(IDC_EDIT_PORT_CLOUD)->SetFocus();
		}
		else if (IsEditTextValid(IDC_EDIT_PORT, unid, portRgx))
		{
			MessageBox(_T("Port text is illegal!"));
			GetDlgItem(IDC_EDIT_PORT)->SetFocus();
		}
		else if (IsEditTextValid(IDC_EDIT_PORT_HTTP2, unid, portRgx))
		{
			MessageBox(_T("Http Port text is illegal!"));
			GetDlgItem(IDC_EDIT_PORT_HTTP2)->SetFocus();
		}
		else if (IsEditTextValid(IDC_EDIT_IP2, unid, addrRgx))
		{
			MessageBox(_T("DevAddr text is illegal!"));
			GetDlgItem(IDC_EDIT_IP2)->SetFocus();
		}
	}
	return CDialogEx::OnCommand(wParam, lParam);
}


BEGIN_MESSAGE_MAP(CPlayback, CDialogEx)
	ON_BN_CLICKED(IDC_BUTTON_PLAYBACK, &CPlayback::OnBnClickedButtonPlayback)
	ON_BN_CLICKED(IDC_BUTTON_CLOSE, &CPlayback::OnBnClickedButtonClose)
	ON_BN_CLICKED(IDC_BUTTON_LISTEN, &CPlayback::OnBnClickedButtonListen)
	ON_BN_CLICKED(IDC_BUTTON_SNAP, &CPlayback::OnBnClickedButtonSnap)
	ON_BN_CLICKED(IDC_BUTTON_PAUSE, &CPlayback::OnBnClickedButtonPause)
	ON_BN_CLICKED(IDC_BUTTON_RESUME, &CPlayback::OnBnClickedButtonResume)
	ON_BN_CLICKED(IDC_BUTTON_FAST_1, &CPlayback::OnBnClickedButtonFast1)
	ON_BN_CLICKED(IDC_BUTTON_FAST_2, &CPlayback::OnBnClickedButtonFast2)
	ON_BN_CLICKED(IDC_BUTTON_FAST_4, &CPlayback::OnBnClickedButtonFast4)
	ON_BN_CLICKED(IDC_BUTTON_FAST_8, &CPlayback::OnBnClickedButtonFast8)
	ON_BN_CLICKED(IDC_BUTTON_SHOW_2, &CPlayback::OnBnClickedButtonShow2)
	ON_BN_CLICKED(IDC_BUTTON_SLOW_4, &CPlayback::OnBnClickedButtonSlow4)
	ON_BN_CLICKED(IDC_BUTTON_SLOW_8, &CPlayback::OnBnClickedButtonSlow8)
	ON_WM_SIZE()
	ON_BN_CLICKED(IDC_BUTTON_SEARCH, &CPlayback::OnBnClickedButtonSearch)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST1, &CPlayback::OnNMDblclkList1)
	//ON_MESSAGE(QVMSG_STREAM_END,&CPlayback::StreamEnd)
	//ON_MESSAGE(QVMSG_STREAM_START, &CPlayback::StreamStart)
	ON_BN_CLICKED(IDC_BUTTON_STEP, &CPlayback::OnBnClickedButtonStep)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_BUTTON_DOWNLOAD, &CPlayback::OnBnClickedButtonDownload)
	ON_BN_CLICKED(IDC_BUTTON_STOP_DOWN, &CPlayback::OnBnClickedButtonStopDown)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER1, &CPlayback::OnNMReleasedcaptureSlider1)
	ON_BN_CLICKED(IDC_BUTTON_STEPBACK, &CPlayback::OnBnClickedButtonStepback)
	ON_BN_CLICKED(IDC_BUTTON_PLAY, &CPlayback::OnBnClickedButtonPlay)
	ON_BN_CLICKED(IDC_BUTTON_PLAY_SYNC, &CPlayback::OnBnClickedButtonPlaySync)
	//ON_BN_CLICKED(IDC_BUTTON_STOP_SYNC, &CPlayback::OnBnClickedButtonStopSync)
	ON_CBN_SELCHANGE(IDC_COMBO_PROTOCOL2, &CPlayback::OnCbnSelchangeComboProtocol)
	ON_STN_CLICKED(IDC_STATIC_PREVIEW, &CPlayback::OnStnClickedStaticPreview)
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONDBLCLK()
	ON_BN_CLICKED(IDC_BUTTON_CLOSE_ALL, &CPlayback::OnBnClickedButtonCloseAll)
	ON_BN_CLICKED(IDC_BUTTON_SEEK, &CPlayback::OnBnClickedButtonSeek)
	ON_BN_CLICKED(IDC_BUTTON_24, &CPlayback::OnBnClickedButton24)
	ON_BN_CLICKED(IDC_BUTTON_2HR, &CPlayback::OnBnClickedButton2hr)
	ON_BN_CLICKED(IDC_BUTTON_1HR, &CPlayback::OnBnClickedButton1hr)
	ON_BN_CLICKED(IDC_BUTTON_30MIN, &CPlayback::OnBnClickedButton30min)
	ON_BN_CLICKED(IDC_BUTTON_LOGIN, &CPlayback::OnBnClickedButtonLogin)
	ON_BN_CLICKED(IDC_CHECK_ALL_CHN, &CPlayback::OnBnClickedCheckAllChn)
	ON_BN_CLICKED(IDC_CHECK_SYNC, &CPlayback::OnBnClickedCheckSync)
	ON_BN_CLICKED(IDC_BUTTON_PRE, &CPlayback::OnBnClickedButtonPre)
	ON_BN_CLICKED(IDC_BUTTON_NEXT, &CPlayback::OnBnClickedButtonNext)
	ON_CBN_SELCHANGE(IDC_COMBO_FILE_TYPE, &CPlayback::OnCbnSelchangeComboFileType)
	ON_CBN_SELCHANGE(IDC_COMBO_DISK, &CPlayback::OnCbnSelchangeComboDisk)
	ON_CBN_SELCHANGE(IDC_COMBO_PLAY_MODE, &CPlayback::OnCbnSelchangeComboPlayMode)
	ON_CBN_SELCHANGE(IDC_COMBO_REC_TYPE, &CPlayback::OnCbnSelchangeComboRecType)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST_EVENT, &CPlayback::OnNMDblclkListEvent)
END_MESSAGE_MAP()


// CPlayback Ϣ

BOOL CPlayback::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// TODO:  ڴӶĳʼ
	LoadLoginInfo();
	for (int i = 0; i < MAX_PLAYBACK_NUM; i++)
	{
		RECT rt = { 0 };
		m_previewwnd[i] = new CStatic;
		m_previewwnd[i]->Create(L"", SS_BLACKFRAME, rt, this);
		m_previewhwnd[i] = m_previewwnd[i]->GetSafeHwnd();
		//m_previewwnd[i]->ShowWindow(TRUE);
	}
	m_pTimeShaftDlg = new TimeShaftDlg;
	m_pTimeShaftDlg->m_ChnNum = m_ChnNum;
	if (m_ChnNum < 4)
	{
		m_pTimeShaftDlg->SetMaxRowNum(m_ChnNum);
	}
	else
	{
		m_pTimeShaftDlg->SetMaxRowNum(4);
	}


	m_pTimeShaftDlg->Create(TimeShaftDlg::IDD, this);
	m_pTimeShaftDlg->ShowWindow(SW_SHOW);
	m_pTimeShaftDlg->RegisterPlayCallback(CBFunctionOfTimeShaft, this);
#if 0
	m_videoview = new CVideoView();
	m_videoview->Create(NULL, _T("VideoView"), WS_CHILD | WS_BORDER, rect, this, 0, NULL);
	m_videoview->ShowWindow(SW_SHOW);
#endif
	//ļб
//	RECT rtTmp;
	CString strTmp;
	m_list.InsertColumn(0, _T("index"), LVCFMT_LEFT, 40);
	m_list.InsertColumn(1, _T("chn"), LVCFMT_LEFT, 30);
	m_list.InsertColumn(2, _T("begintime"), LVCFMT_LEFT, 80);
	m_list.InsertColumn(3, _T("endtime"), LVCFMT_LEFT, 80);
	m_list.InsertColumn(4, _T("size"), LVCFMT_LEFT, 80);
	m_list.SetExtendedStyle(m_list.GetExtendedStyle() | LVS_EX_FULLROWSELECT | LVS_EX_CHECKBOXES | LVS_EX_GRIDLINES | LVS_EX_SUBITEMIMAGES);

	m_listctrlevent.InsertColumn(0, _T("index"), LVCFMT_LEFT, 40);
	m_listctrlevent.InsertColumn(1, _T("source"), LVCFMT_LEFT, 60);
	m_listctrlevent.InsertColumn(2, _T("chn"), LVCFMT_LEFT, 80);
	m_listctrlevent.InsertColumn(3, _T("time"), LVCFMT_LEFT, 80);
	m_listctrlevent.SetExtendedStyle(m_listctrlevent.GetExtendedStyle() | LVS_EX_FULLROWSELECT | LVS_EX_CHECKBOXES | LVS_EX_GRIDLINES | LVS_EX_SUBITEMIMAGES);
	m_listctrlevent.ShowWindow(FALSE);

	SYSTEMTIME time = {0};
	((CDateTimeCtrl*)GetDlgItem(IDC_DATETIMEPICKER2))->GetTime(&time);
	time.wHour = 0;
	time.wMinute = 0;
	time.wSecond = 0;
	((CDateTimeCtrl*)GetDlgItem(IDC_DATETIMEPICKER2))->SetTime(&time);
	time.wHour = 23;
	time.wMinute = 59;
	time.wSecond = 59;
	((CDateTimeCtrl*)GetDlgItem(IDC_DATETIMEPICKER4))->SetTime(&time);

	m_filetype.Clear();
	m_filetype.AddString(_T("avi"));
	m_filetype.AddString(_T("mp4"));
	m_filetype.SetCurSel(0);

	m_cbrectype.Clear();
	m_cbrectype.AddString(_T("avi"));
	m_cbrectype.SetCurSel(0);

	m_cbpictype.Clear();
	m_cbpictype.AddString(_T("bmp"));
	m_cbpictype.AddString(_T("jpg"));
	m_cbpictype.SetCurSel(0);

	m_cbProtocol.AddString(L"tdk");
	m_cbProtocol.AddString(L"umsp");
	m_cbProtocol.AddString(L"tdks");
	m_cbProtocol.SetCurSel(0);
	OnCbnSelchangeComboProtocol();

	m_selwnd = 0;
	m_cbChnNum.ResetContent();
	m_cbChnNum.AddString(L"1");
	m_cbChnNum.AddString(L"2");
	m_cbChnNum.AddString(L"3");
	m_cbChnNum.AddString(L"4");
	m_cbChnNum.SetCurSel(0);

	m_cbsearchfiletype.ResetContent();
	m_cbsearchfiletype.AddString(L"Record");
	//m_cbsearchfiletype.AddString(L"Picture");
	m_cbsearchfiletype.SetCurSel(0);

	int item = m_cbsearchrecordtype.AddString(L"Timer");
	m_cbsearchrecordtype.SetItemData(item, 1 << TDKREC_TIMER);
	item = m_cbsearchrecordtype.AddString(L"Manual");
	m_cbsearchrecordtype.SetItemData(item, 1 << TDKREC_MANUAL);
	//item = m_cbsearchrecordtype.AddString(L"Event");
	//m_cbsearchrecordtype.SetItemData(item, 1 << TDKREC_EVENT);
	item = m_cbsearchrecordtype.AddString(L"All");
	m_cbsearchrecordtype.SetItemData(item, TDKREC_ALL);
	m_cbsearchrecordtype.SetCurSel(m_cbsearchrecordtype.GetCount()-1);

	m_listChn.SetExtendedStyle(m_listChn.GetExtendedStyle() | LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES | LVS_EX_SUBITEMIMAGES | LVS_EX_CHECKBOXES);
	m_listChn.InsertColumn(0, _T(""), LVCFMT_CENTER, 50);
	m_listChn.InsertColumn(1, L"", LVCFMT_LEFT, 170);

	AjustPreviewWnd();

	m_cbPlaybackMode.AddString(_T("By File"));
	//m_cbPlaybackMode.AddString(_T("By Time"));
	m_cbPlaybackMode.SetCurSel(0);

	m_btnSearch.EnableWindow(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	// 쳣:  OCX ҳӦ FALSE
}
// CPreview Ϣ
int CPlayback::LoadLoginInfo()
{
	//Get work path
	char		path[1024];
	path[0] = '\0';
	HMODULE hModule = GetModuleHandleA("TDKSDK.dll");
	GetModuleFileNameA(hModule, path, 1024);
	size_t	len = strlen(path) - strlen("TDKSDK.dll");
	path[len] = '\0';
	m_pathIniFIle = path;
	m_pathIniFIle += "ServerInfo.ini";

	CString cstrport;
	GetPrivateProfileString(L"umspcloudserver", L"addr", L"", m_cstrcloudserveraddr.GetBuffer(MAX_PATH), MAX_PATH, m_pathIniFIle);
	m_cloudserverport = GetPrivateProfileInt(L"umspcloudserver", L"port", 0, m_pathIniFIle);
	GetPrivateProfileString(L"umspcloudserver", L"user", L"", m_cstrcloudserveruser.GetBuffer(MAX_USERNAME_LEN), MAX_USERNAME_LEN, m_pathIniFIle);
	GetPrivateProfileString(L"umspcloudserver", L"pwd", L"", m_cstrcloudserverpwd.GetBuffer(MAX_PASSWORD_LEN), MAX_PASSWORD_LEN, m_pathIniFIle);
	GetPrivateProfileString(L"umspcloudserver", L"cloudid", L"", m_cstrcloudid.GetBuffer(MAX_PASSWORD_LEN), MAX_PASSWORD_LEN, m_pathIniFIle);
	m_editCloudServer.SetWindowText(m_cstrcloudserveraddr);
	cstrport.Format(L"%d", m_cloudserverport);
	m_editCloudPort.SetWindowText(cstrport);
	m_editCloudUser.SetWindowText(m_cstrcloudserveruser);
	m_editCloudPwd.SetWindowText(m_cstrcloudserverpwd);
	m_editcloudid.SetWindowText(m_cstrcloudid);

	GetPrivateProfileString(L"device", L"addr", L"", m_cstrdevaddr.GetBuffer(MAX_PATH), MAX_PATH, m_pathIniFIle);
	m_devport = GetPrivateProfileInt(L"device", L"port", 0, m_pathIniFIle);
	GetPrivateProfileString(L"device", L"user", L"", m_cstrdevuser.GetBuffer(MAX_USERNAME_LEN), MAX_USERNAME_LEN, m_pathIniFIle);
	GetPrivateProfileString(L"device", L"pwd", L"", m_cstrdevpwd.GetBuffer(MAX_PASSWORD_LEN), MAX_PASSWORD_LEN, m_pathIniFIle);
	m_editDevAddr.SetWindowText(m_cstrdevaddr);
	cstrport.Format(L"%d", m_devport);
	m_editDevPort.SetWindowText(cstrport);
	m_editDevUser.SetWindowText(m_cstrdevuser);
	m_editDevPwd.SetWindowText(m_cstrdevpwd);

	unsigned int httpPort = GetPrivateProfileInt(L"device", L"httpport", 0, m_pathIniFIle);
	cstrport.Format(L"%d", httpPort);
	m_hpPort.SetWindowText(cstrport);

	return 0;
}
BOOL CPlayback::DestroyWindow()
{
	// TODO:  ڴרô/û
	if (m_videoview != NULL)
	{
		delete m_videoview;
		m_videoview = NULL;
	}
	//stopAll();
	for (int i = 0; i < MAX_PLAYBACK_NUM; i++)
	{
		stop(i);
	}

	for (int i = 0; i < MAX_PLAYBACK_NUM; i++)
	{
		if (m_previewwnd[i])
		{
			m_previewwnd[i]->DestroyWindow();
			delete m_previewwnd[i];
		}
	}
	if (m_pTimeShaftDlg)
	{
		if (m_pTimeShaftDlg->m_hWnd)
		{
			m_pTimeShaftDlg->DestroyWindow();
		}
		delete m_pTimeShaftDlg;
		m_pTimeShaftDlg = NULL;
	}
	//ʱϢ
	for (int i = 0; i < MAX_PLAYBACK_NUM; i++)
	{
		std::list<TDK_FILE_INFO*>::iterator itr = m_filelist[i].begin();
		while (itr != m_filelist[i].end())
		{
			delete* itr;
			itr++;
		}
		m_filelist[i].clear();
	}
	return __super::DestroyWindow();
}

int CPlayback::GetLoginInfo()
{
	m_url.Empty();
	std::string str;
	CString cstr;

	CString protocol;
	int index = m_cbProtocol.GetCurSel();
	m_cbProtocol.GetLBText(index, protocol);
	m_url += protocol;

	m_url += _T("://");
	if (protocol == L"tdks" || protocol == L"umsp")
	{
		//	p2p
		//	tdks://[clouduser:cloudpass@]cloud_domain:cloud_port/authen=devusr&devpass/cloudid=umksxxxxxxxx/hp=httpPort";
		m_editCloudUser.GetWindowTextW(cstr);
		m_url += cstr;
		CStringW2string(cstr, m_username, CP_ACP);
		m_editCloudPwd.GetWindowTextW(cstr);
		if (cstr.IsEmpty() == false)
		{
			m_url += _T(":");
			m_url += cstr;
			CStringW2string(cstr, m_password, CP_ACP);
		}
		m_url += _T("@");
		m_editCloudServer.GetWindowTextW(cstr);
		m_url += cstr;
		m_url += _T(":");
		m_editCloudPort.GetWindowTextW(cstr);
		m_url += cstr;

		m_url += _T("/authen=");
		m_editDevUser.GetWindowTextW(cstr);
		m_url += cstr;
		m_editDevPwd.GetWindowTextW(cstr);
		if (cstr.IsEmpty() == false)
		{
			m_url += _T("&");
			m_url += cstr;
		}

		m_editcloudid.GetWindowTextW(cstr);
		m_url += _T("/cloudid=");
		m_url += cstr;
	}
	else
	{
		m_editDevUser.GetWindowTextW(cstr);
		CStringW2string(cstr, m_username, CP_ACP);
		m_editDevPwd.GetWindowTextW(cstr);
		CStringW2string(cstr, m_password, CP_ACP);

		m_editDevAddr.GetWindowTextW(cstr);
		CStringW2string(cstr, m_ip, CP_ACP);
		m_url += cstr;
		m_url += _T(":");
		m_editDevPort.GetWindowTextW(cstr);
		m_port = _ttoi(cstr.GetBuffer());
		m_url += cstr;
	}

	m_url += L"/hp=";
	m_hpPort.GetWindowTextW(cstr);
	m_url += cstr;

	return 0;
}

void CPlayback::OnSize(UINT nType, int cx, int cy)
{
	CDialogEx::OnSize(nType, cx, cy);

	// TODO:  ڴ˴Ϣ
	if (m_videoview != NULL)
	{
		CRect	rect;
		GetDlgItem(IDC_STATIC_PREVIEW)->GetWindowRect(&rect);
		rect.left = rect.right - rect.Width() / 4;
		rect.top = rect.bottom - rect.Height() / 4;

		ScreenToClient(&rect);
		m_videoview->MoveWindow(&rect);
	}
	AjustPreviewWnd();
	Invalidate(TRUE);
}
int CPlayback::OnStreamState(TDKU32 state, TDKS32 error)
{
	TRACE("Stream State = %d, error = %d\n", state, error);
	if (state == TDKSTATE_STREAM_STOP && error == TDK_OK)
	{
		TRACE("playback finished!\n");
	}
	return 0;
}
int CPlayback::callback_playback(void* context, TDKU32 cmd, void* param0, void* param1, void* param2)
{
	CPlayback* pthis = (CPlayback*)context;
	if (!pthis)
		return 0;
	if (cmd == TDKPLAYER_MSG_PACKET)
	{
		for (int i = 0; i < MAX_PLAYBACK_NUM; i++)
		{
			if (pthis->m_hPlayer[i] == param0)
			{
				int wnd = i;
				break;
			}
		}
		TDK_FRAMEHEAD* head = (TDK_FRAMEHEAD*)param1;
		TDKU8*	data = (TDKU8*)(head + 1);
		TRACE("Frame(%04d-%02d-%02d %02d:%02d:%02d.%03u), codec = %d, type = %d, fps = %.3f, len = %d, \
			  			  			  			  			(%02x %02x %02x %02x-%02x %02x %02x %02x) -----(%02x %02x %02x %02x %02x %02x %02x %02x)\n",
															head->tms.year + 2000, head->tms.month, head->tms.day,
															head->tms.hour, head->tms.minute, head->tms.second, head->ms,
															head->codec, head->prefix[3] - TDKFRAME_BASE, (float)(head->fps / 4.0), head->length,
															data[0], data[1], data[2], data[3], data[4], data[5], data[6], data[7],
															data[8], data[9], data[10], data[11], data[12], data[13], data[14], data[15]);
	}
	if (cmd == TDKPLAYER_MSG_FRAME)
	{
		TDK_PICTURE* pic = (TDK_PICTURE*)param1;
		if (pic)
		{
			int format = pic->format;
		}
	}
	if (cmd == TDKPLAYER_MSG_STATE)
	{
		pthis->OnStreamState((TDKU32)(size_t)param1, (TDKS32)(size_t)param2);
	}

	return TDK_OK;
}


void CPlayback::OnCbnSelchangeComboProtocol()
{
	// TODO:  ڴӿؼ֪ͨ
	int index = m_cbProtocol.GetCurSel();
	CString protocol;
	m_cbProtocol.GetLBText(index, protocol);
	if (protocol == L"tdk")
	{
		m_editDevAddr.EnableWindow(TRUE);
		m_editDevPort.EnableWindow(TRUE);
		m_editDevUser.EnableWindow(TRUE);
		m_editDevPwd.EnableWindow(TRUE);
		GetDlgItem(IDC_EDIT_IP2)->SetWindowTextW(m_cstrdevaddr);
		GetDlgItem(IDC_EDIT_PORT)->SetWindowTextW(L"34567");

		m_editCloudServer.EnableWindow(FALSE);
		m_editCloudPort.EnableWindow(FALSE);
		m_editcloudid.EnableWindow(FALSE);
		m_editCloudUser.EnableWindow(FALSE);
		m_editCloudPwd.EnableWindow(FALSE);

		m_hpPort.EnableWindow(TRUE);
	}
	else if (protocol == L"umsp" || protocol == L"tdks")//cloud
	{
		m_editDevAddr.EnableWindow(FALSE);
		m_editDevPort.EnableWindow(FALSE);

		m_editCloudServer.EnableWindow(TRUE);
		m_editCloudPort.EnableWindow(TRUE);
		m_editcloudid.EnableWindow(TRUE);
		m_editCloudUser.EnableWindow(TRUE);
		m_editCloudPwd.EnableWindow(TRUE);

		m_hpPort.EnableWindow(FALSE);
		CString cloudServer = L"";
		if (protocol == L"umsp")
		{
			cloudServer = "umspcloudserver";
		}
		else
		{
			cloudServer = "tdkscloudserver";
		}
		GetPrivateProfileString(cloudServer, L"addr", L"", m_cstrcloudserveraddr.GetBuffer(MAX_PATH), MAX_PATH, m_pathIniFIle);
		GetPrivateProfileString(cloudServer, L"user", L"", m_cstrcloudserveruser.GetBuffer(MAX_USERNAME_LEN), MAX_USERNAME_LEN, m_pathIniFIle);
		GetPrivateProfileString(cloudServer, L"pwd", L"", m_cstrcloudserverpwd.GetBuffer(MAX_PASSWORD_LEN), MAX_PASSWORD_LEN, m_pathIniFIle);
		GetPrivateProfileString(cloudServer, L"cloudid", L"", m_cstrcloudid.GetBuffer(MAX_PASSWORD_LEN), MAX_PASSWORD_LEN, m_pathIniFIle);
		unsigned int port = GetPrivateProfileInt(cloudServer, L"port", 0, m_pathIniFIle);
		CString strPort;
		strPort.Format(L"%d", port);
		m_editCloudPort.SetWindowText(strPort);
		m_editCloudServer.SetWindowText(m_cstrcloudserveraddr);
		m_editCloudUser.SetWindowText(m_cstrcloudserveruser);
		m_editCloudPwd.SetWindowText(m_cstrcloudserverpwd);
		m_editcloudid.SetWindowText(m_cstrcloudid);
	}
}

#define REC_FILE_FILTER				"mp4 Files (*.mp4)|*.mp4|dav Files (*.dav)|*.dav|avi Files (*.avi)|*.avi||"
void CPlayback::OnBnClickedButtonPlayback()
{
	// TODO:  ڴӿؼ֪ͨ	
	
}


void CPlayback::OnBnClickedButtonClose()
{
	// TODO:  ڴӿؼ֪ͨ
	if ( IsSync() )
	{
		stopAll();
	}
	else
	{
		stop(m_selwnd);
	}
	
	Invalidate();
}
int CPlayback::stopAll()
{
	for (int i = 0; i < MAX_PLAYBACK_NUM;i++)
	{
		stop(i);
	}
	TDKCBDelete(m_hcallback);
	m_hcallback = NULL;
	KillTimer(TIMER_PLAY_REMOTE);
	KillTimer(TIMER_PLAY_LOCAL);
	m_pTimeShaftDlg->ClearPos();
	return 0;
}

int CPlayback::stop(int wnd)
{
	if (m_hPlayer[wnd] == NULL)
		return 0;
	if (m_videoview)
	{
		m_videoview->SetPlayer(NULL);
	}
	TDKPlayer_Stop(m_hPlayer[wnd]);
	TDKPlayer_Close(m_hPlayer[wnd]);
	TDKPlayer_Detach(m_hPlayer[wnd], m_hcallback);
	TDKPlayer_Delete(m_hPlayer[wnd]);
	m_hPlayer[wnd] = NULL;
	m_blisten[wnd] = NULL;

	return 0;
}

void CPlayback::OnBnClickedButtonListen()
{
	// TODO:  ڴӿؼ֪ͨ

}


void CPlayback::OnBnClickedButtonSnap()
{
	// TODO:  ڴӿؼ֪ͨ

}


void CPlayback::OnBnClickedButtonPause()
{
	// TODO:  ڴӿؼ֪ͨ
	if (m_hPlayer == NULL) {
		return;
	}
	TDKPlayer_Pause(m_hPlayer[m_selwnd]);
}


void CPlayback::OnBnClickedButtonResume()
{
	// TODO:  ڴӿؼ֪ͨ
	if (m_hPlayer == NULL) {
		return;
	}
	TDKPlayer_Resume(m_hPlayer[m_selwnd]);
}


void CPlayback::OnBnClickedButtonFast1()
{
	// TODO:  ڴӿؼ֪ͨ
	TDKPlayer_SetSpeed(m_hPlayer[m_selwnd], TDKPLAYER_SPEED_NORMAL);	
}

void CPlayback::OnBnClickedButtonFast2()
{
	// TODO:  ڴӿؼ֪ͨ
	TDKPlayer_SetSpeed(m_hPlayer[m_selwnd], TDKPLAYER_SPEED_FAST2);
}


void CPlayback::OnBnClickedButtonFast4()
{
	// TODO:  ڴӿؼ֪ͨ
	TDKPlayer_SetSpeed(m_hPlayer[m_selwnd], TDKPLAYER_SPEED_FAST4);
}


void CPlayback::OnBnClickedButtonFast8()
{
	// TODO:  ڴӿؼ֪ͨ
	TDKPlayer_SetSpeed(m_hPlayer[m_selwnd], TDKPLAYER_SPEED_FAST8);
}


void CPlayback::OnBnClickedButtonShow2()
{
	// TODO:  ڴӿؼ֪ͨ
	TDKPlayer_SetSpeed(m_hPlayer[m_selwnd], TDKPLAYER_SPEED_SLOW2);
}


void CPlayback::OnBnClickedButtonSlow4()
{
	// TODO:  ڴӿؼ֪ͨ
	TDKPlayer_SetSpeed(m_hPlayer[m_selwnd], TDKPLAYER_SPEED_SLOW4);
}


void CPlayback::OnBnClickedButtonSlow8()
{
	// TODO:  ڴӿؼ֪ͨ
	TDKPlayer_SetSpeed(m_hPlayer[m_selwnd], TDKPLAYER_SPEED_SLOW8);
}
int CPlayback::SearchEvent()
{
	
	return TDK_OK;
}

void CPlayback::OnBnClickedButtonSearch()
{
	// TODO:  ڴӿؼ֪ͨ
	BeginWaitCursor();
	stopAll();
	m_list.DeleteAllItems();

	GetLoginInfo();

	int index = 0;
	int cnt = 0;
	m_chnmask = 0;
	for (int i = 0; i < m_ChnNum && cnt < MAX_PLAYBACK_NUM; i++)
	{
		if (m_listChn.GetCheck(i) <= 0)
		{
			continue;
		}
		m_chnmask |= ((unsigned long long)1 << i);
		cnt++;
	}
	if (m_chnmask == 0)
	{
		EndWaitCursor();
		MessageBox(_T("No select channel!\n"));
		return;
	}
	//ʱϢ
	for (int i = 0; i < MAX_PLAYBACK_NUM; i++)
	{
		std::list<TDK_FILE_INFO*>::iterator itr = m_filelist[i].begin();
		while (itr != m_filelist[i].end())
		{
			delete *itr;
			itr++;
		}
		m_filelist[i].clear();
	}
	m_vecChn.clear();
	m_pTimeShaftDlg->SetChnRange(m_vecChn);
	m_pTimeShaftDlg->SetFileInfo(NULL, 0, NULL);
	int type = (int)m_cbsearchrecordtype.GetItemData(m_cbsearchrecordtype.GetCurSel());
	if (type == 1 << TDKREC_EVENT)
	{
		SearchEvent();
		EndWaitCursor();
		return;
	}
	SYSTEMTIME date;
	((CDateTimeCtrl*)GetDlgItem(IDC_DATETIMEPICKER1))->GetTime(&date);

	SYSTEMTIME stStart;
	SYSTEMTIME stEnd;
	((CDateTimeCtrl*)GetDlgItem(IDC_DATETIMEPICKER2))->GetTime(&stStart);
	((CDateTimeCtrl*)GetDlgItem(IDC_DATETIMEPICKER4))->GetTime(&stEnd);


	memset(&m_search, 0, sizeof(m_search));
	int sel = m_cbsearchfiletype.GetCurSel();
	m_search.filetype = sel + 1;
	if (m_checksubstream.GetCheck())
	{
		m_search.streamtype = TDK_STREAM_SUB;
	}
	m_search.rectype = type;

	m_search.starttime.year = date.wYear;
	m_search.starttime.month = date.wMonth;
	m_search.starttime.day = date.wDay;
	m_search.starttime.hour = stStart.wHour;
	m_search.starttime.minute = stStart.wMinute;
	m_search.starttime.second = stStart.wSecond;

	m_search.endtime.year = date.wYear;
	m_search.endtime.month = date.wMonth;
	m_search.endtime.day = date.wDay;
	m_search.endtime.hour = stEnd.wHour;
	m_search.endtime.minute = stEnd.wMinute;
	m_search.endtime.second = stEnd.wSecond;	

	string strurl;
	CStringW2string(m_url, strurl, CP_ACP);
	TDK_FILE_INFO* presult = new TDK_FILE_INFO[2000];
	memset(presult, 0, sizeof(TDK_FILE_INFO)* 2000);
	if (m_cbPlaybackMode.GetCurSel() == 0)
	{
		cnt = 0;
		for (int i = 0; i < m_ChnNum; i++)
		{
			if (!(m_chnmask & ((unsigned long long)1 << i)))
			{
				continue;
			}
			m_search.chnmask0 = (unsigned long long)1<<i;
			m_filelist[cnt].clear();
			unsigned int resultcnt = 0;
			int ret = TDKMedia_Search(strurl.c_str(), m_username.c_str(),m_password.c_str(), &m_search, 2000, presult, &resultcnt);
			if (resultcnt > 0)
			{
				for (unsigned int i = 0; i < resultcnt; i++)
				{
					index++;
					CString strTmp;
					long lItem;
					strTmp.Format(_TEXT("%d"), index);
					lItem = m_list.InsertItem(m_list.GetItemCount(), strTmp, -1);

					strTmp.Format(_T("%d"), presult[i].channel + 1);
					m_list.SetItemText(lItem, 1, strTmp);

					strTmp.Format(_TEXT("%02d:%02d:%02d"),
						presult[i].starttime.hour, presult[i].starttime.minute, presult[i].starttime.second);
					m_list.SetItemText(lItem, 2, strTmp);

					strTmp.Format(_TEXT("%02d:%02d:%02d"),
						presult[i].endtime.hour, presult[i].endtime.minute, presult[i].endtime.second);
					m_list.SetItemText(lItem, 3, strTmp);

					strTmp.Format(_T("%d KB"), presult[i].size / 1024);
					m_list.SetItemText(lItem, 4, strTmp);
					//
					TDK_FILE_INFO* pfileinfo = new TDK_FILE_INFO;
					memcpy(pfileinfo, &presult[i], sizeof(TDK_FILE_INFO));
					m_list.SetItemData(lItem, (DWORD_PTR)pfileinfo);
					m_filelist[cnt].push_back(pfileinfo);
				}
			}
			cnt++;
		}
		SetTimeShaftFilesInfo();
	}
	else
	{
		//todo
	}
	delete[] presult;
	EndWaitCursor();
}
int CPlayback::SetTimeShaftFilesInfo()
{
	std::vector<FILEINFO> vecFileInfo;
	int lCount = 0;

	for (int i = 0, j = 0; i < m_ChnNum; i++)
	{
		if (!(m_chnmask & (unsigned long long)1<<i))
		{
			continue;
		}
		FILEINFO FileInfo;
		memset(&FileInfo, 0, sizeof(FileInfo));

		int index = 0;
		FileInfo.chn = i;
		if (m_filelist[j].empty())
		{
			j++;
			continue;
		}
		std::list<TDK_FILE_INFO*>::iterator itr = m_filelist[j].begin();
		for (itr; itr != m_filelist[j].end(); itr++)
		{
			FileInfo.num++;
			if (FileInfo.num > MAX_LIST_FILES)
			{
				vecFileInfo.push_back(FileInfo);
				lCount++;

				memset(&FileInfo, 0, sizeof(FileInfo));
				FileInfo.num++;
				index = 0;
				FileInfo.chn = i;
			}
			TDK_FILE_INFO* pfile = (TDK_FILE_INFO*)*itr;
			FileInfo.files[index].timebegin.year = pfile->starttime.year;
			FileInfo.files[index].timebegin.month = pfile->starttime.month;
			FileInfo.files[index].timebegin.day = pfile->starttime.day;
			FileInfo.files[index].timebegin.hour = pfile->starttime.hour;
			FileInfo.files[index].timebegin.minute = pfile->starttime.minute;
			FileInfo.files[index].timebegin.second = pfile->starttime.second;

			FileInfo.files[index].timeend.year = pfile->endtime.year;
			FileInfo.files[index].timeend.month = pfile->endtime.month;
			FileInfo.files[index].timeend.day = pfile->endtime.day;
			FileInfo.files[index].timeend.hour = pfile->endtime.hour;
			FileInfo.files[index].timeend.minute = pfile->endtime.minute;
			FileInfo.files[index].timeend.second = pfile->endtime.second;
			FileInfo.files[index].type = pfile->rectype;
			index++;
		}
		if (FileInfo.num > 0)
		{
			vecFileInfo.push_back(FileInfo);
			lCount++;

			CHNINFO chninfo;
			chninfo.text = "";
			chninfo.chnnum = i;
			m_vecChn.push_back(chninfo);//¼ļͨϢ
		}
		j++;
	}
	if ( lCount > 0 )
	{
		m_pTimeShaftDlg->SetChnRange(m_vecChn);
		SYSTEM_TIME stcurdate;
		stcurdate.year = m_search.starttime.year;
		stcurdate.month = m_search.starttime.month;
		stcurdate.day = m_search.starttime.day;
		m_pTimeShaftDlg->SetFileInfo(&stcurdate, lCount, &vecFileInfo[0]);
	}
	else
	{
		MessageBox(_T("No record files!"));
	}
	return 0;
}


int CPlayback::startByTime(int wnd, const TDK_SYSTEM_TIME* time)
{
	if (m_filelist[wnd].empty())
	{
		return TDK_FAIL;
	}
	int cnt = (int)m_filelist[wnd].size();
	TDK_FILE_INFO* infos = new TDK_FILE_INFO[cnt];
	std::list<TDK_FILE_INFO*>::iterator itr = m_filelist[wnd].begin();
	for (int i =0; i < cnt && itr != m_filelist[wnd].end(); itr++,i++)
	{
		memcpy(&infos[i], *itr, sizeof(TDK_FILE_INFO));
	}
	m_hPlayer[wnd] = TDKPlayer_Create(m_previewhwnd[wnd],1);
	if (!m_hcallback)
		m_hcallback = TDKCBCreate(this, (TDKCALLBACK)&callback_playback);
	TDKPlayer_Attach(m_hPlayer[wnd], m_hcallback);
	TDKPlayer_AttachDecode(m_hPlayer[wnd], m_hcallback);
	string strurl;
	CStringW2string(m_url, strurl, CP_ACP);
	int ret = TDKPlayer_OpenFile(m_hPlayer[wnd],strurl.c_str(),m_username.c_str(),m_password.c_str(),infos,cnt);
	ret = TDKPlayer_Start(m_hPlayer[wnd]);
	if ( time == NULL )
	{
		time = &infos[0].starttime;
	}
	//if ( m_checkSync.GetCheck() == false )
	{
		TDKPlayer_SeekTime(m_hPlayer[wnd], (TDK_SYSTEM_TIME*)time);
	}
	delete []infos;
	return ret;
}

int CPlayback::startByFile(int wnd, const TDK_FILE_INFO* file)
{
	if (m_filelist[wnd].empty() || !file)
	{
		return TDK_FAIL;
	}
	int cnt = (int)m_filelist[wnd].size();
	TDK_FILE_INFO* infos = new TDK_FILE_INFO[cnt];
	std::list<TDK_FILE_INFO*>::iterator itr = m_filelist[wnd].begin();
	for (int i = 0; i < cnt && itr != m_filelist[wnd].end(); itr++, i++)
	{
		memcpy(&infos[i], *itr, sizeof(TDK_FILE_INFO));
	}
	m_hPlayer[wnd] = TDKPlayer_Create(m_previewhwnd[wnd], 1);
	//m_hPlayer[wnd] = TDKPlayer_Create(NULL, 1);
	if (!m_hcallback)
		m_hcallback = TDKCBCreate(this, (TDKCALLBACK)&callback_playback);
	TDKPlayer_Attach(m_hPlayer[wnd], m_hcallback);
	TDKPlayer_AttachDecode(m_hPlayer[wnd], m_hcallback);
	string strurl;
	CStringW2string(m_url, strurl, CP_ACP);
	int ret = TDKPlayer_OpenFile(m_hPlayer[wnd], strurl.c_str(), m_username.c_str(), m_password.c_str(), infos, cnt);
	ret = TDKPlayer_Start(m_hPlayer[wnd]);
	//if (m_checkSync.GetCheck() == false)
	{
		TDKPlayer_SeekFile(m_hPlayer[wnd], (TDK_FILE_INFO*)file);
	}
	delete []infos;
	return ret;
}
void CPlayback::OnNMDblclkList1(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMITEMACTIVATE pNMItemActivate = reinterpret_cast<LPNMITEMACTIVATE>(pNMHDR);
	// TODO:  ڴӿؼ֪ͨ
	//stopAll();
	int index = -1;
	POSITION pos = m_list.GetFirstSelectedItemPosition();
	if (!pos)
	{
		return;
	}
	else
	{
		while (pos)
		{
			index = m_list.GetNextSelectedItem(pos);
		}
	}

	TDK_FILE_INFO* info = (TDK_FILE_INFO*)m_list.GetItemData(index);
	if (!info)
	{
		return;
	}
	for (int i = 0; i < MAX_PLAYBACK_NUM;i++)
	{
		if ( m_hPlayer[i] == NULL )
		{
			int ret = startByFile(i, info);
		}
		else
		{
			TDKPlayer_SeekFile(m_hPlayer[i], info);
		}		
	}

	SetTimer(TIMER_PLAY_REMOTE, 1000,NULL);
	*pResult = 0;
}

LRESULT CPlayback::StreamEnd(WPARAM p0, LPARAM p1)
{
	if ( p1 == 0 )
	{
// 		stop((HANDLE)p0);
// 		m_hPlayer = NULL;
		OnBnClickedButtonClose();
	}
	else
	{
		OnBnClickedButtonStopDown();
		MessageBox(_T("Download finish!"));
	}

	return 0;
}
LRESULT CPlayback::StreamStart(WPARAM p0, LPARAM p1)
{
	return 0;
}

void CPlayback::OnBnClickedButtonStep()
{
	// TODO:  ڴӿؼ֪ͨ
	TDKPlayer_Step(m_hPlayer[m_selwnd]);
}


void CPlayback::OnTimer(UINT_PTR nIDEvent)
{
	// TODO:  ڴϢ/Ĭֵ
	if (nIDEvent == TIMER_PLAY_REMOTE)
	{
		for (int i = 0, j = 0; i < MAX_PLAYBACK_NUM; i++)
		{
			if (m_hPlayer[i] != NULL)
			{
				unsigned int state = 0;
				int ret = TDKPlayer_GetState(m_hPlayer[i], &state);
				if (state&(1 << TDKSTATE_STREAM_STOP))
				{
					stop(i);
					m_pTimeShaftDlg->SeekPos(m_vecChn[j].chnnum, NULL);
					j++;
					continue;
				}
				TDK_SYSTEM_TIME playtime = {0};
				TDKPlayer_GetPlaybackTime(m_hPlayer[i], &playtime);
				m_pTimeShaftDlg->SeekPos(m_vecChn[j].chnnum, (const SYSTEM_TIME*)&playtime);
				j++;
				
			}
		}
	}
	__super::OnTimer(nIDEvent);
}


void CPlayback::OnBnClickedButtonDownload()
{
	// TODO:  ڴӿؼ֪ͨ

}
void CPlayback::OnBnClickedButtonStopDown()
{
	// TODO:  ڴӿؼ֪ͨ

}


void CPlayback::OnNMReleasedcaptureSlider1(NMHDR *pNMHDR, LRESULT *pResult)
{
	// TODO:  ڴӿؼ֪ͨ

	*pResult = 0;
}


void CPlayback::OnBnClickedButtonStepback()
{
	// TODO:  ڴӿؼ֪ͨ

}


void CPlayback::OnBnClickedButtonPlay()
{
	// TODO:  ڴӿؼ֪ͨ

}


void CPlayback::OnBnClickedButtonPlaySync()
{
	// TODO:  ڴӿؼ֪ͨ
	
}


void CPlayback::OnBnClickedButtonStopSync()
{
	// TODO:  ڴӿؼ֪ͨ
	
}


void CPlayback::OnBnClickedButtonSyncPause()
{
	// TODO:  ڴӿؼ֪ͨ

}


void CPlayback::OnBnClickedButtonSyncResume()
{
	// TODO:  ڴӿؼ֪ͨ

}


void CPlayback::OnStnClickedStaticPreview()
{
	// TODO:  ڴӿؼ֪ͨ
	m_selwnd = 0;
}


void CPlayback::OnLButtonDown(UINT nFlags, CPoint point)
{
	// TODO:  ڴϢ/Ĭֵ
	for (int i = 0; i < MAX_PLAYBACK_NUM;i++)
	{
		CRect rt;
		m_previewwnd[i]->GetWindowRect(&rt);
		ScreenToClient(&rt);
		BOOL  ret = rt.PtInRect(point);
		if ( ret )
		{
			m_selwnd = i;
			break;
		}
	}
	__super::OnLButtonDown(nFlags, point);
}

bool CPlayback::IsSync()
{

	return false;
}

void CPlayback::OnLButtonDblClk(UINT nFlags, CPoint point)
{
	// TODO:  ڴϢ/Ĭֵ
	if (m_rectPreviewWndZoomIn.PtInRect(point)) {
		m_bzoomin = !m_bzoomin;
		for (int i = 0; i < MAX_PLAYBACK_NUM; i++)
		{
			CRect rt;
			m_previewwnd[i]->GetWindowRect(&rt);
			ScreenToClient(&rt);
			BOOL  ret = rt.PtInRect(point);
			if (ret)
			{
				if (m_bzoomin)
				{
					m_selwnd = i;
					m_normalsize = rt;
					m_previewwnd[i]->MoveWindow(&m_rectPreviewWndZoomIn);
				}
				else
				{

					AjustPreviewWnd();
				}
			}
			else
			{
				if (m_bzoomin)
				{
					m_previewwnd[i]->ShowWindow(FALSE);
				}
				else
				{
					m_previewwnd[i]->ShowWindow(TRUE);
				}
			}
		}
		Invalidate(TRUE);
		__super::OnLButtonDblClk(nFlags, point);
	}
}


void CPlayback::OnBnClickedButtonCloseAll()
{
	// TODO:  ڴӿؼ֪ͨ
	stopAll();
	Invalidate();
}

void CPlayback::OnBnClickedButtonSeek()
{
	// TODO:  ڴӿؼ֪ͨ

	//ڲָ·¼
	/*
	BeginWaitCursor();
	stopAll();
	//m_list.DeleteAllItems();

	GetLoginInfo();

	int index = 0;
	//int cnt = 0;
	m_chnmask = 0;
	for (int i = 0; i < m_ChnNum ; i++)
	{
		if (i < 64) {        
			if (m_listChn.GetCheck(i) <= 0)
			{
				continue;
			}
			m_chnmask |= ((unsigned long long)1 << i);
			//cnt++;
		}
		else {    //жδ֧128λͨ
			if (m_listChn.GetCheck(i-64) <= 0)
			{
				continue;
			}
			//m_chnmask |= ((unsigned long long)1 << i
		}
		
	}
	if (m_chnmask == 0)
	{
		EndWaitCursor();
		MessageBox(_T("No select channel!\n"));
		return;
	}
	////ʱϢ
	//for (int i = 0; i < MAX_PLAYBACK_NUM; i++)
	//{
	//	std::list<TDK_FILE_INFO*>::iterator itr = m_filelist[i].begin();
	//	while (itr != m_filelist[i].end())
	//	{
	//		delete* itr;
	//		itr++;
	//	}
	//	m_filelist[i].clear();
	//}
	m_vecChn.clear();
	m_pTimeShaftDlg->SetChnRange(m_vecChn);
	m_pTimeShaftDlg->SetFileInfo(NULL, 0, NULL);
	int type = (int)m_cbsearchrecordtype.GetItemData(m_cbsearchrecordtype.GetCurSel());
	if (type == 1 << TDKREC_EVENT)
	{
		SearchEvent();
		EndWaitCursor();
		return;
	}
	SYSTEMTIME date;
	((CDateTimeCtrl*)GetDlgItem(IDC_DATETIMEPICKER1))->GetTime(&date);

	memset(&m_searchmonth, 0, sizeof(m_searchmonth));
	int sel = m_cbsearchfiletype.GetCurSel();
	//m_searchmonth.filetype = sel + 1;
	
	m_searchmonth.rectype = type;

	m_searchmonth.searchtime.year = date.wYear;
	m_searchmonth.searchtime.month = date.wMonth;
	

	string strurl;
	CStringW2string(m_url, strurl, CP_ACP);
	
	UINT mdaymask = 0;  //лطŵڵ
	if (m_cbPlaybackMode.GetCurSel() == 0)
	{
		//cnt = 0;
		//for (int i = 0; i < m_ChnNum; i++)
		//{
		//	if (!(m_chnmask & ((unsigned long long)1 << i)))
		//	{
		//		continue;
		//	}
		//	m_searchmonth.chnmask0 = (unsigned long long)1 << i;
		//	//m_filelist[cnt].clear();
		//	
		//	//cnt++;
		//}
		m_searchmonth.chnmask0 = m_chnmask;  //ǰ64λ
		//m_searchmonth.chnmask1 =            //ȴ128λЭ 

		UINT tempmask = 0;
		int resultcnt = TDKMediaGetSummary(strurl.c_str(), m_username.c_str(), m_password.c_str(), &m_searchmonth, (TDKU32*)& tempmask);
		if (resultcnt == 0)
		{
			mdaymask |= tempmask;
			//printf("mdaymask= %d\n", mdaymask);
		}
		if (mdaymask!= 0) {
			//
		}
	
		//SetTimeShaftFilesInfo();
	}
	else
	{
		//todo
	}
	
	EndWaitCursor();

	*/

}

int CPlayback::PlayBackByTime(int chn, TDK_SYSTEM_TIME* time)
{
	int index = 0;
	for (index; index < MAX_PLAYBACK_NUM; index++)
	{
		int ret = TDK_OK;
		if (m_hPlayer[index] == NULL)
		{
			ret = startByTime(index,time);
		}
		else if ( m_checkSync.GetCheck() == false)
		{
			if (m_vecChn[index].chnnum == chn)
			{
				TDKPlayer_SeekTime(m_hPlayer[index], time);
				break;
			}
		}
	}	
	SetTimer(TIMER_PLAY_REMOTE, 1000,NULL);
	return 0;
}

bool CPlayback::IsEditTextValid(int nID, int uID, const char* rgxStr)
{
	if (nID != uID)
		return false;
	CString text;
	GetDlgItemTextW(nID, text);
	std::regex regex(rgxStr);
	std::wstring wstr(text.GetBuffer());
	std::string str(wstr.begin(), wstr.end());
	if (!std::regex_match(str, regex))
		return true;
	return false;
}

void CALLBACK CPlayback::CBFunctionOfTimeShaft(int chn, SYSTEM_TIME* pst, unsigned long long pContext)
{
	CPlayback* pdlg = (CPlayback*)(DWORD_PTR)pContext;
	pdlg->PlayBackByTime(chn, (TDK_SYSTEM_TIME*)pst);
}
void CPlayback::OnBnClickedButton24()
{
	// TODO: ڴӿؼ֪ͨ
	m_pTimeShaftDlg->SetTimeRange(TimeShaftDlg::ESR_24HR, 0);
// 	m_btn24hr.SetSkin(1);
// 	m_btn2hr.SetSkin(0);
// 	m_btn1hr.SetSkin(0);
// 	m_btn30m.SetSkin(0);
}

void CPlayback::OnBnClickedButton2hr()
{
	// TODO: ڴӿؼ֪ͨ
	m_pTimeShaftDlg->SetTimeRange(TimeShaftDlg::ESR_2HR, m_selwnd);
// 	m_btn24hr.SetSkin(0);
// 	m_btn2hr.SetSkin(1);
// 	m_btn1hr.SetSkin(0);
// 	m_btn30m.SetSkin(0);
}

void CPlayback::OnBnClickedButton1hr()
{
	// TODO: ڴӿؼ֪ͨ
	m_pTimeShaftDlg->SetTimeRange(TimeShaftDlg::ESR_1HR, m_selwnd);
// 	m_btn24hr.SetSkin(0);
// 	m_btn2hr.SetSkin(0);
// 	m_btn1hr.SetSkin(1);
// 	m_btn30m.SetSkin(0);
}
void CPlayback::OnBnClickedButton30min()
{
	// TODO:  ڴӿؼ֪ͨ
	m_pTimeShaftDlg->SetTimeRange(TimeShaftDlg::ESR_30MIN, m_selwnd);
// 	m_btn24hr.SetSkin(0);
// 	m_btn2hr.SetSkin(0);
// 	m_btn1hr.SetSkin(0);
// 	m_btn30m.SetSkin(1);
}


void CPlayback::OnBnClickedButtonLogin()
{
	// TODO:  ڴӿؼ֪ͨ
	BeginWaitCursor();
	m_listChn.DeleteAllItems();
	GetLoginInfo();
	TDKHANDLE hdevice = TDKDevice_Create();
	if (hdevice == NULL)
	{
		EndWaitCursor();
		return;
	}
	std::string strurl;
	CStringW2string(m_url, strurl, CP_ACP);
	int ret = TDKDevice_OpenEx(hdevice, strurl.c_str(), m_username.c_str(), m_password.c_str());
	if (ret != TDK_OK)
	{
		TDKDevice_Delete(hdevice);
		EndWaitCursor();
		return;
	}
	TDK_DEVICE_INFO devinfo = { 0 };
	ret = TDKDevice_GetDeviceInfo(hdevice, &devinfo);
	if (ret != TDK_OK)
	{
		MessageBox(_T("ʧ!!"));
	}
	m_ChnNum = devinfo.analogchnnum + devinfo.digitalchnnum;
	TDKDevice_Close(hdevice);
	TDKDevice_Delete(hdevice);
	if (ret != TDK_OK)
	{
		EndWaitCursor();
		return;
	}
	CString cstr;
	for (int i = 0; i < m_ChnNum; i++)
	{
		cstr.Format(L"%d", i + 1);
		m_listChn.InsertItem(m_listChn.GetItemCount(), cstr);
	}
	//ʱϢ
	for (int i = 0; i < MAX_PLAYBACK_NUM; i++)
	{
		std::list<TDK_FILE_INFO*>::iterator itr = m_filelist[i].begin();
		while (itr != m_filelist[i].end())
		{
			delete* itr;
			itr++;
		}
		m_filelist[i].clear();
	}
	m_list.DeleteAllItems();
	stopAll();
	Invalidate();
	m_btnSearch.EnableWindow(TRUE);
	EndWaitCursor();
}


void CPlayback::OnBnClickedCheckAllChn()
{
	// TODO:  ڴӿؼ֪ͨ
	int check = m_chkAllChn.GetCheck();
	for (int i = 0; i < m_ChnNum; i++)
	{
		m_listChn.SetCheck(i, check);
	}
}


int CPlayback::AjustPreviewWnd()
{
	if (m_list.GetSafeHwnd() == NULL)
	{
		return 0;
	}
	CRect rect;
	GetDlgItem(IDC_STATIC_GROUP_SYSNC)->GetWindowRect(&rect);
	ScreenToClient(&rect);
	int top = rect.bottom + MARGIN;
	m_list.GetWindowRect(&rect);
	ScreenToClient(&rect);
	int left = rect.right + MARGIN;

	CRect dlgrect;
	GetClientRect(&dlgrect);
	m_rectPreviewWndZoomIn.left = left;
	m_rectPreviewWndZoomIn.top = top;
	m_rectPreviewWndZoomIn.right = dlgrect.right - MARGIN;
	m_rectPreviewWndZoomIn.bottom = dlgrect.bottom - MARGIN-145;
	if (m_bzoomin)
	{
		m_previewwnd[m_selwnd]->MoveWindow(&m_rectPreviewWndZoomIn);
	}
	else
	{
		int  sqrtnum = (int)sqrt(MAX_PLAYBACK_NUM);
		int width = (m_rectPreviewWndZoomIn.Width() - INTERVAL_WND*(sqrtnum - 1)) / sqrtnum;
		int height = (m_rectPreviewWndZoomIn.Height() - INTERVAL_WND*(sqrtnum - 1)) / sqrtnum;

		for (int i = 0; i < MAX_PLAYBACK_NUM; i++)
		{
			m_previewwnd[i]->MoveWindow((i%sqrtnum)*(width + INTERVAL_WND) + m_rectPreviewWndZoomIn.left, (i / sqrtnum)*(height + INTERVAL_WND) + m_rectPreviewWndZoomIn.top, width, height, TRUE);
			// 		g_dlgOutput[i].m_struCardPlayParam.nLeft = (i%iSqrtNum)*(width + INTERVAL_WND);
			// 		g_dlgOutput[i].m_struCardPlayParam.nTop = (i / iSqrtNum)*(iHeight + INTERVAL_WND);
			// 		g_dlgOutput[i].m_struCardPlayParam.nWidth = width;
			// 		g_dlgOutput[i].m_struCardPlayParam.nHeight = iHeight;
			m_previewwnd[i]->ShowWindow(SW_SHOW);
		}
	}

	RECT rt;
	rt.left = left;
	rt.top = m_rectPreviewWndZoomIn.bottom;
	rt.right = m_rectPreviewWndZoomIn.right;
	rt.bottom = rt.top + 20;
	m_staticFileName.MoveWindow(&rt);

	rt.left = left;
	rt.top = m_rectPreviewWndZoomIn.bottom+25;
	rt.right = rt.left + 50;
	rt.bottom = rt.top + 25;
	m_staticfilebegintime.MoveWindow(&rt);

	rt.left = rt.right;
	rt.top = m_rectPreviewWndZoomIn.bottom+20;
	rt.right = m_rectPreviewWndZoomIn.right - 50;
	rt.bottom = rt.top + 25;
	m_slider.MoveWindow(&rt);

	rt.left = rt.right;
	rt.top = m_rectPreviewWndZoomIn.bottom+25;
	rt.right = m_rectPreviewWndZoomIn.right;
	rt.bottom = rt.top + 25;
	m_staticfileendtime.MoveWindow(&rt);
	
	RECT timebarrt;
	timebarrt.left = left;
	timebarrt.top = rt.bottom;
	timebarrt.right = rt.right -50;
	timebarrt.bottom = timebarrt.top + 100;
	m_pTimeShaftDlg->MoveWindow(&timebarrt);
	m_pTimeShaftDlg->ShowWindow(TRUE);
	//
	rt.left = timebarrt.right;
	rt.top = rt.bottom;
	rt.right = rt.right;
	rt.bottom = rt.top + 25;
	m_btn24hr.MoveWindow(&rt);
	//
	rt.left = timebarrt.right;
	rt.top = rt.bottom;
	rt.right = rt.right;
	rt.bottom = rt.top + 25;
	m_btn2hr.MoveWindow(&rt);
	//
	rt.left = timebarrt.right;
	rt.top = rt.bottom;
	rt.right = rt.right;
	rt.bottom = rt.top + 25;
	m_btn1hr.MoveWindow(&rt);
	//
	rt.left = timebarrt.right;
	rt.top = rt.bottom;
	rt.right = rt.right;
	rt.bottom = rt.top + 25;
	m_btn30m.MoveWindow(&rt);

	m_list.GetWindowRect(&rect);
	ScreenToClient(&rect);
	m_listctrlevent.MoveWindow(&rect);
	return 0;
}

void CPlayback::OnBnClickedCheckSync()
{
	// TODO:  ڴӿؼ֪ͨ

}


void CPlayback::OnBnClickedButtonPre()
{
	// TODO:  ڴӿؼ֪ͨ
	if ( m_hPlayer[m_selwnd] == NULL )
	{
		return;
	}
	int ret = TDKPlayer_SeekPrevFile(m_hPlayer[m_selwnd]);
}


void CPlayback::OnBnClickedButtonNext()
{
	// TODO:  ڴӿؼ֪ͨ
	if (m_hPlayer[m_selwnd] == NULL)
	{
		return;
	}
	int ret = TDKPlayer_SeekNextFile(m_hPlayer[m_selwnd]);
}


void CPlayback::OnCbnSelchangeComboFileType()
{
	// TODO:  ڴӿؼ֪ͨ
	int sel = m_cbsearchfiletype.GetCurSel();
	m_filetype.EnableWindow(!sel);
}


void CPlayback::OnCbnSelchangeComboDisk()
{
	// TODO:  ڴӿؼ֪ͨ

}


void CPlayback::OnCbnSelchangeComboPlayMode()
{
	// TODO:  ڴӿؼ֪ͨ
	int ret = m_cbPlaybackMode.GetCurSel();
	if (ret == 0)
	{
		m_btnSearch.SetWindowTextW(_T("Search"));
	}
	else if (ret == 1)
	{
		m_btnSearch.SetWindowTextW(_T("Play"));
	}
}


void CPlayback::OnCbnSelchangeComboRecType()
{
	// TODO:  ڴӿؼ֪ͨ
	int type = (int)m_cbsearchrecordtype.GetItemData(m_cbsearchrecordtype.GetCurSel());
	if (type == 1 << TDKREC_EVENT)
	{
		m_list.ShowWindow(FALSE);
		m_listctrlevent.ShowWindow(TRUE);
	}
	else
	{
		m_list.ShowWindow(TRUE);
		m_listctrlevent.ShowWindow(FALSE);
	}
	m_list.DeleteAllItems();
	m_listctrlevent.DeleteAllItems();
}


void CPlayback::OnNMDblclkListEvent(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMITEMACTIVATE pNMItemActivate = reinterpret_cast<LPNMITEMACTIVATE>(pNMHDR);
	// TODO:  ڴӿؼ֪ͨ

	*pResult = 0;
}
