// Maintain.cpp : ʵļ
//

#include "stdafx.h"
#include "SDKDemo.h"
#include "Maintain.h"
#include "afxdialogex.h"
#include "RemoteConfig.h"
#include <string>
using namespace std;

#define  TIMER_UPGRADE 0
// CMaintain Ի

IMPLEMENT_DYNAMIC(CMaintain, CDialogEx)

CMaintain::CMaintain(CWnd* pParent /*=NULL*/)
	: CDialogEx(CMaintain::IDD, pParent)
{
	m_hDevice = NULL;
}

CMaintain::~CMaintain()
{
}

void CMaintain::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(CMaintain, CDialogEx)
	ON_BN_CLICKED(IDC_BUTTON_IMPORT, &CMaintain::OnBnClickedButtonImport)
	ON_BN_CLICKED(IDC_BUTTON_EXPORT, &CMaintain::OnBnClickedButtonExport)
	ON_BN_CLICKED(IDC_BUTTON_FILE, &CMaintain::OnBnClickedButtonFile)
	ON_BN_CLICKED(IDC_BUTTON_START, &CMaintain::OnBnClickedButtonStart)
	ON_WM_TIMER()
	ON_MESSAGE(TDKDEVICE_MSG_UPGRADE_PROGRESS, &CMaintain::OnUpgrade)
END_MESSAGE_MAP()


// CMaintain Ϣ
int CMaintain::OpenFileDialog(TCHAR* filter, BOOL bOpen)
{
	CFileDialog dlgFile(bOpen, L"coi", NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, filter, this);
	if (IDCANCEL == dlgFile.DoModal())
	{
		return -1;
	}
	CString pathname = dlgFile.GetPathName();
	if (pathname.IsEmpty())
	{
		return -1;
	}

	memset(m_pathname, 0, sizeof(m_pathname));
	WideCharToMultiByte(CP_ACP, 0, pathname.GetBuffer(0), -1, m_pathname, 256, NULL, NULL);//wstring to string
	return 0;
}

void CMaintain::OnBnClickedButtonImport()
{
	// TODO:  ڴӿؼ֪ͨ
	int ret = OpenFileDialog(L"coi Files(*.coi)|*.coi||");
	if (ret != 0)
		return;
	ret = MessageBox(L"Importing a configuration file requires a device restart. Do you want to continue?", NULL, MB_ICONQUESTION | MB_YESNO);
	if (ret == IDNO)
		return;
	string ip, username, password;
	//TDKU16 port;
	CString url = ((CRemoteConfig*)(GetParent()))->GetLoginInfo(username, password);
	TDKHANDLE hdevice = TDKDevice_Create();
	if (hdevice == NULL)
	{
		return;
	}
	std::string strurl;
	CStringW2string(url, strurl, CP_ACP);
	ret = TDKDevice_OpenEx(hdevice, strurl.c_str(), username.c_str(), password.c_str());
	if (ret != TDK_OK)
	{
		TDKDevice_Delete(hdevice);
		return;
	}
	((CRemoteConfig*)(GetParent()))->EnableWindow(FALSE);
	ret = TDKDevice_ImportConfig(hdevice, m_pathname);
	((CRemoteConfig*)(GetParent()))->EnableWindow(TRUE);
	if (ret != TDK_OK)
	{
		AfxMessageBox(L"Import failure");
		//return;
	}
	else
		AfxMessageBox(L"Import success");
	TDKDevice_Close(hdevice);
	TDKDevice_Delete(hdevice);
}


void CMaintain::OnBnClickedButtonExport()
{
	// TODO:  ڴӿؼ֪ͨ
	int ret = OpenFileDialog(L"coi Files(*.coi)|*.coi||", FALSE);
	if (ret != 0)
		return;
	string ip, username, password;
	//TDKU16 port;
	CString url = ((CRemoteConfig*)(GetParent()))->GetLoginInfo(username,password);
	TDKHANDLE hdevice = TDKDevice_Create();
	if ( hdevice == NULL )
	{
		return;
	}
	std::string strurl;
	CStringW2string(url, strurl, CP_ACP);
	ret = TDKDevice_OpenEx(hdevice, strurl.c_str(), username.c_str(), password.c_str());
	if (ret != TDK_OK)
	{
		TDKDevice_Delete(hdevice);
		return;
	}
	ret = TDKDevice_ExportConfig(hdevice, m_pathname);
	if (ret != TDK_OK)
	{
		AfxMessageBox(L"Export failure");
		//return;
	}
	else
		AfxMessageBox(L"Export success");
	TDKDevice_Close(hdevice);
	TDKDevice_Delete(hdevice);
}


void CMaintain::OnBnClickedButtonFile()
{
	// TODO:  ڴӿؼ֪ͨ
	int ret = OpenFileDialog(L"upf Files(*.upf)|*.upf||");
	if (ret != 0)
		return;
	CString cstr;
	cstr = m_pathname;
	GetDlgItem(IDC_EDIT_UPGRADE)->SetWindowTextW(cstr);
}
LRESULT CMaintain::OnUpgrade(WPARAM p0, LPARAM p1)
{
	int finished = (int)p0;
	CString gradeinfo;
	if (finished == 100 || finished == -1)
	{
		if (finished == 100)
		{
			gradeinfo += L"Upgrade success";
		}
		else if (finished == -1)
		{
			gradeinfo += L"Upgrade failure";
		}
		GetDlgItem(IDC_STATIC_UPGRADE)->SetWindowTextW(gradeinfo);
		((CRemoteConfig*)(GetParent()))->EnableWindow(TRUE);
		TDKDevice_Close(m_hDevice);
		TDKDevice_Delete(m_hDevice);
		m_hDevice = NULL;
		TDKCBDelete(m_cbUpGrade);
		m_cbUpGrade = NULL;
		AfxMessageBox(gradeinfo);
	}
	else
	{
		gradeinfo.Format(_T("Upgrade progress: %02d%s"), finished, "%");
		GetDlgItem(IDC_STATIC_UPGRADE)->SetWindowTextW(gradeinfo);
	}
	return 0;
}
int CMaintain::callback_upgrade(void* context, TDKU32 cmd, void* param0, void* param1, void* param2)
{
	CMaintain* pthis = (CMaintain*)context;
	if (cmd != TDKDEVICE_MSG_UPGRADE_PROGRESS)
		return TDK_OK;
	pthis->PostMessage(cmd, (WPARAM)param1, (LPARAM)param2);
	return TDK_OK;
}
void CMaintain::OnBnClickedButtonStart()
{
	// TODO:  ڴӿؼ֪ͨ
	if (strlen(m_pathname) == 0)
		return;
	string ip, username, password;
	//TDKU16 port;
	CString url = ((CRemoteConfig*)(GetParent()))->GetLoginInfo(username, password);
	m_hDevice = TDKDevice_Create();
	if (m_hDevice == NULL)
	{
		return;
	}
	std::string strurl;
	CStringW2string(url, strurl, CP_ACP);
	int ret = TDKDevice_OpenEx(m_hDevice, strurl.c_str(), username.c_str(), password.c_str());
	if (ret != TDK_OK)
	{
		TDKDevice_Delete(m_hDevice);
		m_hDevice = NULL;
		return;
	}
	if (!m_cbUpGrade)
		m_cbUpGrade = TDKCBCreate(this, (TDKCALLBACK)&callback_upgrade);
	ret = TDKDevice_Upgrade(m_hDevice, m_pathname,m_cbUpGrade);
	if (ret != TDK_OK)
	{
		TDKDevice_Close(m_hDevice);
		TDKDevice_Delete(m_hDevice);
		m_hDevice = NULL;
		TDKCBDelete(m_cbUpGrade);
		m_cbUpGrade = NULL;
		AfxMessageBox(L"Device upgrade failure");
		return;
	}
	((CRemoteConfig*)(GetParent()))->EnableWindow(FALSE);
}


void CMaintain::OnTimer(UINT_PTR nIDEvent)
{
	// TODO:  ڴϢ/Ĭֵ
	
	CDialogEx::OnTimer(nIDEvent);
}
