// Alarm.cpp : ʵļ
//

#include "stdafx.h"
#include "SDKDemo.h"
#include "Alarm.h"
#include "afxdialogex.h"
#include <regex>

using namespace std;
// CAlarm Ի

IMPLEMENT_DYNAMIC(CAlarm, CDialogEx)

std::list<TDK_ALARM_INFO_CHN> CAlarm::m_listInfoAlarm;

CAlarm::CAlarm(CWnd* pParent /*=NULL*/)
	: CDialogEx(CAlarm::IDD, pParent)
{
	m_hDevice = NULL;
	m_hAlarm = NULL;
	m_hcallback = NULL;
	m_hCBSnapshot = NULL;
	m_hSnapshot = NULL;
}

CAlarm::~CAlarm()
{
}

void CAlarm::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COMBO_PROTOCOL, m_cbProtocol);
	DDX_Control(pDX, IDC_EDIT_CLOUDID, m_editcloudid);
	DDX_Control(pDX, IDC_LIST1, m_alarmlist);
	DDX_Control(pDX, IDC_EDIT_PORT_HTTP, m_hpPort);
	DDX_Control(pDX, IDC_EDIT_USERNAME_CLOUD, m_editCloudUser);
	DDX_Control(pDX, IDC_EDIT_SERVER_CLOUD2, m_editCloudServer);
	DDX_Control(pDX, IDC_EDIT_PWD_CLOUD, m_editCloudPwd);
	DDX_Control(pDX, IDC_EDIT_PORT_CLOUD2, m_editCloudPort);
	DDX_Control(pDX, IDC_EDIT_IP, m_editDevAddr);
	DDX_Control(pDX, IDC_EDIT_PORT, m_editDevPort);
	DDX_Control(pDX, IDC_EDIT_USERNAME, m_editDevUser);
	DDX_Control(pDX, IDC_EDIT_PWD, m_editDevPwd);
}

BOOL CAlarm::OnCommand(WPARAM wParam, LPARAM lParam)
{
	UINT code = HIWORD(wParam);
	HWND hwnd = (HWND)(lParam);
	UINT unid = LOWORD(wParam);
	if (code == EN_KILLFOCUS && IsWindowVisible())
	{
		auto addrRgx = "(?:[1-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(?:\\.(?:[1-9]?[0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}";
		auto portRgx = "(?:[0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4]{4}|65[0-4]{2}|655[0-2]|6553[0-5])";
		if (IsEditTextValid(IDC_EDIT_IP, unid, addrRgx))
		{
			MessageBox(_T("DevAddr text is illegal!"));
			GetDlgItem(IDC_EDIT_IP)->SetFocus();
		}
		else if (IsEditTextValid(IDC_EDIT_PORT, unid, portRgx))
		{
			MessageBox(_T("Port text is illegal!"));
			GetDlgItem(IDC_EDIT_PORT)->SetFocus();
		}
		else if (IsEditTextValid(IDC_EDIT_PORT_HTTP, unid, portRgx))
		{
			MessageBox(_T("Http Port text is illegal!"));
			GetDlgItem(IDC_EDIT_PORT_HTTP)->SetFocus();
		}
		else if (IsEditTextValid(IDC_EDIT_PORT_CLOUD2, unid, portRgx))
		{
			MessageBox(_T("Port text is illegal!"));
			GetDlgItem(IDC_EDIT_PORT_CLOUD2)->SetFocus();
		}
	}
	return CDialogEx::OnCommand(wParam, lParam);
}


BEGIN_MESSAGE_MAP(CAlarm, CDialogEx)
	ON_BN_CLICKED(IDC_BUTTON_START, &CAlarm::OnBnClickedButtonStart)
	ON_CBN_SELCHANGE(IDC_COMBO_PROTOCOL, &CAlarm::OnCbnSelchangeComboProtocol)
	ON_BN_CLICKED(IDC_BUTTON_STOP, &CAlarm::OnBnClickedButtonStop)
	ON_BN_CLICKED(IDC_BUTTON_CLEAR, &CAlarm::OnBnClickedButtonClear)
	//ON_BN_CLICKED(IDC_BUTTON_ALARM_SNAPSHOT_UPLOAD, &CAlarm::OnBnClickedButtonAlarmSnapshotUpload)
	//ON_BN_CLICKED(IDC_BUTTON_ALARM_SNAPSHOT_UPLOAD2, &CAlarm::OnBnClickedButtonAlarmSnapshotUpload2)
END_MESSAGE_MAP()


// CAlarm Ϣ

BOOL CAlarm::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// TODO:  ڴӶĳʼ
	LoadLoginInfo();

	m_cbProtocol.AddString(L"tdk");
	m_cbProtocol.AddString(L"umsp");
	m_cbProtocol.AddString(L"tdks");
	m_cbProtocol.SetCurSel(0);
	OnCbnSelchangeComboProtocol();

	m_alarmlist.InsertColumn(0, _T("time"), LVCFMT_LEFT, 150);
	m_alarmlist.InsertColumn(1, _T("alarm type"), LVCFMT_LEFT, 200);
	m_alarmlist.InsertColumn(2, _T("chn / index"), LVCFMT_LEFT, 80);
	m_alarmlist.InsertColumn(3, _T("status"), LVCFMT_LEFT, 100);
	m_alarmlist.SetExtendedStyle(m_alarmlist.GetExtendedStyle() | LVS_EX_FULLROWSELECT  | LVS_EX_GRIDLINES | LVS_EX_SUBITEMIMAGES);

	SetAlarmDesc();
	return TRUE;  // return TRUE unless you set the focus to a control
	// 쳣:  OCX ҳӦ FALSE
}

int CAlarm::LoadLoginInfo()
{
	char		path[1024];
	path[0] = '\0';
	HMODULE hModule = GetModuleHandleA("TDKSDK.dll");
	GetModuleFileNameA(hModule, path, 1024);
	size_t	len = strlen(path) - strlen("TDKSDK.dll");
	path[len] = '\0';
	m_pathIniFIle = path;
	m_pathIniFIle += "ServerInfo.ini";

	CString cstrport;
	GetPrivateProfileString(L"umspcloudserver", L"addr", L"", m_cstrcloudserveraddr.GetBuffer(MAX_PATH), MAX_PATH, m_pathIniFIle);
	m_cloudserverport = GetPrivateProfileInt(L"umspcloudserver", L"port", 0, m_pathIniFIle);
	GetPrivateProfileString(L"umspcloudserver", L"user", L"", m_cstrcloudserveruser.GetBuffer(MAX_USERNAME_LEN), MAX_USERNAME_LEN, m_pathIniFIle);
	GetPrivateProfileString(L"umspcloudserver", L"pwd", L"", m_cstrcloudserverpwd.GetBuffer(MAX_PASSWORD_LEN), MAX_PASSWORD_LEN, m_pathIniFIle);
	GetPrivateProfileString(L"umspcloudserver", L"cloudid", L"", m_cstrcloudid.GetBuffer(MAX_PASSWORD_LEN), MAX_PASSWORD_LEN, m_pathIniFIle);
	m_editCloudServer.SetWindowText(m_cstrcloudserveraddr);
	cstrport.Format(L"%d", m_cloudserverport);
	m_editCloudPort.SetWindowText(cstrport);
	m_editCloudUser.SetWindowText(m_cstrcloudserveruser);
	m_editCloudPwd.SetWindowText(m_cstrcloudserverpwd);
	m_editcloudid.SetWindowText(m_cstrcloudid);

	GetPrivateProfileString(L"device", L"addr", L"", m_cstrdevaddr.GetBuffer(MAX_PATH), MAX_PATH, m_pathIniFIle);
	m_devport = GetPrivateProfileInt(L"device", L"port", 0, m_pathIniFIle);
	GetPrivateProfileString(L"device", L"user", L"", m_cstrdevuser.GetBuffer(MAX_USERNAME_LEN), MAX_USERNAME_LEN, m_pathIniFIle);
	GetPrivateProfileString(L"device", L"pwd", L"", m_cstrdevpwd.GetBuffer(MAX_PASSWORD_LEN), MAX_PASSWORD_LEN, m_pathIniFIle);
	m_editDevAddr.SetWindowText(m_cstrdevaddr);
	cstrport.Format(L"%d", m_devport);
	m_editDevPort.SetWindowText(cstrport);
	m_editDevUser.SetWindowText(m_cstrdevuser);
	m_editDevPwd.SetWindowText(m_cstrdevpwd);

	unsigned int httpPort = GetPrivateProfileInt(L"device", L"httpport", 0, m_pathIniFIle);
	cstrport.Format(L"%d", httpPort);
	m_hpPort.SetWindowText(cstrport);
	return 0;
}
int CAlarm::SetAlarmDesc()
{
	m_alarmdesc.clear();
	CString str;
	str = "Input alarm";
	m_alarmdesc.insert(std::map<int, CString>::value_type(TDKALARM_PORT_ALARMIN, str));
	str = "motion detect  alarm";
	m_alarmdesc.insert(std::map<int, CString>::value_type(TDKALARM_MOTION, str));
	str = "video lost alarm";
	m_alarmdesc.insert(std::map<int, CString>::value_type(TDKALARM_VIDEOLOST, str));
	str = "shelter alarm";
	m_alarmdesc.insert(std::map<int, CString>::value_type(TDKALARM_SHELTER, str));
	str = "disk full alarm";
	m_alarmdesc.insert(std::map<int, CString>::value_type(TDKALARM_DISKFULL, str));
	str = "disk error alarm";
	m_alarmdesc.insert(std::map<int, CString>::value_type(TDKALARM_DISKERROR, str));
	str = "no disk alarm";
	m_alarmdesc.insert(std::map<int, CString>::value_type(TDKALARM_NO_DISK, str));
	str = "IP conflict alarm";
	m_alarmdesc.insert(std::map<int, CString>::value_type(TDKALARM_IP_CONFLICT, str));
	str = "HDD S.M.A.R.T alarm";
	m_alarmdesc.insert(std::map<int, CString>::value_type(TDKALARM_HDD_SMART, str));

	str = "Region Entrance alarm";
	m_alarmdesc.insert(std::map<int, CString>::value_type(TDKALARM_REGION_ENTRANCE, str));
	str = "Region Exiting alarm";
	m_alarmdesc.insert(std::map<int, CString>::value_type(TDKALARM_REGION_EXIT, str));
	str = "Fast Moving alarm";
	m_alarmdesc.insert(std::map<int, CString>::value_type(TDKALARM_FAST_MOVE, str));
	str = "Unattended Object alarm";
	m_alarmdesc.insert(std::map<int, CString>::value_type(TDKALARM_OBJECT_UNATTEND, str));
	str = "Object Missing alarm";
	m_alarmdesc.insert(std::map<int, CString>::value_type(TDKALARM_OBJECT_MISS, str));
	str = "Face Detection alarm";
	m_alarmdesc.insert(std::map<int, CString>::value_type(TDKALARM_FACE_DETECT, str));
	str = "Loitering Detection alarm";
	m_alarmdesc.insert(std::map<int, CString>::value_type(TDKALARM_LOITER_DETECT, str));
	str = "Parking Detection alarm";
	m_alarmdesc.insert(std::map<int, CString>::value_type(TDKALARM_PARK_DETECT, str));
	str = "People Gathering Detection alarm";
	m_alarmdesc.insert(std::map<int, CString>::value_type(TDKALARM_PEOPLE_GATHER, str));

	str = "Cross line alarm";
	m_alarmdesc.insert(std::map<int, CString>::value_type(TDKALARM_CROSSLINE, str));
	str = "Area Intrusion alarm";
	m_alarmdesc.insert(std::map<int, CString>::value_type(TDKALARM_AREA_INTRUSION, str));
	return 0;
}
CString CAlarm::GetAlarmDesc(int key)
{
	std::map<int, CString>::const_iterator itfind = m_alarmdesc.find(key);
	if (itfind == m_alarmdesc.end())
	{
		return L"Unknow";
	}
	return itfind->second;
}
int CAlarm::GetLoginInfo()
{
	m_url.Empty();
	std::string str;
	CString cstr;

	CString protocol;
	int index = m_cbProtocol.GetCurSel();
	m_cbProtocol.GetLBText(index, protocol);
	m_url += protocol;

	m_url += _T("://");
	if (protocol == L"tdks" || protocol == L"umsp")
	{
		//	p2p
		//	tdks://[clouduser:cloudpass@]cloud_domain:cloud_port/authen=devusr&devpass/cloudid=umksxxxxxxxx/hp=httpPort";
		m_editCloudUser.GetWindowTextW(cstr);
		m_url += cstr;
		CStringW2string(cstr, m_username, CP_ACP);
		m_editCloudPwd.GetWindowTextW(cstr);
		if (cstr.IsEmpty() == false)
		{
			m_url += _T(":");
			m_url += cstr;
			CStringW2string(cstr, m_password, CP_ACP);
		}
		m_url += _T("@");
		m_editCloudServer.GetWindowTextW(cstr);
		m_url += cstr;
		m_url += _T(":");
		m_editCloudPort.GetWindowTextW(cstr);
		m_url += cstr;

		m_url += _T("/authen=");
		m_editDevUser.GetWindowTextW(cstr);
		m_url += cstr;
		m_editDevPwd.GetWindowTextW(cstr);
		if (cstr.IsEmpty() == false)
		{
			m_url += _T("&");
			m_url += cstr;
		}

		m_editcloudid.GetWindowTextW(cstr);
		m_url += _T("/cloudid=");
		m_url += cstr;
	}
	else
	{
		m_editDevUser.GetWindowTextW(cstr);
		CStringW2string(cstr, m_username, CP_ACP);
		m_editDevPwd.GetWindowTextW(cstr);
		CStringW2string(cstr, m_password, CP_ACP);

		m_editDevAddr.GetWindowTextW(cstr);
		CStringW2string(cstr, m_ip, CP_ACP);
		m_url += cstr;
		m_url += _T(":");
		m_editDevPort.GetWindowTextW(cstr);
		m_port = _ttoi(cstr.GetBuffer());
		m_url += cstr;
	}
	m_url += L"/hp=";
	m_hpPort.GetWindowTextW(cstr);
	m_url += cstr;

	return 0;
}

bool CAlarm::IsEditTextValid(int nID, int uID, const char* rgxStr)
{
	if (nID != uID)
		return false;
	CString text;
	GetDlgItemTextW(nID, text);
	std::regex regex(rgxStr);
	std::wstring wstr(text.GetBuffer());
	std::string str(wstr.begin(), wstr.end());
	if (!std::regex_match(str, regex))
		return true;
	return false;
}

void CAlarm::OnCbnSelchangeComboProtocol()
{
	// TODO:  ڴӿؼ֪ͨ
	CString protocol;
	m_cbProtocol.GetLBText(m_cbProtocol.GetCurSel(), protocol);
	if (protocol == L"tdk")
	{
		m_editDevAddr.EnableWindow(TRUE);
		m_editDevPort.EnableWindow(TRUE);
		m_editDevUser.EnableWindow(TRUE);
		m_editDevPwd.EnableWindow(TRUE);

		m_editCloudServer.EnableWindow(FALSE);
		m_editCloudPort.EnableWindow(FALSE);
		m_editcloudid.EnableWindow(FALSE);
		m_editCloudUser.EnableWindow(FALSE);
		m_editCloudPwd.EnableWindow(FALSE);

		m_hpPort.EnableWindow(TRUE);
	}
	else if (protocol == L"umsp" || protocol == L"tdks")//cloud
	{
		m_editDevAddr.EnableWindow(FALSE);
		m_editDevPort.EnableWindow(FALSE);

		m_editCloudServer.EnableWindow(TRUE);
		m_editCloudPort.EnableWindow(TRUE);
		m_editcloudid.EnableWindow(TRUE);
		m_editCloudUser.EnableWindow(TRUE);
		m_editCloudPwd.EnableWindow(TRUE);

		m_hpPort.EnableWindow(FALSE);
		CString cloudServer = L"";
		if (protocol == L"umsp")
		{
			cloudServer = "umspcloudserver";
		}
		else
		{
			cloudServer = "tdkscloudserver";
		}
		GetPrivateProfileString(cloudServer, L"addr", L"", m_cstrcloudserveraddr.GetBuffer(MAX_PATH), MAX_PATH, m_pathIniFIle);
		GetPrivateProfileString(cloudServer, L"user", L"", m_cstrcloudserveruser.GetBuffer(MAX_USERNAME_LEN), MAX_USERNAME_LEN, m_pathIniFIle);
		GetPrivateProfileString(cloudServer, L"pwd", L"", m_cstrcloudserverpwd.GetBuffer(MAX_PASSWORD_LEN), MAX_PASSWORD_LEN, m_pathIniFIle);
		GetPrivateProfileString(cloudServer, L"cloudid", L"", m_cstrcloudid.GetBuffer(MAX_PASSWORD_LEN), MAX_PASSWORD_LEN, m_pathIniFIle);
		unsigned int port = GetPrivateProfileInt(cloudServer, L"port", 0, m_pathIniFIle);
		CString strPort;
		strPort.Format(L"%d", port);
		m_editCloudPort.SetWindowText(strPort);
		m_editCloudServer.SetWindowText(m_cstrcloudserveraddr);
		m_editCloudUser.SetWindowText(m_cstrcloudserveruser);
		m_editCloudPwd.SetWindowText(m_cstrcloudserverpwd);
		m_editcloudid.SetWindowText(m_cstrcloudid);
	}
}

void CAlarm::OnBnClickedButtonStart()
{
	// TODO:  ڴӿؼ֪ͨ
	if (m_hAlarm) {
		MessageBox(L"Alarm is opening,please close it first!");
		return;
	}
	BeginWaitCursor();
	GetLoginInfo();
	m_hAlarm = TDKAlarm_Create();
	if (!m_hcallback)
		m_hcallback = TDKCBCreate(this, (TDKCALLBACK)&callback_alarm);
	TDKAlarm_Attach(m_hAlarm, m_hcallback);
	std::string strurl;
	CStringW2string(m_url, strurl, CP_ACP);
	int ret = TDKAlarm_Open(m_hAlarm, strurl.c_str(), m_username.c_str(), m_password.c_str());
	EndWaitCursor();
	if (ret != TDK_OK)
	{
		MessageBox(L"Open alarm failed!!!");
		m_hAlarm = NULL;
	}
	else {
		MessageBox(L"Open alarm OK!!!");
	}
	TRACE("Open alarm OK!!!\n");
}

void CAlarm::OnBnClickedButtonStop()
{
	// TODO:  ڴӿؼ֪ͨ
	if (m_hAlarm)
	{
		TDKAlarm_Close(m_hAlarm);
		TDKAlarm_Detach(m_hAlarm, m_hcallback);
		TDKAlarm_Delete(m_hAlarm);
		TDKCBDelete(m_hcallback);
		m_hcallback = NULL;
		m_hAlarm = NULL;
		MessageBox(L"Stop alarm OK!!!");
	}
	
}

int CAlarm::OnDealAlarm(TDK_ALARM_INFO_CHN* alarm)
{
	bool alarmEvent = false;
	if (alarm->status == 1)
	{
		if (alarm->type == TDKALARM_DISKERROR
			|| alarm->type == TDKALARM_HDD_SMART
			|| alarm->type == TDKALARM_DISKFULL
			|| alarm->type == TDKALARM_NO_DISK
			|| alarm->type == TDKALARM_IP_CONFLICT)
		{

		}
		else
		{
			m_listInfoAlarm.push_back(*alarm);
			alarmEvent = true;
		}
	}
	else if (m_listInfoAlarm.size() > 0)
	{
		list<TDK_ALARM_INFO_CHN>::iterator itr = m_listInfoAlarm.begin();
		for (itr; itr != m_listInfoAlarm.end(); itr++)
		{
			TDK_ALARM_INFO_CHN alarmChn = (TDK_ALARM_INFO_CHN)(*itr);
			if (alarmChn.chn == alarm->chn
				&& alarmChn.type == alarm->type
				&& alarmChn.number == alarm->number
				&& alarmChn.status != alarm->status)
			{
				m_listInfoAlarm.erase(itr);
				alarmEvent = true;
				break;
			}

		}
	}

	if (!alarmEvent)
		return 0;

	CString str;
	SYSTEMTIME systime;
	GetLocalTime(&systime);
	str.Empty();
	str.Format(L"%d-%d-%d %02d:%02d:%02d", systime.wYear, systime.wMonth, systime.wDay, systime.wHour, systime.wMinute, systime.wSecond);
	int Item = m_alarmlist.InsertItem(0, str);

	TDKU16 type = alarm->type;

	m_alarmlist.SetItemText(Item, 1, GetAlarmDesc(type));

	switch (type)
	{
	case TDKALARM_PORT_ALARMIN:
	case TDKALARM_VIDEOLOST:
	case TDKALARM_DISKERROR:
	case TDKALARM_HDD_SMART:
	{
		str.Format(L"%d", alarm->chn + 1);
	}
	break;
	case TDKALARM_DISKFULL:
	case TDKALARM_NO_DISK:
	case TDKALARM_IP_CONFLICT:
	{
		str = "--";
	}
	break;
	case TDKALARM_SHELTER:
	case TDKALARM_MOTION:
	case TDKALARM_CROSSLINE:
	case TDKALARM_AREA_INTRUSION:
	case TDKALARM_REGION_ENTRANCE:
	case TDKALARM_REGION_EXIT:
	case TDKALARM_FAST_MOVE:
	case TDKALARM_OBJECT_UNATTEND:
	case TDKALARM_OBJECT_MISS:
	case TDKALARM_FACE_DETECT:
	case TDKALARM_LOITER_DETECT:
	case TDKALARM_PARK_DETECT:
	case TDKALARM_PEOPLE_GATHER:
	{
		str.Format(L"%d-%d", alarm->chn + 1, alarm->number + 1);
	}
	break;
	default:
		break;
	}
	m_alarmlist.SetItemText(Item, 2, str);
	m_alarmlist.SetItemText(Item, 3, alarm->status == 1 ? L"start" : L"stop");
	return 0;
}

int CAlarm::callback_alarm(void* context, TDKU32 cmd, void* param0, void* param1, void* param2)
{
	CAlarm* pthis = (CAlarm*)context;
	TDK_ALARM_INFO* palarminfo = (TDK_ALARM_INFO*)param1;
	if (!palarminfo || cmd != TDKALARM_MSG_ALARM)
	{
		return TDK_OK;;
	}
	for (int i = 0; i < palarminfo->count; i++)
	{
		TDK_ALARM_INFO_CHN* alarm = (TDK_ALARM_INFO_CHN*)(&palarminfo->info[i]);
		pthis->OnDealAlarm(alarm);
	}
	return 0;
}


BOOL CAlarm::DestroyWindow()
{
	// TODO:  ڴרô/û
	OnBnClickedButtonStop();
	return __super::DestroyWindow();
}


void CAlarm::OnBnClickedButtonClear()
{
	// TODO:  ڴӿؼ֪ͨ
	m_alarmlist.DeleteAllItems();
}

int CAlarm::callback_snapshot(void* context, TDKU32 cmd, void* param0, void* param1, void* param2)
{
	if (cmd == TDKSNAPSHOT_MSG_STATE)
	{
		TRACE("Snapshot Stream State = %d, error = %d\n", param1, param2);
		return 0;
	}
	CAlarm* pthis = (CAlarm*)context;
	if (cmd == TDKSNAPSHOT_MSG_DATA)
	{
		TDK_SNAPSHOT_INFO* palarminfo = (TDK_SNAPSHOT_INFO*)param1;
		if (!palarminfo)
		{
			return TDK_OK;;
		}

		for (unsigned int i = 0; i < palarminfo->alarmCount; i++)
		{
			TDK_ALARM_INFO_CHN* pchnalarm = &palarminfo->alarmInfo[i];
			pthis->OnDealAlarm(pchnalarm);
		}

		CString time;
		SYSTEMTIME systime;
		GetLocalTime(&systime);
		time.Empty();
		time.Format(L"%02d-%02d-%02d", systime.wHour, systime.wMinute, systime.wSecond);

		string picName;
		picName = "D:\\";
		string tmp;
		CStringW2string(time, tmp, CP_ACP);
		picName += tmp;
		picName += ".jpg";
		FILE* file = NULL;
		fopen_s(&file, picName.c_str(), "wb");
		int err = GetLastError();
		if (file)
		{
			fwrite(palarminfo->pic.data, palarminfo->pic.len, 1, file);
			fclose(file);
		}
	}
	
	return 0;
}
//void CAlarm::OnBnClickedButtonAlarmSnapshotUpload()
//{
//	// TODO:  ڴӿؼ֪ͨ
//	BeginWaitCursor();
//	m_hSnapshot = TDKSnapshot_Create();
//	if (!m_hCBSnapshot)
//		m_hCBSnapshot = TDKCBCreate(this, (TDKCALLBACK)callback_snapshot);
//	int ret = TDKSnapshot_Attach(m_hSnapshot,m_hCBSnapshot);
//	if (ret != TDK_OK)
//	{
//		EndWaitCursor();
//		return;
//	}
//	GetLoginInfo();
//	std::string strurl;
//	CStringW2string(m_url, strurl, CP_ACP);
//	ret = TDKSnapshot_Open(m_hSnapshot, strurl.c_str(), m_username.c_str(), m_password.c_str());
//	if (ret != TDK_OK)
//	{
//		TDKSnapshot_Detach(m_hSnapshot, m_hCBSnapshot);
//		TDKSnapshot_Delete(m_hSnapshot);
//		m_hSnapshot = NULL;
//	}
//	EndWaitCursor();
//}
//
//
//void CAlarm::OnBnClickedButtonAlarmSnapshotUpload2()
//{
//	// TODO:  ڴӿؼ֪ͨ
//	if (m_hSnapshot)
//	{
//		TDKSnapshot_Close(m_hSnapshot);
//		TDKSnapshot_Detach(m_hSnapshot, m_hCBSnapshot);
//		TDKSnapshot_Delete(m_hSnapshot);
//		m_hSnapshot = NULL;
//	}
//	if (m_hCBSnapshot)
//	{
//		TDKCBDelete(m_hCBSnapshot);
//		m_hCBSnapshot = NULL;
//	}
//}
