#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <pthread.h>
#include <unistd.h>
#include "TDKSDK.h"

typedef struct tag_STREAMCTX
{
	//	预览流
	TDKHANDLE 	hStream;
	TDKHANDLE 	hCallback;
	int streamID;
}STREAMCTX, *PSTREAMCTX;

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//	预览流回调函数
//	
int TDKAPI OnSTREAMCallback(void* context, TDKU32 cmd, void* param0, void* param1, void* param2)
{
	//return 0;
	//printf("%s(%d)----->context = %p, cmd = %d, p0 = %p, p1 = %p, p2 = %p\n", __FUNCTION__, __LINE__, stream, cmd, param0, param1, param2);
	if( cmd == TDKPLAYER_MSG_STATE)
	{
		//	流的状态回调
		TDKU32 state = (TDKU32)(size_t)param1;
		TDKS32 error = (TDKS32)(size_t)param2;
		printf("%s----->state = %d, error = %d\n", __FUNCTION__, state, error);
	}

	else if( cmd == TDKPLAYER_MSG_FRAME)
	{
	}
#if 1
	else if( cmd == TDKPLAYER_MSG_PACKET)
	{
		TDK_FRAMEHEAD* head = (TDK_FRAMEHEAD*)param1;
		if( head != NULL )
		{
			unsigned char* data = (unsigned char*)(head + 1);			
			if( head->codec == TDKCODEC_H264 || ( head->codec >= TDKCODEC_H264P(0) && head->codec <= TDKCODEC_H264P(15) ) )
			{
				// H264 码流帧				
				printf("H264====>codec = %d, w = %d, h = %d, type = %d, len = %d, data = %p\n", head->codec, head->width, head->height, head->prefix[3] - TDKFRAME_BASE, head->length, data);				
			}
			else if( head->codec == TDKCODEC_H265 || ( head->codec >= TDKCODEC_H265P(0) && head->codec <= TDKCODEC_H265P(15) ) )
			{
				// H265 码流帧				
				printf("H265====>codec = %d, w = %d, h = %d, type = %d, len = %d, data = %p\n", head->codec, head->width, head->height, head->prefix[3] - TDKFRAME_BASE, head->length, data);						
			}
			else if( head->codec == TDKCODEC_PCMA || head->codec == TDKCODEC_PCMU )
			{
				//	PCM-A/PCM-U 音频帧				
				printf("H265=====>codec = %d, frequency = %d, type = %d, len = %d, data = %p\n", head->codec, head->freq, head->prefix[3] - TDKFRAME_BASE, head->length, data);
			}
			else if( head->codec == TDKCODEC_SMART )
			{
				//	智能帧				
				printf("SMART====>codec = %d, length = %d, data = %p\n", head->codec, head->length, data);
			}
			else
			{
				//	未知帧
				printf("Unknown==>codec = %d, type = %d, len = %d, data = %p\n", head->codec, head->prefix[3] - TDKFRAME_BASE, head->length, data);
			}
		}		
	}
	else if(cmd == TDKSMART_MSG_FRAME)
	{
		STREAMCTX* stream = (STREAMCTX*)context;
		TDKHANDLE hFrame = param1;
		if (!hFrame)
		{
			return 0;
		}
		int cnt = TDKSmart_Frame_GetSmartCount(hFrame, TDKSMART_OBJECT_LINE);
		printf("Line cross count = %d\n", cnt);
		for (int i = 0; i < cnt; i++ )
		{
			const TDK_SMART_OBJ* obj = TDKSmart_Frame_GetSmartInfo(hFrame,TDKSMART_OBJECT_LINE,i);
			if (obj)// && obj->state != 0)
			{
				printf("Line cross info, id = %d, state = %d, point num = %d\n",obj->id, obj->state, obj->pointnum);
				for (int i = 0; i < obj->pointnum; i++)
				{
					printf("Point x%d = %d, y%d = %d\n", i,obj->point[i].x, i, obj->point[i].y);
				}
			}
		}
		cnt = TDKSmart_Frame_GetSmartCount(hFrame, TDKSMART_OBJECT_AREA);
		//printf("Area intrusion count = %d\n", cnt);
		for (int i = 0; i < cnt; i++)
		{
			const TDK_SMART_OBJ* obj = TDKSmart_Frame_GetSmartInfo(hFrame, TDKSMART_OBJECT_AREA, i);
			if (obj && obj->state != 0)
			{
				printf("Area intrusion info, id = %d, state = %d, x1 = %d, y1 = %d, x2 = %d, y2 = %d, x3 = %d, y3 = %d, x4 = %d, y4 = %d, streamid = %d\n", obj->id, obj->state, 
					obj->point[0].x, obj->point[0].y, obj->point[1].x, obj->point[1].y, obj->point[2].x, obj->point[2].y, obj->point[3].x, obj->point[3].y, stream->streamID);
			}
		}
	}
#endif
	return 0;
}

void STREAMStart(STREAMCTX* stream, const char* uri, const char* username, const char* password)
{
	int ret;
	do
	{
		//	创建一个回调函数对象
		stream->hCallback = TDKCBCreate(stream, (TDKCALLBACK)&OnSTREAMCallback);
		if( stream->hCallback == NULL )
		{
			printf("%s(%d)---->TDKCBCreate Failed.\n", __FUNCTION__, __LINE__);
			break;
		}
		
		//	创建一个预览流播放对象
		stream->hStream = TDKPlayer_Create(NULL, 0);
		if( stream->hStream == NULL )
		{
			printf("%s(%d)---->TDKCBPlayer_Create Failed.\n", __FUNCTION__, __LINE__);
			break;
		}
		
		//	注册回调函数到流播放对象
		ret = TDKPlayer_Attach(stream->hStream, stream->hCallback);
		if( ret != TDK_OK )
		{
			printf("%s(%d)---->TDKCBPlayer_Attach Failed.(ret = %d)\n", __FUNCTION__, __LINE__, ret);
			break;
		}
		
		//	打开一个预览流
		ret = TDKPlayer_Open(stream->hStream, uri, username, password);
		if( ret != TDK_OK )
		{
			TDKPlayer_Detach(stream->hStream, stream->hCallback);
			printf("%s(%d)---->TDKCBPlayer_Open Failed.(ret = %d)\n", __FUNCTION__, __LINE__, ret);
			break;
		}
		
		//	预览流开始播放
		ret = TDKPlayer_Start(stream->hStream);
		if( ret != TDK_OK )
		{
			TDKPlayer_Close(stream->hStream);
			TDKPlayer_Detach(stream->hStream, stream->hCallback);
			printf("%s(%d)---->TDKCBPlayer_Start Failed.(ret = %d)\n", __FUNCTION__, __LINE__, ret);
			break;
		}
		printf("%s(%d)-------->uri = %s, OK\n", __FUNCTION__, __LINE__, uri);
		return;
		
	}while(0);
	if( stream->hStream != NULL )
	{
		TDKPlayer_Delete(stream->hStream);
		stream->hStream = NULL;
	}
	if( stream->hCallback != NULL )
	{
		TDKCBDelete(stream->hCallback);
		stream->hCallback = NULL;		
	}
}

void STREAMStop(STREAMCTX* stream)
{
	if( stream == NULL )
		return;
	if( stream->hStream != NULL )
	{
		TDKPlayer_Stop(stream->hStream);
		TDKPlayer_Close(stream->hStream);
		TDKPlayer_Detach(stream->hStream, stream->hCallback);
		TDKPlayer_Delete(stream->hStream);
		stream->hStream = NULL;
	}
	if( stream->hCallback != NULL )
	{
		TDKCBDelete(stream->hCallback);
		stream->hCallback = NULL;		
	}
}


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//	人脸抓图回调函数
//	
int TDKAPI OnSMARTCallback(void* context, TDKU32 cmd, void* param0, void* param1, void* param2)
{
	int 		ret;
	STREAMCTX* 	ctx = (STREAMCTX*)context;
	printf("%s(%d)----->context = %p, cmd = %d, p0 = %p, p1 = %p, p2 = %p, streamid = %d\n", __FUNCTION__, __LINE__, ctx, cmd, param0, param1, param2, ctx->streamID);
	if( cmd == TDKSMART_MSG_STATE)
	{
		//	流的状态回调
		TDKU32 state = (TDKU32)(size_t)param1;
		TDKS32 error = (TDKS32)(size_t)param2;
		printf("state = %d, error = %d, streamid = %d\n", state, error, ctx->streamID);
	}
	else if( cmd == TDKSMART_MSG_FRAME )
	{
		//	收到智能图片帧
		TDKHANDLE 	hFrame = (TDKHANDLE)param1;
		
		
		if( hFrame != NULL )
		{
			TDK_SMART_PIC 	pic;
			int 			facenum = 0;
			int 			idx;
			
			
			//	获取全图			
			memset(&pic, 0, sizeof(TDK_SMART_PIC) );
			ret = TDKSmart_Frame_GetPicture(hFrame, &pic);
			if( ret == TDK_OK )
			{
				//	其中pic.data中包含全图人脸照片的JPEG图片数据，长度为pic.len, 可以直接存成jpg文件
				printf("Full Picture: w = %d, h = %d, len = %d, data = %p, name = %s, sn = %s, info = %s, streamid = %d\n", 
					pic.w, pic.h, pic.len, pic.data, pic.name, pic.serialno, pic.info, ctx->streamID);
			}
			
			//	获取人脸张数
			facenum = TDKSmart_Frame_GetFaceNum(hFrame);			
			printf("Face number = %d, streamid = %d\n", facenum, ctx->streamID);
			
			//	获取每张人脸的属性
			for( idx = 0; idx < facenum; idx++)
			{
				TDKHANDLE hFace = TDKSmart_Frame_GetFace(hFrame, idx);
				if( hFace == NULL )
					continue;
				//	获取人脸基本属性
				const TDK_FACEOBJ* 		obj = TDKSmart_Face_GetInfo(hFace);
				if( obj == NULL )
					continue;
				printf("Face(ID = %d): Quality = %d, lefttop{%d, %d), rightend{%d, %d) flag = 0x%08x, attr = 0x%08x, streamid = %d\n",
						obj->id, obj->quality, obj->lefttop.x, obj->lefttop.y, obj->rightend.x, obj->rightend.y,
						obj->attrEffectFlag, obj->attr, ctx->streamID);
							
				//	获取人脸识别结果
				const TDK_FACE_ATTR* 	attr= TDKSmart_Face_GetAttr(hFace);
				if( attr != NULL )
				{
					printf("Face(ID = %d): sim = %d, age = %d, attractive = %d, glasses = %d, race = %d, emotion = %d, name = %s, streamid = %d\n",
						obj->id, attr->sim, attr->age, attr->attractive, attr->glasses, attr->race, attr->emotion, attr->name, ctx->streamID);
				}				
				
				//	获取人脸照片
				memset(&pic, 0, sizeof(TDK_SMART_PIC) );
				ret = TDKSmart_Face_GetPicture(hFace, &pic);
				if( ret == TDK_OK)
				{
					//	其中pic.data中包含人脸照片的JPEG图片数据，长度为pic.len, 可以直接存成jpg文件
					printf("Face(ID = %d): w = %d, h = %d, len = %d, data = %p, name = %s, sn = %s, info = %s, streamid = %d\n",  obj->id, 
						pic.w, pic.h, pic.len, pic.data, pic.name, pic.serialno, pic.info, ctx->streamID);
				}				
			}
			
		}		
	}
	return 0;
}

void SMARTStart(STREAMCTX* context, const char* address, unsigned short port, const char* username, const char* password)
{
	int 		ret;
	do
	{
		//	创建一个回调函数对象
		context->hCallback = TDKCBCreate(context, (TDKCALLBACK)&OnSMARTCallback);
		if( context->hCallback == NULL )
		{
			printf("TDKCBCreate Failed.\n");
			break;
		}
		//	创建一个智能流对象
		context->hStream = TDKSmart_Create();
		if( context->hStream  == NULL )
		{
			printf("TDKSmart_Create Fail.\n");
			break;
		}
		
		//	注册回调函数到智能流对象
		ret = TDKSmart_Attach(context->hStream, context->hCallback);
		if( ret != TDK_OK)
		{
			printf("TDKSmart_Attach Failed.( ret = %d)\n", ret);
			break;
		}
		
		//	启动智能流
		ret = TDKSmart_Open(context->hStream, address, port, username, password);
		if( ret != TDK_OK )
		{
			printf("TDKSmart_Open Failed( address = %s, ret = %d)\n", address?address:"", ret);
			break;
		}		
		printf("Smart Stream( IP = %s, Port = %d) Started.\n", address, port);
		return;
	}while(0);

	//	删除智能流对象
	if( context->hStream != NULL )	
	{
		TDKSmart_Delete(context->hStream);	
		context->hStream = NULL;
	}
	
	//	删除回调对象
	if( context->hCallback != NULL )
	{
		TDKCBDelete(context->hCallback);
		context->hCallback = NULL;
	}
}

void SMARTStop(STREAMCTX* context)
{
	if( context->hStream != NULL )
	{
		//	关闭智能流
		TDKSmart_Close(context->hStream);
		//	取消回调函数
		TDKSmart_Detach(context->hStream, context->hCallback);	
		//	删除智能流对象	
		TDKSmart_Delete(context->hStream);	
		context->hStream = NULL;
	}
	if( context->hCallback != NULL )
	{
		//	删除回调对象
		TDKCBDelete(context->hCallback);
		context->hCallback = NULL;
	}
	
}

int callback_alarm(void* context, TDKU32 cmd, void* param0, void* param1, void* param2)
{
	STREAMCTX* ctx = (STREAMCTX*)context;
	TDK_ALARM_INFO* palarminfo = (TDK_ALARM_INFO*)param1;
	if (!palarminfo || cmd != TDKALARM_MSG_ALARM)
	{
		printf("Invalid parameter!!!\n");
		return TDK_OK;;
	}
	TDKU16 type = palarminfo->type;
	switch (type)
	{
	case TDKALARM_PORT_ALARMIN:
	case TDKALARM_MOTION:
	case TDKALARM_VIDEOLOST:
	case TDKALARM_SHELTER:
	case TDKALARM_DISKERROR:
	case TDKALARM_HDD_SMART:
		{
							  int cnt = palarminfo->count;
							  for (int i = 0; i < cnt; i++)
							  {
								  TDK_ALARM_INFO_CHN* pchnalarm = (TDK_ALARM_INFO_CHN*)(&palarminfo->info[i]);
								  if (pchnalarm->status == 0)
								  {
									  continue;
								  }								  
								  printf("Alarm type = %d, chn = %d, streamid = %d\n", type, pchnalarm->chn+1, ctx->streamID);
							  }
		}
		break;
	case TDKALARM_DISKFULL:
	case TDKALARM_NO_DISK:
	case TDKALARM_IP_CONFLICT:
	{
		printf("Alarm type = %d, chn = --, streamid = %d\n", type, ctx->streamID);
	}
		break;
	case TDKALARM_CROSSLINE:
	case TDKALARM_AREA_INTRUSION:
	case TDKALARM_REGION_ENTRANCE:
	case TDKALARM_REGION_EXIT:
	case TDKALARM_FAST_MOVE:
	case TDKALARM_OBJECT_UNATTEND:
	case TDKALARM_OBJECT_MISS:
	case TDKALARM_FACE_DETECT:
	case TDKALARM_LOITER_DETECT:
	case TDKALARM_PARK_DETECT:
	case TDKALARM_PEOPLE_GATHER:
	{
		int cnt = palarminfo->count;
		for (int i = 0; i < cnt; i++)
		{
			TDK_ALARM_INFO_CHN* pchnalarm = (TDK_ALARM_INFO_CHN*)(&palarminfo->info[i]);
			if (pchnalarm->status == 0)
			{
				continue;
			}
			printf("Alarm type = %d, chn = %d, id = %d, streamid = %d\n", type, pchnalarm->chn+1, pchnalarm->number+1, ctx->streamID);
		}
	}
		break;
	default:
		printf("Unknown alarm type!!!!\n");
		break;
	}
	return 0;
}

void AlarmStart(STREAMCTX* context, const char* uri, const char* username, const char* password)
{
	int 		ret;
	do
	{
		//	创建一个回调函数对象
		context->hCallback = TDKCBCreate(context, (TDKCALLBACK)&callback_alarm);
		if( context->hCallback == NULL )
		{
			printf("TDKCBCreate Failed.\n");
			break;
		}
		//	创建一个智能流对象
		context->hStream = TDKAlarm_Create();
		if( context->hStream  == NULL )
		{
			printf("TDKAlarm_Create Fail.\n");
			break;
		}
		
		//	注册回调函数到智能流对象
		ret = TDKAlarm_Attach(context->hStream, context->hCallback);
		if( ret != TDK_OK)
		{
			printf("TDKAlarm_Attach Failed.( ret = %d)\n", ret);
			break;
		}
		
		//	启动智能流
		ret = TDKAlarm_Open(context->hStream, uri, username, password);
		if( ret != TDK_OK )
		{
			printf("TDKAlarm_Open Failed( address = %s, ret = %d)\n", uri?uri:"", ret);
			break;
		}		
		printf("Alarm listen( IP = %s) Started.chnid = %d\n", uri,context->streamID);
		return;
	}while(0);

	//	删除智能流对象
	if( context->hStream != NULL )	
	{
		TDKAlarm_Delete(context->hStream);	
		context->hStream = NULL;
	}
	
	//	删除回调对象
	if( context->hCallback != NULL )
	{
		TDKCBDelete(context->hCallback);
		context->hCallback = NULL;
	}
}

void AlarmStop(STREAMCTX* context)
{
	if( context->hStream != NULL )
	{
		//	关闭智能流
		TDKAlarm_Close(context->hStream);
		//	取消回调函数
		TDKAlarm_Detach(context->hStream, context->hCallback);	
		//	删除智能流对象	
		TDKAlarm_Delete(context->hStream);	
		context->hStream = NULL;
	}
	if( context->hCallback != NULL )
	{
		//	删除回调对象
		TDKCBDelete(context->hCallback);
		context->hCallback = NULL;
	}
	
}
STREAMCTX	stream[64];
STREAMCTX	stream2[64];
STREAMCTX	face[64];
STREAMCTX	alarmctx[64];
STREAMCTX	device[64];
int chnnum = 1;
char ip[128] = "192.168.12.150";
unsigned short port = 34567;
char name[64] = "admin";
char pwd[64] = "";

void* fun_face(void* args)
{
	STREAMCTX* smart = (STREAMCTX*)args;
	while(1){
		printf("Face detect Start !!!!!\n");
		SMARTStart(smart, ip,port, name, pwd);
		break;
		usleep(10*1000);
		SMARTStop(smart);
		printf("face detect stop !!!!!\n");
	}
	return 0;
}
void* fun_stream(void* args)
{
	STREAMCTX* stream = (STREAMCTX*)args;
	while(1){
		printf("stream Start !!!!!, streamid = %d\n", stream->streamID);
		char uri[128] = {0};
		sprintf(uri,"tdk://%s:%d/mode=real&idc=1&ids=1",ip,port);
		STREAMStart(stream, uri, name, pwd);
		break;
		usleep(10*1000);
		STREAMStop(stream);
		printf("stream stop !!!!!\n");
	}
	return 0;
}

void* fun_stream2(void* args)
{
	STREAMCTX* stream = (STREAMCTX*)args;
	while(1){
		printf("stream2 Start !!!!!, streamid = %d\n", stream->streamID);
		char uri[128] = {0};
		sprintf(uri,"tdk://%s:%d/mode=real&idc=1&ids=2",ip,port);
		STREAMStart(stream, uri, name, pwd);
		break;
		usleep(10*1000);
		STREAMStop(stream);
		printf("stream stop !!!!!\n");
	}
	return 0;
}
void* fun_alarm(void* args)
{
	STREAMCTX* alarm = (STREAMCTX*)args;
	while(1){
		printf("Alarm Start !!!!!\n");
		char uri[128] = {0};
		sprintf(uri,"tdk://%s:%d",ip,port);
		AlarmStart(alarm, uri,name, pwd);
		break;
		usleep(10*1000);
		AlarmStop(alarm);
		printf("Alarm stop !!!!!\n");
	}
	return 0;
}
int openpreview()
{
	pthread_t threads[64];
	memset(&stream, 0, sizeof(STREAMCTX)*64 );
	//printf("Open Preview.\n", );
	
	for(int i = 0;i<chnnum;i++)	{
		if(stream[i].hStream == NULL)
		{
			stream[i].streamID = i;
			pthread_create(&threads[i], NULL, fun_stream,(void*)&(stream[i]));				
		}
	}
	return 0;
}
int closepreview()
{
	for(int i = 0;i<chnnum;i++)	{
		printf("stream stop !!!!!, streanid = %d\n",stream[i].streamID);
		STREAMStop(&stream[i]);
	}
	return 0;
}

int openpreview2()
{
	pthread_t threads[64];
	memset(&stream2, 0, sizeof(STREAMCTX)*64 );
	//printf("Open Preview.\n", );
	
	for(int i = 0;i<chnnum;i++)	{
		if(stream2[i].hStream == NULL)
		{
			stream2[i].streamID = i;
			pthread_create(&threads[i], NULL, fun_stream2,(void*)&(stream2[i]));				
		}
	}
	return 0;
}
int closepreview2()
{
	for(int i = 0;i<chnnum;i++)	{
		printf("stream2 stop !!!!!, streanid = %d\n",stream2[i].streamID);
		STREAMStop(&stream2[i]);
	}
	return 0;
}
int openface()
{
	pthread_t threads[64];
	memset(&face, 0, sizeof(STREAMCTX)*64 );
	//printf("Open face detect.\n");
	
	for(int i = 0;i<chnnum;i++)	{
		if(face[i].hStream == NULL)
		{
			face[i].streamID = i;
			pthread_create(&threads[i], NULL, fun_face,(void*)&(face[i]));			
		}

	}
	return 0;
}
int closeface()
{
	for(int i = 0;i<chnnum;i++)	{
		printf("face detect stop !!!!!, streamid = %d\n",face[i].streamID);
		SMARTStop(&face[i]);
	}
	return 0;
}

int openalarm()
{
	pthread_t threads[64];
	memset(&alarmctx, 0, sizeof(STREAMCTX)*64 );
	//printf("Open face detect.\n");
	
	for(int i = 0;i<chnnum;i++)	{
		if(alarmctx[i].hStream == NULL)
		{
			alarmctx[i].streamID = i;
			pthread_create(&threads[i], NULL, fun_alarm,(void*)&(alarmctx[i]));			
		}
	}
	return 0;
}
int closealarm()
{
	for(int i = 0;i<chnnum;i++)	{
		printf("alarm stop !!!!!, streamid = %d\n",alarmctx[i].streamID);
		AlarmStop(&alarmctx[i]);
	}
	return 0;
}
void* opendevice(void* args)
{
	STREAMCTX* device = (STREAMCTX*)args;
	while(1)
	{
		device->hStream = TDKDevice_Create();
		if (device->hStream == NULL)
			return 0;
		int ret = TDKDevice_Open(device->hStream, ip, port, name, pwd);
		if (ret != TDK_OK)
		{
			printf("open device failed!\n");
			TDKDevice_Delete(device->hStream);
			device->hStream = NULL;
			return 0;
		}
		printf("open device ok!, id = %d\n",device->streamID);
		break;
		usleep(10000);
		
		TDKDevice_Close(device->hStream);
		TDKDevice_Delete(device->hStream);
		device->hStream = NULL;
	}
	return 0;
}
void* closedevice(void* args)
{
	STREAMCTX* device = (STREAMCTX*)args;
	if(!device)
		return 0;
	printf("close device(id = %d)!\n",device->streamID);
	TDKDevice_Close(device->hStream);
	printf("delete device(id = %d) start!, handle = %p\n",device->streamID,device->hStream);
	TDKDevice_Delete(device->hStream);
	//int h = (int)(device->hStream);
	//h+=1;
	//device->hStream = NULL;
	//TDKDevice_Delete((void*)h);
	//TDKDevice_Delete(device->hStream);
	printf("delete device(id = %d) OK!\n",device->streamID);
	device->hStream = NULL;
	return 0;
}
int opendevice()
{
	pthread_t threads[64];
	memset(&device, 0, sizeof(STREAMCTX)*64 );
	//printf("Open face detect.\n");
	
	for(int i = 0;i<chnnum;i++)	{
		if(device[i].hStream == NULL)
		{
			device[i].streamID = i;
			pthread_create(&threads[i], NULL, opendevice,(void*)&(device[i]));			
		}
	}
	return 0;
}
int closedevice()
{
	for(int i = 0;i<chnnum;i++)	{
		printf("close device !!!!!, streamid + %d\n",device[i].streamID);
		closedevice(&device[i]);
	}
	return 0;
}



void* openall(void* args)
{
	int index = (int)(size_t)args;
	stream[index].streamID = 0;
	stream2[index].streamID = 0;
	alarmctx[index].streamID = 0;
	face[index].streamID = 0;
	device[index].streamID = 0;
	while(1)
	{	
		fun_stream(&stream[index]);
		fun_stream2(&stream2[index]);
		fun_alarm(&alarmctx[index]);
		fun_face(&face[index]);
		//opendevice(&device[index]);
		
		usleep(500000);
		
		STREAMStop(&stream[index]);
		STREAMStop(&stream2[index]);
		AlarmStop(&alarmctx[index]);
		SMARTStop(&face[index]);
		//closedevice(&device[index]);
	}
	
	return 0;
}

int openall()
{
	pthread_t threads[64];
	for(int i = 0;i < chnnum; i++)
	{
		pthread_create(&threads[i], NULL, openall,(void*)(size_t)i);		
	}
	return 0;
}

int gettime()
{
	TDKHANDLE hdevice = TDKDevice_Create();
	if (hdevice == NULL)
		return TDK_FAIL;
	int ret = TDKDevice_Open(hdevice, ip, port, name, pwd);
	if (ret != TDK_OK)
	{
		TDKDevice_Delete(hdevice);
		return ret;
	}
	TDK_TIME_CONFIG time;
	memset(&time, 0, sizeof(TDK_TIME_CONFIG));
	ret = TDKDevice_GetTime(hdevice, &time);
	if(ret == TDK_OK)
	{
		int timezone = (int)time.timezone;
		printf("%s(%d)====>GET,time zone = %d,%04d-%02d-%02d %02d:%02d:%02d\n",__FUNCTION__ ,__LINE__, timezone,
		time.time.year,time.time.month,time.time.day,time.time.hour,time.time.minute,time.time.second);
	}
	time.time.hour = 2;
	time.time.minute = 2;
	time.time.second = 2;
	ret = TDKDevice_SetTime(hdevice,&time);
	if(ret == TDK_OK)
	{
		int timezone = (int)time.timezone;
		printf("%s(%d)====>SET,time zone = %d,%04d-%02d-%02d %02d:%02d:%02d\n",__FUNCTION__ ,__LINE__, timezone,
		time.time.year,time.time.month,time.time.day,time.time.hour,time.time.minute,time.time.second);		
	}
	TDKDevice_Close(hdevice);
	TDKDevice_Delete(hdevice);
	return ret;
}
#if 1
int main(int argc, char* argv[])
{
#if 0
	SMARTDEMO 	context;	
	STREAMCTX	stream;
	memset(&context, 0, sizeof(SMARTDEMO) );
	memset(&stream, 0, sizeof(STREAMCTX) );
	printf("Hello World.\n");
	TDKSDKInitialize();
	
	STREAMStart(&stream, "tdk://192.168.11.247:34567/mode=real&idc=1&ids=1", "admin", NULL);
	//SMARTStart(&context, "192.168.11.247", 34567, "admin", NULL);
	while( 1 )
	{
		int ch = getchar();
		if( ch == 'q' || ch == 'Q' )
			break;
	}
	//SMARTStop(&context);
	STREAMStop(&stream);
#else
	printf("Hello World.\n");
	TDKSDKInitialize();
	
	memset(&face, 0, sizeof(STREAMCTX)*64 );
	memset(&stream, 0, sizeof(STREAMCTX)*64 );
	memset(&stream2, 0, sizeof(STREAMCTX)*64 );
	memset(&alarmctx, 0, sizeof(STREAMCTX)*64 );
#if 0
	//openall();
	
#else
	openpreview();
	//openpreview2();
	openalarm();
	//openface();	
#endif
	TDK_OSD_CONFIG osdcfg;
	TDKDevice_GetOSDConfig(NULL,&osdcfg);
	//pthread_exit(NULL);
	char* line = NULL;
	size_t		size = 0;
	while( 1 )
	{
		int ret = getline(&line, &size, stdin);
		if( ret > 0 && line != NULL)
		{
			line[ret-1] = '\0';
			if (strncasecmp(line, "open preview",strlen("open preview")) == 0)
				openpreview();
			if (strncasecmp(line, "close preview", strlen("close preview")) == 0)
				closepreview();
			if (strncasecmp(line, "open preview2",strlen("open preview2")) == 0)
				openpreview2();
			if (strncasecmp(line, "close preview2", strlen("close preview2")) == 0)
				closepreview2();
			if (strncasecmp(line, "open face", strlen("open face")) == 0)
				openface();
			if (strncasecmp(line, "close face",strlen("close face")) == 0)
				closeface();
			if (strncasecmp(line, "open alarm", strlen("open alarm")) == 0)
				openalarm();
			if (strncasecmp(line, "close alarm", strlen("close alarm")) == 0)
				closealarm();
			if (strncasecmp(line, "get time", strlen("get time")) == 0)
				gettime();				
			//if (strncasecmp(line, "close all", strlen("close all")) == 0)
				//closeall();				
			if (strncasecmp(line, "open all", strlen("open all")) == 0)
				openall();
			if (strncasecmp(line, "open device", strlen("open device")) == 0)
				opendevice();
			if (strncasecmp(line, "close device", strlen("close device")) == 0)
				closedevice();
			if (strncasecmp(line, "q", strlen("q")) == 0 || strncasecmp(line, "quit", strlen("quit")) == 0)
				break;
		}
		else
			usleep(1000);			
	}
#endif
	closepreview2();
	closepreview();
	closeface();
	closealarm();
		
	TDKSDKInvalidate();
	printf("Bye Bye!!!!\n");
	return 0;
}
#endif
#if 0
int main(int argc, char* argv[])
{
		printf("Hello World.\n");
		TDKSDKInitialize();
		TDKHANDLE deviceH = TDKDevice_Create();
		if (deviceH == NULL);
			//return -1;
		int ret = TDKDevice_Open(deviceH, "192.168.2.102",34567,"admin","admin");
		if (ret != TDK_OK) {
				printf("TDK open device return with:%d\n",ret);
				TDKDevice_Delete(deviceH);
				//return -1;
		}
		TDK_TIME_CONFIG deviceTime = {0};
		deviceTime.time.year = 2018;
		deviceTime.time.month = 12;
		deviceTime.time.day = 1;
		deviceTime.time.hour = 0;
		deviceTime.time.minute = 0;
		deviceTime.time.second = 0;
		deviceTime.time.isdst = 0;
		printf("TDK set system time!\n");
		ret = TDKDevice_SetTime(deviceH,&deviceTime);
		if(ret != TDK_OK)
		{
			printf("TDK set system time return with:%d\n",ret);
		}
		while( 1 )
		{
				int ch = getchar();
				if( ch == 'q' || ch == 'Q' )
					break;
		}
		if(deviceH != NULL) {
				TDKDevice_Close(deviceH);
				TDKDevice_Delete(deviceH);
				deviceH = NULL;
		}
		TDKSDKInvalidate();
		printf("Bye Bye!!!!\n");
		return 0;
}
#endif